/*
 * Decompiled with CFR 0.152.
 */
package tot.dao.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.bean.DataField;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.exception.DatabaseException;
import tot.exception.ObjectNotFoundException;
import tot.util.MD5;

public class MemberDaoImplJDBC
extends AbstractDao {
    private static Log log = LogFactory.getLog(MemberDaoImplJDBC.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean findByUserId(String userid) {
        boolean returnValue;
        block5: {
            returnValue = false;
            Connection conn = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement("select * from t_member where UserId=?");
                ps.setString(1, userid);
                rs = ps.executeQuery();
                returnValue = rs.next();
                DBUtils.closeResultSet(rs);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block5;
            }
            finally {
                DBUtils.closeResultSet(rs);
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean findByEmail(String email) {
        boolean returnValue;
        block5: {
            returnValue = false;
            Connection conn = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement("select * from t_member where Email=?");
                ps.setString(1, email);
                rs = ps.executeQuery();
                returnValue = rs.next();
                DBUtils.closeResultSet(rs);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block5;
            }
            finally {
                DBUtils.closeResultSet(rs);
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVip(String uid) {
        boolean returnValue;
        block5: {
            returnValue = false;
            Connection conn = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement("select * from t_member where Vip=1 and UserId=?");
                ps.setString(1, uid);
                rs = ps.executeQuery();
                returnValue = rs.next();
                DBUtils.closeResultSet(rs);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block5;
            }
            finally {
                DBUtils.closeResultSet(rs);
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocked(String uid) {
        boolean returnValue;
        block5: {
            returnValue = false;
            Connection conn = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement("select * from t_member where IsLock=1 and UserId=?");
                ps.setString(1, uid);
                rs = ps.executeQuery();
                returnValue = rs.next();
                DBUtils.closeResultSet(rs);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block5;
            }
            finally {
                DBUtils.closeResultSet(rs);
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getMoney(String uid) {
        float returnValue;
        block6: {
            Connection conn = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            returnValue = 0.0f;
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement("select Money from t_member where UserId=?");
                ps.setString(1, uid);
                rs = ps.executeQuery();
                if (rs.next()) {
                    returnValue = rs.getFloat(1);
                }
                DBUtils.closeResultSet(rs);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                DBUtils.closeResultSet(rs);
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getScore(String uid) {
        int returnValue;
        block6: {
            Connection conn = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            returnValue = 0;
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement("select Score from t_member where UserId=?");
                ps.setString(1, uid);
                rs = ps.executeQuery();
                if (rs.next()) {
                    returnValue = rs.getInt(1);
                }
                DBUtils.closeResultSet(rs);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                DBUtils.closeResultSet(rs);
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkPassAsk(String userid, String passask, String passanswer) {
        boolean returnValue = false;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = DBUtils.getConnection();
            ps = conn.prepareStatement("select PassAnswer from t_member where UserId=? and PassAsk=?");
            ps.setString(1, userid);
            ps.setString(2, passask);
            rs = ps.executeQuery();
            returnValue = rs.next() ? rs.getString(1).equals(passanswer) : false;
            DBUtils.closeResultSet(rs);
        }
        catch (SQLException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            DBUtils.closeResultSet(rs);
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reg(String userid, String passwd, String passask, String passanswer, String sex, String area, String address, String email, String tel, String mobile, String realname, String im, String homepage, String regip, Timestamp regtime, int isverified, String verifycode) {
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue = true;
        String sql = "insert into t_member(UserId,UserPass,PassAsk,PassAnswer,Sex,Area,Address,Email,Tel,Mobile,RealName,Im,HomePage,RegIp,RegTime,IsVerified,VerifyCode) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        try {
            MD5 md5 = new MD5();
            String password = md5.getMD5of32(passwd);
            conn = DBUtils.getConnection();
            ps = conn.prepareStatement(sql);
            ps.setString(1, userid);
            ps.setString(2, passwd);
            ps.setString(3, passask);
            ps.setString(4, passanswer);
            ps.setString(5, sex);
            ps.setString(6, area);
            ps.setString(7, address);
            ps.setString(8, email);
            ps.setString(9, tel);
            ps.setString(10, mobile);
            ps.setString(11, realname);
            ps.setString(12, im);
            ps.setString(13, homepage);
            ps.setString(14, regip);
            ps.setTimestamp(15, regtime);
            ps.setInt(16, isverified);
            ps.setString(17, verifycode);
            if (ps.executeUpdate() != 1) {
                returnValue = false;
            }
        }
        catch (SQLException e) {
            boolean bl;
            try {
                e.printStackTrace();
                bl = false;
            }
            catch (Throwable throwable) {
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
                throw throwable;
            }
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
            return bl;
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mod(String userid, String sex, String age, String province, String city, String area, String address, String email, String tel, String mobile, String realname, String im, String homepage, String nation, String polityface, String edudegree, String edusubject, String postcode, String finishschool) {
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue = true;
        String sql = "update t_member set Sex=?,Age=?,Province=?,City=?,Area=?,Address=?,Email=?,Tel=?,Mobile=?,RealName=?,Im=?,HomePage=?,Nation=?,PolityFace=?,EduDegree=?,EduSubject=?,PostCode=?,FinishSchool=? where UserId=?";
        try {
            MD5 md5 = new MD5();
            conn = DBUtils.getConnection();
            ps = conn.prepareStatement(sql);
            ps.setString(1, sex);
            ps.setString(2, age);
            ps.setString(3, province);
            ps.setString(4, city);
            ps.setString(5, area);
            ps.setString(6, address);
            ps.setString(7, email);
            ps.setString(8, tel);
            ps.setString(9, mobile);
            ps.setString(10, realname);
            ps.setString(11, im);
            ps.setString(12, homepage);
            ps.setString(13, nation);
            ps.setString(14, polityface);
            ps.setString(15, edudegree);
            ps.setString(16, edusubject);
            ps.setString(17, postcode);
            ps.setString(18, finishschool);
            ps.setString(19, userid);
            if (ps.executeUpdate() != 1) {
                returnValue = false;
            }
            DBUtils.closePrepareStatement(ps);
        }
        catch (SQLException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modBank(String userid, String bankid, String bankprovince, String bankcity, int banktype, String bankname, String idcard) {
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue = true;
        String sql = "update t_member set BankId=?,BankProvince=?,BankCity=?,BankType=?,BankName=?,IDCard=? where UserId=?";
        try {
            MD5 md5 = new MD5();
            conn = DBUtils.getConnection();
            ps = conn.prepareStatement(sql);
            ps.setString(1, bankid);
            ps.setString(2, bankprovince);
            ps.setString(3, bankcity);
            ps.setInt(4, banktype);
            ps.setString(5, bankname);
            ps.setString(6, idcard);
            ps.setString(7, userid);
            if (ps.executeUpdate() != 1) {
                returnValue = false;
            }
        }
        catch (SQLException e) {
            boolean bl;
            try {
                log.error((Object)"mod error ", (Throwable)e);
                bl = false;
            }
            catch (Throwable throwable) {
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
                throw throwable;
            }
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
            return bl;
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modBankPass(String userid, String pass, String oldpass) {
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue = true;
        String sql = "update t_member set WithdrawalsPass=? where UserId=? and WithdrawalsPass=?";
        try {
            MD5 md5 = new MD5();
            conn = DBUtils.getConnection();
            ps = conn.prepareStatement(sql);
            ps.setString(1, pass);
            ps.setString(2, userid);
            ps.setString(3, oldpass);
            if (ps.executeUpdate() != 1) {
                returnValue = false;
            }
        }
        catch (SQLException e) {
            boolean bl;
            try {
                log.error((Object)"mod error ", (Throwable)e);
                bl = false;
            }
            catch (Throwable throwable) {
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
                throw throwable;
            }
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
            return bl;
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean changePass(String userid, String passwd) {
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue = true;
        String sql = "update t_member set UserPass=? where UserId=?";
        try {
            MD5 md5 = new MD5();
            String password = md5.getMD5of32(passwd);
            conn = DBUtils.getConnection();
            ps = conn.prepareStatement(sql);
            ps.setString(1, passwd);
            ps.setString(2, userid);
            if (ps.executeUpdate() != 1) {
                returnValue = false;
            }
        }
        catch (SQLException e) {
            boolean bl;
            try {
                e.printStackTrace();
                bl = false;
            }
            catch (Throwable throwable) {
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
                throw throwable;
            }
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
            return bl;
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean memberVerify(String userid, String vcode) throws ObjectNotFoundException, DatabaseException {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        boolean returnValue = false;
        if (userid == null || vcode == null) {
            return false;
        }
        try {
            conn = DBUtils.getConnection();
            ps = conn.prepareStatement("select * from t_member where UserId=? and VerifyCode=?");
            ps.setString(1, userid);
            ps.setString(2, vcode);
            rs = ps.executeQuery();
            if (rs.next()) {
                returnValue = true;
            }
            DBUtils.closeResultSet(rs);
        }
        catch (SQLException e) {
            log.error((Object)"Sql Execution Error!", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            DBUtils.closeResultSet(rs);
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean memberLogin(String userid, String passwd) throws ObjectNotFoundException, DatabaseException {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        boolean returnValue = false;
        if (userid == null || passwd == null) {
            return false;
        }
        try {
            MD5 md5 = new MD5();
            String password = md5.getMD5of32(passwd);
            conn = DBUtils.getConnection();
            ps = conn.prepareStatement("select * from t_member where UserId=? and UserPass=? and IsLock=0 and IsVerified=1");
            ps.setString(1, userid);
            ps.setString(2, passwd);
            rs = ps.executeQuery();
            if (rs.next()) {
                returnValue = true;
            }
        }
        catch (SQLException e) {
            boolean bl;
            try {
                log.error((Object)"Sql Execution Error!", (Throwable)e);
                bl = false;
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(rs);
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
                throw throwable;
            }
            DBUtils.closeResultSet(rs);
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
            return bl;
        }
        DBUtils.closeResultSet(rs);
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    public boolean deleMember(String userid) throws ObjectNotFoundException, DatabaseException {
        return this.exe("delete from t_member where UserId='" + userid + "'");
    }

    public Collection getMemberList(int lock, int vip, String uid, int currentpage, int pagesize) {
        StringBuffer sql = new StringBuffer(512);
        String fieldArr = "id,UserId,Sex,Email,Mobile,Tel,RealName,Score,Money,IsChecked,IsLock,RegTime,Vip";
        if (DBUtils.getDatabaseType() == 11) {
            sql.append("select top ");
            sql.append(pagesize);
            sql.append(fieldArr);
            sql.append(" from t_member WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP " + ((currentpage - 1) * pagesize + 1) + " id  FROM t_member where 1=1");
            if (lock != 0) {
                sql.append(" and IsLock=").append(lock);
            }
            if (vip != 0) {
                sql.append(" and Vip=").append(vip);
            }
            if (uid != null) {
                sql.append(" and UserId like '%").append(uid).append("%'");
            }
            sql.append(" ORDER BY id DESC) AS t))");
            if (lock != 0) {
                sql.append(" and IsLock=").append(lock);
            }
            if (vip != 0) {
                sql.append(" and Vip=").append(vip);
            }
            if (uid != null) {
                sql.append(" and UserId like '%").append(uid).append("%'");
            }
            sql.append(" ORDER BY id DESC");
            return this.getData(sql.toString(), fieldArr);
        }
        if (DBUtils.getDatabaseType() == 15) {
            sql.append("select ");
            sql.append(fieldArr);
            sql.append(" from t_member where 1=1");
            if (lock != 0) {
                sql.append(" and IsLock=").append(lock);
            }
            if (vip != 0) {
                sql.append(" and Vip=").append(vip);
            }
            if (uid != null) {
                sql.append(" and UserId like '%").append(uid).append("%'");
            }
            sql.append(" order by id desc limit ");
            sql.append((currentpage - 1) * pagesize);
            sql.append(",");
            sql.append(pagesize);
            return this.getData(sql.toString(), fieldArr);
        }
        sql.append("select ");
        sql.append(fieldArr);
        sql.append(" from t_member where 1=1");
        if (lock != 0) {
            sql.append(" and IsLock=").append(lock);
        }
        if (vip != 0) {
            sql.append(" and Vip=").append(vip);
        }
        if (uid != null) {
            sql.append(" and UserId like '%").append(uid).append("%'");
        }
        sql.append(" order by id desc");
        return this.getDataList_Limit_Normal(sql.toString(), fieldArr, pagesize, (currentpage - 1) * pagesize);
    }

    public void updateScore(String userid, int num) throws ObjectNotFoundException, DatabaseException {
        this.exe("update t_member set Score=Score+" + num + " where UserId='" + userid + "'");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateMoney(String userid, float num) throws ObjectNotFoundException, DatabaseException {
        PreparedStatement ps;
        Connection conn;
        block12: {
            conn = null;
            ps = null;
            boolean returnValue = true;
            try {
                conn = DBUtils.getConnection();
                conn.setAutoCommit(false);
                ps = conn.prepareStatement("update t_member set Money=Money+? where UserId=?");
                ps.setFloat(1, num);
                ps.setString(2, userid);
                returnValue = ps.executeUpdate() == 1;
                conn.commit();
                if (conn == null) break block12;
            }
            catch (SQLException e) {
                try {
                    if (conn != null) {
                        try {
                            conn.rollback();
                        }
                        catch (SQLException e1) {
                            e1.printStackTrace();
                        }
                    }
                    log.error((Object)"Sql Exception Error:", (Throwable)e);
                    throw new DatabaseException("Got Exception on Call Medthod exeTransaction in tot.dao.AbstractDao");
                }
                catch (Throwable throwable) {
                    if (conn != null) {
                        try {
                            conn.rollback();
                        }
                        catch (SQLException e1) {
                            e1.printStackTrace();
                        }
                    }
                    DBUtils.closePrepareStatement(ps);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
            }
            try {
                conn.rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
    }

    public void modScore(String userid, int score) throws ObjectNotFoundException, DatabaseException {
        this.exe("update t_member set Score=" + score + " where UserId='" + userid + "'");
    }

    public void modCheck(String userid, int val) throws ObjectNotFoundException, DatabaseException {
        this.exe("update t_member set IsChecked=" + val + " where UserId='" + userid + "'");
    }

    public void modVerify(String userid) throws ObjectNotFoundException, DatabaseException {
        this.exe("update t_member set IsVerified=1 where UserId='" + userid + "'");
    }

    public void lockMember(String[] s) {
        this.bat("update t_member set IsLock=1 where id=?", s);
    }

    public void unlockMember(String[] s) {
        this.bat("update t_member set IsLock=0 where id=?", s);
    }

    public void setVip(String[] s) {
        this.bat("update t_member set Vip=1 where id=?", s);
    }

    public void cancelVip(String[] s) {
        this.bat("update t_member set Vip=0 where id=?", s);
    }

    public void batCheck(String[] s, int val) {
        this.bat("update t_member set IsChecked=" + val + " where id=?", s);
    }

    public void batDelMember(String[] s) {
        this.bat("delete from t_member where id=?", s);
    }

    public DataField getMember(int id) {
        String fields = "UserId,UserPass,PassAsk,PassAnswer,Sex,Age,Area,Address,Email,Tel,Mobile,RealName,Im,HomePage,Nation,PolityFace,EduDegree,EduSubject,PostCode,FinishSchool,IsLock,Vip,RegIp,RegTime,Province,City,IsChecked,Score,Money,IDCard,BankId,BankProvince,BankCity,BankType,BankName,WithdrawalsPass";
        return this.getFirstData("select " + fields + " from t_member where id=" + id, fields);
    }

    public DataField getMember(String userid) {
        String fields = "id,UserPass,PassAsk,PassAnswer,Sex,Age,Area,Address,Email,Tel,Mobile,RealName,Im,HomePage,Nation,PolityFace,EduDegree,EduSubject,PostCode,FinishSchool,IsLock,Vip,RegIp,RegTime,Province,City,IsChecked,Score,Money,IDCard,BankId,BankProvince,BankCity,BankType,BankName,WithdrawalsPass";
        return this.getFirstData("select " + fields + " from t_member where UserId='" + userid + "'", fields);
    }

    public int getMemberNum(int lock, int vip, String uid) {
        int returnValue = 0;
        String sql = "select count(*) from t_member where 1=1";
        if (lock != 0) {
            sql = sql + " and IsLock=" + lock;
        }
        if (vip != 0) {
            sql = sql + " and Vip=" + vip;
        }
        if (uid != null) {
            sql = sql + " and UserId like '%" + uid + "%'";
        }
        returnValue = this.getDataCount(sql);
        return returnValue;
    }
}

