/*
 * Decompiled with CFR 0.152.
 */
package tot.dao.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.bean.DataField;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.exception.DatabaseException;
import tot.exception.ObjectNotFoundException;

public class PubServerDaoImplJDBC
extends AbstractDao {
    private static Log log = LogFactory.getLog(PubServerDaoImplJDBC.class);

    public int getLastId() {
        DataField df = null;
        int returnValue = 0;
        String sql = null;
        sql = "select id from t_pubserver order by id desc";
        Collection lists = this.getDataList_Limit_Normal(sql, "id", 1, 0);
        Iterator iter = lists.iterator();
        if (iter.hasNext()) {
            df = (DataField)iter.next();
        }
        returnValue = df != null ? Integer.parseInt(df.getFieldValue("id")) + 1 : 1;
        return returnValue;
    }

    public DataField get(int id) {
        String fieldArr = "id,Title,PlayUrl,DownUrl,Demons,ModiTime";
        return this.getFirstData("select " + fieldArr + " from t_pubserver where id=" + id, fieldArr);
    }

    public int getTotalCount() {
        String sql = "select count(*) from t_pubserver";
        return this.getDataCount(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(String title, String playurl, String downurl, String demons, Timestamp moditime) {
        boolean returnValue;
        PreparedStatement ps;
        Connection conn;
        block4: {
            conn = null;
            ps = null;
            returnValue = true;
            int lastid = this.getLastId();
            String sql = "insert into t_pubserver(id,Title,PlayUrl,DownUrl,Demons,ModiTime) values(?,?,?,?,?,?)";
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setInt(1, lastid);
                ps.setString(2, title);
                ps.setString(3, playurl);
                ps.setString(4, downurl);
                ps.setString(5, demons);
                ps.setTimestamp(6, moditime);
                if (ps.executeUpdate() == 1) break block4;
                returnValue = false;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"add pub server error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtils.closePrepareStatement(ps);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mod(int id, String title, String playurl, String downurl, String demons, Timestamp moditime) {
        boolean returnValue;
        PreparedStatement ps;
        Connection conn;
        block4: {
            conn = null;
            ps = null;
            returnValue = true;
            String sql = "update t_pubserver set Title=?,PlayUrl=?,DownUrl=?,Demons=?,ModiTime=? where id=?";
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setString(1, title);
                ps.setString(2, playurl);
                ps.setString(3, downurl);
                ps.setString(4, demons);
                ps.setTimestamp(5, moditime);
                ps.setInt(6, id);
                if (ps.executeUpdate() == 1) break block4;
                returnValue = false;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"mod error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtils.closePrepareStatement(ps);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    public boolean del(int id) throws ObjectNotFoundException, DatabaseException {
        return this.exe("delete from t_pubserver where id=" + id);
    }

    public Collection getList_Limit(int currentpage, int pagesize) {
        if (DBUtils.getDatabaseType() == 15) {
            StringBuffer sql = new StringBuffer();
            sql.append("select id,Title,PlayUrl,DownUrl,Demons,ModiTime from t_pubserver order by id desc");
            return this.getDataList_mysqlLimit(sql.toString(), "id,Title,PlayUrl,DownUrl,Demons,ModiTime", pagesize, (currentpage - 1) * pagesize);
        }
        if (DBUtils.getDatabaseType() == 11) {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT TOP ");
            sql.append(pagesize);
            sql.append(" id,Title,PlayUrl,DownUrl,Demons,ModiTime FROM t_pubserver WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP ");
            sql.append((currentpage - 1) * pagesize + 1);
            sql.append(" id  FROM t_pubserver");
            sql.append(" ORDER BY id DESC) AS t))");
            sql.append(" ORDER BY id DESC");
            return this.getData(sql.toString(), "id,Title,PlayUrl,DownUrl,Demons,ModiTime");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select id,Title,PlayUrl,DownUrl,Demons,ModiTime from t_pubserver");
        return this.getDataList_Limit_Normal(sql.toString(), "id,Title,PlayUrl,DownUrl,Demons,ModiTime", pagesize, (currentpage - 1) * pagesize);
    }

    public Collection getSearchList_Limit(String key, int currentpage, int pagesize) {
        String fields = "id,Title,PlayUrl,DownUrl,Demons,ModiTime";
        if (DBUtils.getDatabaseType() == 15) {
            StringBuffer sql = new StringBuffer();
            sql.append("select " + fields + " from t_pubserver where 1=1");
            if (key != null) {
                sql.append(" and Title like '%" + key + "%'");
            }
            sql.append(" order by id desc");
            return this.getDataList_mysqlLimit(sql.toString(), fields, pagesize, (currentpage - 1) * pagesize);
        }
        if (DBUtils.getDatabaseType() == 11) {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT TOP ");
            sql.append(pagesize);
            sql.append(" " + fields + " FROM t_pubserver WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP ");
            sql.append((currentpage - 1) * pagesize + 1);
            sql.append(" id  FROM t_pubserver where 1=1");
            if (key != null) {
                sql.append(" and Title like '%" + key + "%'");
            }
            sql.append(" ORDER BY id DESC) AS t))");
            if (key != null) {
                sql.append(" and Title like '%" + key + "%'");
            }
            sql.append(" ORDER BY id DESC");
            return this.getData(sql.toString(), fields);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select " + fields + " from t_pubserver where 1=1");
        if (key != null) {
            sql.append(" and Title like '%" + key + "%'");
        }
        return this.getDataList_Limit_Normal(sql.toString(), fields, pagesize, (currentpage - 1) * pagesize);
    }

    public int getTotalCount(String key) {
        StringBuffer sql = new StringBuffer(512);
        sql.append("select count(*) from t_pubserver where 1=1");
        if (key != null) {
            sql.append(" and Title like '%" + key + "%'");
        }
        return this.getDataCount(sql.toString());
    }

    public String getOptions(int cid) {
        StringBuffer returnStr = new StringBuffer(512);
        String ifSele = "";
        ArrayList categoryList = (ArrayList)this.getData("select id,Title from t_pubserver order by id asc", "id,Title");
        for (DataField df : categoryList) {
            ifSele = cid == Integer.parseInt(df.getFieldValue("id")) ? " selected" : "";
            returnStr.append("<option value=\"" + df.getFieldValue("id") + "\"" + ifSele + ">" + df.getFieldValue("Title") + "</option>" + "\n");
        }
        return returnStr.toString();
    }

    public void batDel(String[] s) {
        this.bat("delete from t_pubserver where id=?", s);
    }
}

