/*
 * Decompiled with CFR 0.152.
 */
package tot.dao.jdbc;

import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.bean.DataField;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.exception.DatabaseException;
import tot.exception.ObjectNotFoundException;

public class RoleDaoImplJDBC
extends AbstractDao {
    private static Log log = LogFactory.getLog(RoleDaoImplJDBC.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addRole(String rolename, String privilege, Timestamp moditime) {
        boolean returnValue;
        PreparedStatement ps;
        Connection conn;
        block6: {
            conn = null;
            ps = null;
            returnValue = true;
            String sql = "insert into t_role(RoleName,Privilege,ModiTime) values(?,?,?)";
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setString(1, rolename);
                if (DBUtils.getDatabaseType() == 10) {
                    ps.setCharacterStream(2, (Reader)new StringReader(privilege), privilege.length());
                } else {
                    ps.setString(2, privilege);
                }
                ps.setTimestamp(3, moditime);
                if (ps.executeUpdate() == 1) break block6;
                returnValue = false;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"add Role error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtils.closePrepareStatement(ps);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modRole(int id, String rolename, String privilege, Timestamp moditime) {
        boolean returnValue;
        PreparedStatement ps;
        Connection conn;
        block6: {
            conn = null;
            ps = null;
            returnValue = true;
            String sql = "update t_role set RoleName=?,Privilege=?,ModiTime=? where id=?";
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setString(1, rolename);
                if (DBUtils.getDatabaseType() == 10) {
                    ps.setCharacterStream(2, (Reader)new StringReader(privilege), privilege.length());
                } else {
                    ps.setString(2, privilege);
                }
                ps.setTimestamp(3, moditime);
                ps.setInt(4, id);
                if (ps.executeUpdate() == 1) break block6;
                returnValue = false;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"mod role error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtils.closePrepareStatement(ps);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    public boolean delRole(int id) throws ObjectNotFoundException, DatabaseException {
        return this.exe("delete from t_role where id=" + id);
    }

    public Collection getRole() {
        String sql = "select id,RoleName,Privilege,ModiTime from t_role order by id asc";
        return this.getData(sql, "id,RoleName,Privilege,ModiTime");
    }

    public Collection getRoleList_Limit(int currentpage, int pagesize) {
        if (DBUtils.getDatabaseType() == 15) {
            return this.getDataList_mysqlLimit("select id,RoleName,Privilege,ModiTime from t_role", "id,RoleName,Privilege,ModiTime", pagesize, (currentpage - 1) * pagesize);
        }
        if (DBUtils.getDatabaseType() == 11) {
            String sql = "SELECT TOP " + pagesize + " id,RoleName,Privilege,ModiTime FROM t_role WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP " + ((currentpage - 1) * pagesize + 1) + " id  FROM t_role ORDER BY id DESC) AS t)) ORDER BY id DESC";
            return this.getData(sql, "id,RoleName,Privilege,ModiTime");
        }
        return this.getDataList_Limit_Normal("select id,RoleName,Privilege,ModiTime from t_role", "id,RoleName,Privilege,ModiTime", pagesize, (currentpage - 1) * pagesize);
    }

    public String getPrivilege(int id) {
        DataField df = this.getFirstData("select Privilege from t_role where id=" + id, "Privilege");
        String returnValue = null;
        if (df != null) {
            returnValue = df.getFieldValue("Privilege");
        }
        return returnValue;
    }

    public DataField getRole(int id) {
        return this.getFirstData("select id,RoleName,Privilege,ModiTime from t_role where id=" + id, "id,RoleName,Privilege,ModiTime");
    }

    public int getTotalCount() {
        return this.getDataCount("select count(*) from t_role");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSelect(int roleid) {
        StringBuffer sb = new StringBuffer();
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = DBUtils.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery("select id,RoleName from t_role order by id asc");
            while (rs.next()) {
                sb.append("<option value=\"");
                sb.append(rs.getInt(1));
                sb.append("\"");
                if (roleid == rs.getInt(1)) {
                    sb.append(" selected=\"selected\"");
                }
                sb.append(">");
                sb.append(rs.getString(2));
                sb.append("</option>\n");
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)"Sql Exception Error:", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(rs);
                DBUtils.closeStatement(stmt);
                DBUtils.closeConnection(conn);
                throw throwable;
            }
            DBUtils.closeResultSet(rs);
            DBUtils.closeStatement(stmt);
            DBUtils.closeConnection(conn);
        }
        DBUtils.closeResultSet(rs);
        DBUtils.closeStatement(stmt);
        DBUtils.closeConnection(conn);
        return sb.toString();
    }
}

