/*
 * Decompiled with CFR 0.152.
 */
package tot.dao.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.bean.DataField;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.exception.DatabaseException;
import tot.exception.ObjectNotFoundException;

public class SlideDaoImplJDBC
extends AbstractDao {
    private static Log log = LogFactory.getLog(SlideDaoImplJDBC.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSlide(String title, int categoryid, int itemnum, int width, int height) {
        boolean returnValue;
        PreparedStatement ps;
        Connection conn;
        block4: {
            conn = null;
            ps = null;
            returnValue = true;
            String sql = "insert into t_slide(Title,CategoryId,ItemNum,Width,Height) values(?,?,?,?,?)";
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setString(1, title);
                ps.setInt(2, categoryid);
                ps.setInt(3, itemnum);
                ps.setInt(4, width);
                ps.setInt(5, height);
                if (ps.executeUpdate() == 1) break block4;
                returnValue = false;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"add slide error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtils.closePrepareStatement(ps);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modSlide(int id, String title, int categoryid, int itemnum, int width, int height) {
        boolean returnValue;
        PreparedStatement ps;
        Connection conn;
        block4: {
            conn = null;
            ps = null;
            returnValue = true;
            String sql = "update t_slide set Title=?,CategoryId=?,ItemNum=?,Width=?,Height=? where id=?";
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setString(1, title);
                ps.setInt(2, categoryid);
                ps.setInt(3, itemnum);
                ps.setInt(4, width);
                ps.setInt(5, height);
                ps.setInt(6, id);
                if (ps.executeUpdate() == 1) break block4;
                returnValue = false;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"mod slide error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtils.closePrepareStatement(ps);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    public boolean delSlide(int id) throws ObjectNotFoundException, DatabaseException {
        return this.exe("delete from t_slide where id=" + id);
    }

    public DataField getSlide(int id) {
        return this.getFirstData("select Title,CategoryId,ItemNum,Width,Height from t_slide where id=" + id, "Title,CategoryId,ItemNum,Width,Height");
    }

    public int getTotalCount(int categoryid) {
        String sql = "select count(*) from t_slide";
        if (categoryid != 0) {
            sql = sql + " where CategoryId=" + categoryid;
        }
        return this.getDataCount(sql);
    }

    public Collection getSlideList(int categoryid, int currentpage, int pagesize) {
        StringBuffer sql = new StringBuffer(512);
        String fieldArr = "id,Title,CategoryId,ItemNum,Width,Height";
        if (DBUtils.getDatabaseType() == 11) {
            sql.append("select top ");
            sql.append(pagesize);
            sql.append(fieldArr);
            sql.append(" from t_slide WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP " + ((currentpage - 1) * pagesize + 1) + " id  FROM t_slide");
            if (categoryid != 0) {
                sql.append(" where CategoryId=").append(categoryid);
            }
            sql.append(" ORDER BY id DESC) AS t))");
            if (categoryid != 0) {
                sql.append(" and CategoryId=").append(categoryid);
            }
            sql.append(" ORDER BY id DESC");
            return this.getData(sql.toString(), fieldArr);
        }
        if (DBUtils.getDatabaseType() == 15) {
            sql.append("select ");
            sql.append(fieldArr);
            sql.append(" from t_slide");
            if (categoryid != 0) {
                sql.append(" where CategoryId=").append(categoryid);
            }
            sql.append(" order by id desc limit ");
            sql.append((currentpage - 1) * pagesize);
            sql.append(",");
            sql.append(pagesize);
            return this.getData(sql.toString(), fieldArr);
        }
        sql.append("select ");
        sql.append(fieldArr);
        sql.append(" from t_slide");
        if (categoryid != 0) {
            sql.append(" where CategoryId=").append(categoryid);
        }
        sql.append(" order by id desc");
        return this.getDataList_Limit_Normal(sql.toString(), fieldArr, pagesize, (currentpage - 1) * pagesize);
    }

    public void batDel(String[] s) {
        this.bat("delete from t_slide where id=?", s);
    }
}

