/*
 * Decompiled with CFR 0.152.
 */
package tot.dao.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.bean.DataField;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.exception.DatabaseException;
import tot.exception.ObjectNotFoundException;

public class SourceDaoImplJDBC
extends AbstractDao {
    private static Log log = LogFactory.getLog(SourceDaoImplJDBC.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSource(String title, String stype) {
        boolean returnValue;
        PreparedStatement ps;
        Connection conn;
        block4: {
            conn = null;
            ps = null;
            returnValue = true;
            String sql = "insert into t_source(Title,Stype) values(?,?)";
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setString(1, title);
                ps.setString(2, stype);
                if (ps.executeUpdate() == 1) break block4;
                returnValue = false;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"add Source error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtils.closePrepareStatement(ps);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modSource(int id, String title, String stype) {
        boolean returnValue;
        PreparedStatement ps;
        Connection conn;
        block4: {
            conn = null;
            ps = null;
            returnValue = true;
            String sql = "update t_source set Title=?,Stype=? where id=?";
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setString(1, title);
                ps.setString(2, stype);
                ps.setInt(3, id);
                if (ps.executeUpdate() == 1) break block4;
                returnValue = false;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"modify Source error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtils.closePrepareStatement(ps);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    public boolean delSource(int id) throws ObjectNotFoundException, DatabaseException {
        return this.exe("delete from t_source where id=" + id);
    }

    public DataField getSource(int id) {
        String fieldArr = "id,Title";
        return this.getFirstData("select " + fieldArr + " from t_source where id=" + id, fieldArr);
    }

    public Collection getSources(String stype) {
        String fieldArr = "id,Title";
        String sql = "select " + fieldArr + " from t_source where Stype='" + stype + "'";
        return this.getData(sql, fieldArr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSelect(String stype, int currentid) {
        StringBuffer sb;
        block7: {
            sb = new StringBuffer();
            Connection conn = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                conn = DBUtils.getConnection();
                stmt = conn.createStatement();
                rs = stmt.executeQuery("select id,Title from t_source where Stype='" + stype + "' order by id asc");
                while (rs.next()) {
                    sb.append("<option value=\"");
                    sb.append(rs.getString(2));
                    sb.append("\"");
                    if (currentid == rs.getInt(1)) {
                        sb.append(" selected=\"selected\"");
                    }
                    sb.append(">");
                    sb.append(rs.getString(2));
                    sb.append("</option>\n");
                }
                DBUtils.closeResultSet(rs);
            }
            catch (SQLException e) {
                log.error((Object)"Sql Exception Error:", (Throwable)e);
                break block7;
            }
            finally {
                DBUtils.closeResultSet(rs);
                DBUtils.closeStatement(stmt);
                DBUtils.closeConnection(conn);
            }
            DBUtils.closeStatement(stmt);
            DBUtils.closeConnection(conn);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSelectInt(String stype, int currentid) {
        StringBuffer sb;
        block7: {
            sb = new StringBuffer();
            Connection conn = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                conn = DBUtils.getConnection();
                stmt = conn.createStatement();
                rs = stmt.executeQuery("select id,Title from t_source where Stype='" + stype + "' order by id asc");
                while (rs.next()) {
                    sb.append("<option value=\"");
                    sb.append(rs.getString(1));
                    sb.append("\"");
                    if (currentid == rs.getInt(1)) {
                        sb.append(" selected=\"selected\"");
                    }
                    sb.append(">");
                    sb.append(rs.getString(2));
                    sb.append("</option>\n");
                }
                DBUtils.closeResultSet(rs);
            }
            catch (SQLException e) {
                log.error((Object)"Sql Exception Error:", (Throwable)e);
                break block7;
            }
            finally {
                DBUtils.closeResultSet(rs);
                DBUtils.closeStatement(stmt);
                DBUtils.closeConnection(conn);
            }
            DBUtils.closeStatement(stmt);
            DBUtils.closeConnection(conn);
        }
        return sb.toString();
    }

    public int getTotalCount(String stype) {
        String sql = "select count(*) from t_source";
        if (stype != null) {
            sql = sql + " where Stype='" + stype + "'";
        }
        return this.getDataCount(sql);
    }

    public Collection getSourceList_Limit(String stype, int currentpage, int pagesize) {
        if (DBUtils.getDatabaseType() == 15) {
            StringBuffer sql = new StringBuffer();
            sql.append("select id,Title from t_source");
            if (stype != null) {
                sql.append(" where Stype='");
                sql.append(stype).append("'");
            }
            return this.getDataList_mysqlLimit(sql.toString(), "id,Title", pagesize, (currentpage - 1) * pagesize);
        }
        if (DBUtils.getDatabaseType() == 11) {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT TOP ");
            sql.append(pagesize);
            sql.append(" id,Title FROM t_source WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP ");
            sql.append((currentpage - 1) * pagesize + 1);
            sql.append(" id  FROM t_source");
            if (stype != null) {
                sql.append(" where Stype='");
                sql.append(stype).append("'");
            }
            sql.append(" ORDER BY id DESC) AS t))");
            if (stype != null) {
                sql.append(" and Stype='");
                sql.append(stype).append("'");
            }
            sql.append(" ORDER BY id DESC");
            return this.getData(sql.toString(), "id,Title");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select id,Title from t_source");
        if (stype != null) {
            sql.append(" where Stype='");
            sql.append(stype).append("'");
        }
        return this.getDataList_Limit_Normal(sql.toString(), "id,Title", pagesize, (currentpage - 1) * pagesize);
    }

    public void batDel(String[] s) {
        this.bat("delete from t_source where id=?", s);
    }
}

