/*
 * Decompiled with CFR 0.152.
 */
package tot.dao.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.bean.DataField;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.exception.DatabaseException;
import tot.exception.ObjectNotFoundException;
import tot.global.Sysconfig;
import tot.util.StringUtils;

public class SpecialDaoImplJDBC
extends AbstractDao {
    private static Log log = LogFactory.getLog(SpecialDaoImplJDBC.class);

    public int getLastId() {
        DataField df = null;
        int returnValue = 0;
        String sql = null;
        sql = "select id from t_special order by id desc";
        Collection lists = this.getDataList_Limit_Normal(sql, "id", 1, 0);
        Iterator iter = lists.iterator();
        if (iter.hasNext()) {
            df = (DataField)iter.next();
        }
        returnValue = df != null ? Integer.parseInt(df.getFieldValue("id")) + 1 : 1;
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSpecial(String title, String template, String savepath, String content, Timestamp moditime) {
        boolean returnValue;
        PreparedStatement ps;
        Connection conn;
        block4: {
            conn = null;
            ps = null;
            returnValue = true;
            String sql = "insert into t_special(Title,Template,SavePath,Content,ModiTime) values(?,?,?,?,?)";
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setString(1, title);
                ps.setString(2, template);
                ps.setString(3, savepath);
                ps.setString(4, content);
                ps.setTimestamp(5, moditime);
                if (ps.executeUpdate() == 1) break block4;
                returnValue = false;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"add Special error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtils.closePrepareStatement(ps);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modSpecial(int id, String title, String template, String savepath, String content, Timestamp moditime) {
        boolean returnValue;
        PreparedStatement ps;
        Connection conn;
        block4: {
            conn = null;
            ps = null;
            returnValue = true;
            String sql = "update t_special set Title=?,Template=?,SavePath=?,Content=?,ModiTime=? where id=?";
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setString(1, title);
                ps.setString(2, template);
                ps.setString(3, savepath);
                ps.setString(4, content);
                ps.setTimestamp(5, moditime);
                ps.setInt(6, id);
                if (ps.executeUpdate() == 1) break block4;
                returnValue = false;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"mod Special error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtils.closePrepareStatement(ps);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    public boolean delSpecial(int id) throws ObjectNotFoundException, DatabaseException {
        return this.exe("delete from t_special where id=" + id);
    }

    public Collection getSpecial() {
        String sql = "select id,Title,Template,SavePath,ModiTime from t_special order by id asc";
        return this.getData(sql, "id,Title,Template,SavePath,ModiTime");
    }

    public Collection getSpecialList_Limit(int currentpage, int pagesize) {
        if (DBUtils.getDatabaseType() == 15) {
            return this.getDataList_mysqlLimit("select id,Title,ModiTime from t_special", "id,Title,ModiTime", pagesize, (currentpage - 1) * pagesize);
        }
        if (DBUtils.getDatabaseType() == 11) {
            String sql = "SELECT TOP " + pagesize + " id, title, moditime FROM t_special WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP " + ((currentpage - 1) * pagesize + 1) + " id  FROM t_special ORDER BY id DESC) AS t)) ORDER BY id DESC";
            return this.getData(sql, "id,Title,ModiTime");
        }
        return this.getDataList_Limit_Normal("select id,Title,ModiTime from t_special", "id,Title,ModiTime", pagesize, (currentpage - 1) * pagesize);
    }

    public DataField getSpecial(int id) {
        return this.getFirstData("select id,Title,Template,SavePath,Content,ModiTime from t_special where id=" + id, "id,Title,Template,SavePath,Content,ModiTime");
    }

    public int getTotalCount() {
        return this.getDataCount("select count(*) from t_special");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSelect(int currentid) {
        StringBuffer sb = new StringBuffer();
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = DBUtils.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery("select id,Title from t_special order by id asc");
            while (rs.next()) {
                sb.append("<option value=\"");
                sb.append(rs.getInt(1));
                sb.append("\"");
                if (currentid == rs.getInt(1)) {
                    sb.append(" selected=\"selected\"");
                }
                sb.append(">");
                sb.append(rs.getString(2));
                sb.append("</option>\n");
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)"Sql Exception Error:", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(rs);
                DBUtils.closeStatement(stmt);
                DBUtils.closeConnection(conn);
                throw throwable;
            }
            DBUtils.closeResultSet(rs);
            DBUtils.closeStatement(stmt);
            DBUtils.closeConnection(conn);
        }
        DBUtils.closeResultSet(rs);
        DBUtils.closeStatement(stmt);
        DBUtils.closeConnection(conn);
        return sb.toString();
    }

    public String getSpecials(String ulStyle, int getNum, int charMax, String titlePre) {
        String contextPath = Sysconfig.getSiteUrl() + Sysconfig.getContextPath();
        StringBuffer sb = new StringBuffer(512);
        ArrayList list = (ArrayList)this.getSpecial();
        sb.append("<ul class=\"");
        sb.append(ulStyle);
        sb.append("\">");
        boolean i = false;
        for (DataField df : list) {
            sb.append("<li>");
            sb.append(titlePre);
            sb.append("<a href=\"");
            sb.append(contextPath);
            sb.append(df.getFieldValue("SavePath"));
            sb.append("/index_1.htm");
            sb.append("\">");
            sb.append(StringUtils.getTopic(df.getFieldValue("Title"), charMax));
            sb.append("</a></li>\n");
            if (getNum <= 0 || getNum <= list.size()) continue;
            break;
        }
        sb.append("</ul>");
        return sb.toString();
    }
}

