/*
 * Decompiled with CFR 0.152.
 */
package tot.dao.jdbc;

import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.bean.DataField;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.exception.DatabaseException;
import tot.exception.ObjectNotFoundException;

public class TemplateDaoImplJDBC
extends AbstractDao {
    private static Log log = LogFactory.getLog(TemplateDaoImplJDBC.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addTemplate(String title, String content, Timestamp moditime) {
        boolean returnValue;
        PreparedStatement ps;
        Connection conn;
        block6: {
            conn = null;
            ps = null;
            returnValue = true;
            String sql = "insert into t_template(Title,Content,ModiTime) values(?,?,?)";
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setString(1, title);
                if (DBUtils.getDatabaseType() == 10) {
                    ps.setCharacterStream(2, (Reader)new StringReader(content), content.length());
                } else {
                    ps.setString(2, content);
                }
                ps.setTimestamp(3, moditime);
                if (ps.executeUpdate() == 1) break block6;
                returnValue = false;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"add Template error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtils.closePrepareStatement(ps);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modTemplate(int id, String title, String content, Timestamp moditime) {
        boolean returnValue;
        PreparedStatement ps;
        Connection conn;
        block6: {
            conn = null;
            ps = null;
            returnValue = true;
            String sql = "update t_template set Title=?,Content=?,ModiTime=? where id=?";
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setString(1, title);
                if (DBUtils.getDatabaseType() == 10) {
                    ps.setCharacterStream(2, (Reader)new StringReader(content), content.length());
                } else {
                    ps.setString(2, content);
                }
                ps.setTimestamp(3, moditime);
                ps.setInt(4, id);
                if (ps.executeUpdate() == 1) break block6;
                returnValue = false;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"mod template error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtils.closePrepareStatement(ps);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    public boolean delTemplate(int id) throws ObjectNotFoundException, DatabaseException {
        return this.exe("delete from t_template where id=" + id);
    }

    public Collection getTemplate() {
        String sql = "select id,Title,ModiTime from t_template order by id asc";
        return this.getData(sql, "id,Title,ModiTime");
    }

    public Collection getTemplateList_Limit(int currentpage, int pagesize) {
        if (DBUtils.getDatabaseType() == 15) {
            return this.getDataList_mysqlLimit("select id,Title,ModiTime from t_template", "id,Title,ModiTime", pagesize, (currentpage - 1) * pagesize);
        }
        if (DBUtils.getDatabaseType() == 11) {
            String sql = "SELECT TOP " + pagesize + " id, title, moditime FROM t_template WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP " + ((currentpage - 1) * pagesize + 1) + " id  FROM t_template ORDER BY id DESC) AS t)) ORDER BY id DESC";
            return this.getData(sql, "id,Title,ModiTime");
        }
        return this.getDataList_Limit_Normal("select id,Title,ModiTime from t_template", "id,Title,ModiTime", pagesize, (currentpage - 1) * pagesize);
    }

    public String getContent(int id) {
        DataField df = this.getFirstData("select Content from t_template where id=" + id, "Content");
        String returnValue = null;
        if (df != null) {
            returnValue = df.getFieldValue("Content");
        }
        return returnValue;
    }

    public DataField getTemplate(int id) {
        return this.getFirstData("select id,Title,Content,ModiTime from t_template where id=" + id, "id,Title,Content,ModiTime");
    }

    public int getTotalCount() {
        return this.getDataCount("select count(*) from t_template");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSelect(int currentid) {
        StringBuffer sb = new StringBuffer();
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = DBUtils.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery("select id,Title from t_template order by id asc");
            while (rs.next()) {
                sb.append("<option value=\"");
                sb.append(rs.getInt(1));
                sb.append("\"");
                if (currentid == rs.getInt(1)) {
                    sb.append(" selected=\"selected\"");
                }
                sb.append(">");
                sb.append(rs.getString(2));
                sb.append("</option>\n");
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)"Sql Exception Error:", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(rs);
                DBUtils.closeStatement(stmt);
                DBUtils.closeConnection(conn);
                throw throwable;
            }
            DBUtils.closeResultSet(rs);
            DBUtils.closeStatement(stmt);
            DBUtils.closeConnection(conn);
        }
        DBUtils.closeResultSet(rs);
        DBUtils.closeStatement(stmt);
        DBUtils.closeConnection(conn);
        return sb.toString();
    }
}

