/*
 * Decompiled with CFR 0.152.
 */
package tot.dao.jdbc;

import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.bean.DataField;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.exception.DatabaseException;
import tot.exception.ObjectNotFoundException;

public class TotgbDaoImplJDBC
extends AbstractDao {
    private static Log log = LogFactory.getLog(TotgbDaoImplJDBC.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(String username, String title, String content, String emot, String homepage, String email, String im, String ip, Timestamp postDate, int hidden, int ischeck) {
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue = true;
        String sql = "insert into t_post(f_user,f_title,f_content,f_emot,f_homepage,f_email,f_im,f_ip,f_date,f_hidden,f_ischeck,f_replytime) values(?,?,?,?,?,?,?,?,?,?,?,?)";
        try {
            conn = DBUtils.getConnection();
            ps = conn.prepareStatement(sql);
            ps.setString(1, username);
            ps.setString(2, title);
            ps.setString(3, content);
            ps.setString(4, emot);
            ps.setString(5, homepage);
            ps.setString(6, email);
            ps.setString(7, im);
            ps.setString(8, ip);
            ps.setTimestamp(9, postDate);
            ps.setInt(10, hidden);
            ps.setInt(11, ischeck);
            ps.setTimestamp(12, postDate);
            if (ps.executeUpdate() != 1) {
                returnValue = false;
            }
        }
        catch (SQLException e) {
            boolean bl;
            try {
                log.info((Object)("catch exception when call add method: \n" + sql));
                e.printStackTrace();
                bl = false;
            }
            catch (Throwable throwable) {
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
                throw throwable;
            }
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
            return bl;
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reply(String content, int postid, Timestamp replydate) {
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue = true;
        try {
            conn = DBUtils.getConnection();
            ps = conn.prepareStatement("update t_post set f_reply=?,f_replytime=? where id=?");
            ps.setString(1, content);
            ps.setTimestamp(2, replydate);
            ps.setInt(3, postid);
            if (ps.executeUpdate() != 1) {
                returnValue = false;
            }
        }
        catch (SQLException e) {
            boolean bl;
            try {
                e.printStackTrace();
                bl = false;
            }
            catch (Throwable throwable) {
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
                throw throwable;
            }
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
            return bl;
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    public Collection getPostList(int ischeck, int pageSize, int currentPage) {
        StringBuffer sql = new StringBuffer(512);
        String fieldArr = "id,f_user,f_title,f_content,f_reply,f_replytime,f_emot,f_homepage,f_email,f_im,f_ip,f_date,f_hidden";
        if (DBUtils.getDatabaseType() == 11) {
            sql.append("select top ");
            sql.append(pageSize);
            sql.append(fieldArr);
            sql.append(" from t_post where id <=(select min(id) from (select top ");
            sql.append((currentPage - 1) * pageSize + 1);
            sql.append(" id from t_post where f_ischeck=");
            sql.append(ischeck);
            sql.append(" order by id desc) as t)");
            sql.append(" and f_ischeck=");
            sql.append(ischeck);
            sql.append(" order by id desc");
            return this.getData(sql.toString(), fieldArr);
        }
        if (DBUtils.getDatabaseType() == 15) {
            sql.append("select ");
            sql.append(fieldArr);
            sql.append(" from t_post");
            sql.append(" where f_ischeck=");
            sql.append(ischeck);
            sql.append(" order by id desc limit ");
            sql.append((currentPage - 1) * pageSize);
            sql.append(",");
            sql.append(pageSize);
            return this.getData(sql.toString(), fieldArr);
        }
        sql.append("select ");
        sql.append(fieldArr);
        sql.append(" from t_post");
        sql.append(" where f_ischeck=");
        sql.append(ischeck);
        sql.append(" order by id desc");
        return this.getDataList_Limit_Normal(sql.toString(), fieldArr, pageSize, (currentPage - 1) * pageSize);
    }

    public int getTotalCount(int ischeck) {
        StringBuffer sql = new StringBuffer(512);
        sql.append("select count(*) from t_post");
        sql.append(" where f_ischeck=");
        sql.append(ischeck);
        return this.getDataCount(sql.toString());
    }

    public DataField get(int id) {
        String fields = "f_user,f_title,f_content,f_reply,f_emot,f_homepage,f_email,f_im,f_ip,f_date,f_hidden,f_ischeck,f_replytime";
        return this.getFirstData("select " + fields + " from t_post where id=" + id, fields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mod(int id, String content) {
        boolean returnValue;
        PreparedStatement ps;
        Connection conn;
        block6: {
            conn = null;
            ps = null;
            returnValue = true;
            String sql = "update t_post set f_content=? where id=?";
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement(sql);
                if (DBUtils.getDatabaseType() == 10) {
                    ps.setCharacterStream(1, (Reader)new StringReader(content), content.length());
                } else {
                    ps.setString(1, content);
                }
                ps.setInt(2, id);
                if (ps.executeUpdate() == 1) break block6;
                returnValue = false;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"mod guestbook error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtils.closePrepareStatement(ps);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    public boolean delPost(int id) throws ObjectNotFoundException, DatabaseException {
        return this.exe("delete from t_post where id=" + id);
    }

    public void batDel(String[] s) {
        this.bat("delete from t_post where id=?", s);
    }

    public void batCheck(String[] s) {
        this.bat("update t_post set f_ischeck=1 where id=?", s);
    }
}

