/*
 * Decompiled with CFR 0.152.
 */
package tot.dao.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.bean.DataField;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.exception.DatabaseException;
import tot.exception.ObjectNotFoundException;

public class TransactionDaoImplJDBC
extends AbstractDao {
    private static Log log = LogFactory.getLog(TransactionDaoImplJDBC.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean addTransaction(int transtype, Float money, String fromuser, String touser, Timestamp moditime, int status, String fname, String furl, String fdesc, String transid) {
        boolean returnValue;
        block17: {
            PreparedStatement ps;
            Connection conn;
            block15: {
                conn = null;
                ps = null;
                returnValue = true;
                String sql = "insert into t_transaction(TransType,Money,FromUser,ToUser,TransDate,Fstatus,Fname,Furl,Fdesc,TransId) values(?,?,?,?,?,?,?,?,?,?)";
                conn = DBUtils.getConnection();
                conn.setAutoCommit(false);
                ps = conn.prepareStatement(sql);
                ps.setInt(1, transtype);
                ps.setFloat(2, money.floatValue());
                ps.setString(3, fromuser);
                ps.setString(4, touser);
                ps.setTimestamp(5, moditime);
                ps.setInt(6, status);
                ps.setString(7, fname);
                ps.setString(8, furl);
                ps.setString(9, fdesc);
                ps.setString(10, transid);
                if (ps.executeUpdate() != 1) {
                    returnValue = false;
                }
                conn.commit();
                if (conn == null) break block15;
                try {
                    conn.rollback();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
            break block17;
            catch (SQLException e) {
                block16: {
                    try {
                        if (conn != null) {
                            try {
                                conn.rollback();
                            }
                            catch (SQLException e1) {
                                e1.printStackTrace();
                            }
                        }
                        log.error((Object)"add Transaction error", (Throwable)e);
                        if (conn == null) break block16;
                    }
                    catch (Throwable throwable) {
                        if (conn != null) {
                            try {
                                conn.rollback();
                            }
                            catch (SQLException e1) {
                                e1.printStackTrace();
                            }
                        }
                        DBUtils.closePrepareStatement(ps);
                        DBUtils.closeConnection(conn);
                        throw throwable;
                    }
                    try {
                        conn.rollback();
                    }
                    catch (SQLException e1) {
                        e1.printStackTrace();
                    }
                }
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
        }
        return returnValue;
    }

    public boolean delTransaction(int id) throws ObjectNotFoundException, DatabaseException {
        return this.exe("delete from t_transaction where id=" + id);
    }

    public void batDel(String[] s) {
        this.bat("delete from t_transaction where id=?", s);
    }

    public Collection getTransactionList_Limit(int currentpage, int pagesize, String uid) {
        String fields = "id,TransType,Money,FromUser,ToUser,TransDate,Fstatus,Fname,Furl,Fdesc,TransId";
        if (DBUtils.getDatabaseType() == 15) {
            return this.getDataList_mysqlLimit("select " + fields + " from t_transaction where ToUser='" + uid + "' or FromUser='" + uid + "' order by id desc", fields, pagesize, (currentpage - 1) * pagesize);
        }
        if (DBUtils.getDatabaseType() == 11) {
            String sql = "SELECT TOP " + pagesize + " " + fields + " FROM t_transaction WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP " + ((currentpage - 1) * pagesize + 1) + " id  FROM t_transaction where ToUser='" + uid + "' or FromUser='" + uid + "' ORDER BY id DESC) AS t)) and (ToUser='" + uid + "' or FromUser='" + uid + "')  ORDER BY id DESC";
            return this.getData(sql, fields);
        }
        return this.getDataList_Limit_Normal("select " + fields + " from t_transaction", fields, pagesize, (currentpage - 1) * pagesize);
    }

    public Collection getTransactionList_Limit(int tanstype, int status, String userid, String dateStart, String dateEnd, int currentpage, int pagesize) {
        String fields = "id,TransType,Money,FromUser,ToUser,TransDate,Fstatus,Fname,Furl,TransId";
        StringBuffer sql = new StringBuffer(512);
        if (DBUtils.getDatabaseType() == 15) {
            sql.append("select " + fields + " from t_transaction where 1=1");
            if (tanstype >= 0) {
                sql.append(" and TransType=" + tanstype);
            }
            if (status >= 0) {
                sql.append(" and Fstatus=" + status);
            }
            if (userid != null) {
                sql.append(" and (ToUser='" + userid + "' or FromUser='" + userid + "')");
            }
            if (dateStart != null && dateEnd != null) {
                sql.append(" and to_days(TransDate)>=to_days('").append(dateStart).append("') and to_days(TransDate)<=to_days('").append(dateEnd).append("')");
            }
            sql.append(" order by id desc");
            return this.getDataList_mysqlLimit(sql.toString(), fields, pagesize, (currentpage - 1) * pagesize);
        }
        if (DBUtils.getDatabaseType() == 11) {
            return this.getData(sql.toString(), fields);
        }
        return this.getDataList_Limit_Normal("select " + fields + " from t_transaction", fields, pagesize, (currentpage - 1) * pagesize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int getTotalCount(int tanstype, int status, String userid, String dateStart, String dateEnd) {
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        int totalNum;
        block8: {
            totalNum = 0;
            conn = null;
            ps = null;
            rs = null;
            StringBuffer sql = new StringBuffer(512);
            sql.append("select count(*) from t_transaction where 1=1");
            if (tanstype >= 0) {
                sql.append(" and TransType=" + tanstype);
            }
            if (status >= 0) {
                sql.append(" and Fstatus=" + status);
            }
            if (userid != null) {
                sql.append(" and (ToUser='" + userid + "' or FromUser='" + userid + "')");
            }
            if (dateStart != null && dateEnd != null) {
                sql.append(" and to_days(TransDate)>=to_days('").append(dateStart).append("') and to_days(TransDate)<=to_days('").append(dateEnd).append("')");
            }
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement(sql.toString());
                rs = ps.executeQuery();
                if (!rs.next()) break block8;
                totalNum = rs.getInt(1);
            }
            catch (SQLException e) {
                DBUtils.closeResultSet(rs);
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
                catch (Throwable throwable) {
                    DBUtils.closeResultSet(rs);
                    DBUtils.closePrepareStatement(ps);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
            }
        }
        DBUtils.closeResultSet(rs);
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return totalNum;
    }

    public DataField getTransaction(int id) {
        String fields = "TransType,Money,FromUser,ToUser,TransDate,Fstatus,Fname,Furl,Fdesc,TransId";
        return this.getFirstData("select " + fields + " from t_transaction where id=" + id, fields);
    }
}

