/*
 * Decompiled with CFR 0.152.
 */
package tot.dao.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.bean.DataField;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.exception.DatabaseException;
import tot.exception.ObjectNotFoundException;

public class VoteDaoImplJDBC
extends AbstractDao {
    private static Log log = LogFactory.getLog(VoteDaoImplJDBC.class);

    public int getLastId() {
        DataField df = null;
        int returnValue = 0;
        String sql = null;
        sql = "select id from t_vote order by id desc";
        Collection lists = this.getDataList_Limit_Normal(sql, "id", 1, 0);
        Iterator iter = lists.iterator();
        if (iter.hasNext()) {
            df = (DataField)iter.next();
        }
        returnValue = df != null ? Integer.parseInt(df.getFieldValue("id")) + 1 : 1;
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addVote(int id, String title, int optionnum, int optiontype, int status, Timestamp expirestime, Timestamp moditime) {
        boolean returnValue;
        PreparedStatement ps;
        Connection conn;
        block4: {
            conn = null;
            ps = null;
            returnValue = true;
            String sql = "insert into t_vote(id,Title,OptionNum,OptionType,Status,ExpiresTime,ModiTime) values(?,?,?,?,?,?,?)";
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setInt(1, id);
                ps.setString(2, title);
                ps.setInt(3, optionnum);
                ps.setInt(4, optiontype);
                ps.setInt(5, status);
                ps.setTimestamp(6, expirestime);
                ps.setTimestamp(7, moditime);
                if (ps.executeUpdate() == 1) break block4;
                returnValue = false;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"add Vote error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtils.closePrepareStatement(ps);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modVote(int id, String title, int optionnum, int optiontype, int status, Timestamp expirestime, Timestamp moditime) {
        boolean returnValue;
        PreparedStatement ps;
        Connection conn;
        block4: {
            conn = null;
            ps = null;
            returnValue = true;
            String sql = "update t_vote set Title=?,OptionNum=?,OptionType=?,Status=?,ExpiresTime=?,ModiTime=? where id=?";
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setString(1, title);
                ps.setInt(2, optionnum);
                ps.setInt(3, optiontype);
                ps.setInt(4, status);
                ps.setTimestamp(5, expirestime);
                ps.setTimestamp(6, moditime);
                ps.setInt(7, id);
                if (ps.executeUpdate() == 1) break block4;
                returnValue = false;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"mod vote error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtils.closePrepareStatement(ps);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addVoteItem(int voteid, String[] items) {
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue = true;
        String sql = "insert into t_voteitem(VoteId,ItemName,Hits) values(?,?,0)";
        try {
            conn = DBUtils.getConnection();
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < items.length; ++i) {
                ps.setInt(1, voteid);
                ps.setString(2, items[i]);
                ps.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)"add Vote Item error", (Throwable)e);
                returnValue = false;
            }
            catch (Throwable throwable) {
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
                throw throwable;
            }
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getVoteItemHits(int voteid) {
        int[] hits;
        block7: {
            hits = null;
            Connection conn = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            String sql = "select Hits from t_voteitem where VoteId=? order by id asc";
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement("select count(*) from t_voteitem where VoteId=?");
                ps.setInt(1, voteid);
                rs = ps.executeQuery();
                if (rs.next()) {
                    hits = new int[rs.getInt(1)];
                }
                ps.close();
                rs.close();
                ps = conn.prepareStatement(sql);
                ps.setInt(1, voteid);
                rs = ps.executeQuery();
                int i = 0;
                while (rs.next()) {
                    hits[i] = rs.getInt(1);
                    ++i;
                }
                DBUtils.closeResultSet(rs);
            }
            catch (SQLException e) {
                log.error((Object)"getVoteItemHitsm error", (Throwable)e);
                break block7;
            }
            finally {
                DBUtils.closeResultSet(rs);
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return hits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modVoteItem(int voteid, String[] items) throws ObjectNotFoundException, DatabaseException {
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue = true;
        int[] hits = this.getVoteItemHits(voteid);
        String sql = "insert into t_voteitem(VoteId,ItemName,Hits) values(?,?,?)";
        try {
            conn = DBUtils.getConnection();
            ps = conn.prepareStatement(sql);
            this.delVoteItem(voteid);
            int hit = 0;
            for (int i = 0; i < items.length; ++i) {
                hit = i < hits.length ? hits[i] : 0;
                ps.setInt(1, voteid);
                ps.setString(2, items[i]);
                ps.setInt(3, hit);
                ps.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)"add Vote Item error", (Throwable)e);
                returnValue = false;
            }
            catch (Throwable throwable) {
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
                throw throwable;
            }
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    public boolean delVote(int id) throws ObjectNotFoundException, DatabaseException {
        return this.exe("delete from t_vote where id=" + id);
    }

    public boolean delVoteItem(int voteid) throws ObjectNotFoundException, DatabaseException {
        return this.exe("delete from t_voteitem where VoteId=" + voteid);
    }

    public Collection getVotes() {
        String sql = "select id,Title,OptionNum,OptionType,Status,ExpiresTime,ModiTime from t_vote order by id asc";
        return this.getData(sql, "id,Title,OptionNum,OptionType,Status,ExpiresTime,ModiTime");
    }

    public Collection getVoteItems(int voteid) {
        String sql = "select id,ItemName,Hits from t_voteitem where VoteId=" + voteid + " order by id asc";
        return this.getData(sql, "id,ItemName,Hits");
    }

    public Collection getVoteList_Limit(int currentpage, int pagesize) {
        if (DBUtils.getDatabaseType() == 15) {
            return this.getDataList_mysqlLimit("select id,Title,OptionNum,OptionType,Status,ExpiresTime,ModiTime from t_vote", "id,Title,OptionNum,OptionType,Status,ExpiresTime,ModiTime", pagesize, (currentpage - 1) * pagesize);
        }
        if (DBUtils.getDatabaseType() == 11) {
            String sql = "SELECT TOP " + pagesize + " id,Title,OptionNum,OptionType,Status,ExpiresTime,ModiTime FROM t_vote WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP " + ((currentpage - 1) * pagesize + 1) + " id  FROM t_vote ORDER BY id DESC) AS t)) ORDER BY id DESC";
            return this.getData(sql, "id,Title,OptionNum,OptionType,Status,ExpiresTime,ModiTime");
        }
        return this.getDataList_Limit_Normal("select id,Title,OptionNum,OptionType,Status,ExpiresTime,ModiTime from t_vote", "id,Title,OptionNum,OptionType,Status,ExpiresTime,ModiTime", pagesize, (currentpage - 1) * pagesize);
    }

    public DataField getVote(int id) {
        return this.getFirstData("select id,Title,OptionNum,OptionType,Status,ExpiresTime,ModiTime from t_vote where id=" + id, "id,Title,OptionNum,OptionType,Status,ExpiresTime,ModiTime");
    }

    public int getTotalCount() {
        return this.getDataCount("select count(*) from t_vote");
    }

    public boolean updateHits(int id) throws ObjectNotFoundException, DatabaseException {
        return this.exe("update t_voteitem set Hits=Hits+1 where id=" + id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExpired(int id) {
        boolean returnValue;
        block6: {
            Connection conn = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            returnValue = true;
            String sql = "select ExpiresTime from t_vote where id=?";
            try {
                conn = DBUtils.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setInt(1, id);
                rs = ps.executeQuery();
                if (rs.next()) {
                    long expire = rs.getTimestamp(1).getTime();
                    returnValue = System.currentTimeMillis() >= expire;
                }
                DBUtils.closeResultSet(rs);
            }
            catch (SQLException e) {
                returnValue = false;
                break block6;
            }
            finally {
                DBUtils.closeResultSet(rs);
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
}

