/*
 * Decompiled with CFR 0.152.
 */
package tot.db;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.util.FileUtil;
import tot.xml.DOM4JConfiguration;

class DBOptions {
    private static Log log = LogFactory.getLog(DBOptions.class);
    private static final String OPTION_FILE_NAME = "totgb.xml";
    boolean useDatasource = false;
    int databaseType = 0;
    String datasourceName = "";
    String driverClassName = "org.gjt.mm.mysql.Driver";
    String databaseURL = "jdbc:mysql://localhost/mvnforum?useUnicode=true&characterEncoding=utf-8";
    String databaseUser = "root";
    String databasePassword = "";
    int maxConnection = 20;
    int maxTimeToWait = 2000;
    int minutesBetweenRefresh = 30;

    private DBOptions() {
        try {
            String strPathName = FileUtil.getServletClassesPath();
            String configFilename = strPathName + OPTION_FILE_NAME;
            DOM4JConfiguration conf = new DOM4JConfiguration(new File(configFilename));
            this.useDatasource = conf.getBoolean("dboptions.use_datasource", false);
            this.databaseType = conf.getInt("dboptions.database_type", 0);
            if (this.useDatasource) {
                this.datasourceName = conf.getString("dboptions.datasource_name");
            } else {
                this.driverClassName = conf.getString("dboptions.driver_class_name", this.driverClassName);
                this.databaseURL = conf.getString("dboptions.database_url", this.databaseURL);
                this.databaseUser = conf.getString("dboptions.database_user", this.databaseUser);
                this.databasePassword = conf.getString("dboptions.database_password", this.databasePassword);
                this.maxConnection = conf.getInt("dboptions.max_connection", this.maxConnection);
                this.maxTimeToWait = conf.getInt("dboptions.max_time_to_wait", this.maxTimeToWait);
                this.minutesBetweenRefresh = conf.getInt("dboptions.minutes_between_refresh", this.minutesBetweenRefresh);
                if (this.minutesBetweenRefresh < 1) {
                    this.minutesBetweenRefresh = 1;
                }
            }
        }
        catch (Exception e) {
            String message = "net.myvietnam.mvncore.db.DBOptions: Can't read the configuration file: 'totgb.xml'. Make sure the file is in your CLASSPATH";
            log.error((Object)message, (Throwable)e);
        }
    }
}

