/*
 * Decompiled with CFR 0.152.
 */
package tot.gather;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class DbImport {
    private static Connection conn = null;

    public static Connection getConnection() {
        if (conn != null) {
            return conn;
        }
        return null;
    }

    public static Connection getNewConnection(int databaseType, String driverClass, String address, String port, String database, String username, String password, String encode) {
        String url = "";
        switch (databaseType) {
            case 1: {
                url = "jdbc:jtds:sqlserver://" + address + ":" + port + ";DatabaseName=" + database + ";User=" + username + ";Password=" + password;
                break;
            }
            case 2: {
                url = "jdbc:oracle:thin:@" + address + ":" + port + ":" + database;
                break;
            }
            case 3: {
                url = "jdbc:db2://" + address + ":" + port + "/" + database;
                break;
            }
            case 4: {
                url = "jdbc:sybase:Tds:" + address + ":" + port + "/" + database;
                break;
            }
            case 5: {
                url = "jdbc:informix-sqli://" + address + ":" + port + "/" + database + ":informixserver=myserver;";
                break;
            }
            case 6: {
                url = "jdbc:mysql://" + address + ":" + port + "/" + database + "?useUnicode=true&characterEncoding=" + encode;
                break;
            }
            case 7: {
                url = "jdbc:postgresql://" + address + ":" + port + "/" + database;
                break;
            }
            case 8: {
                url = "jdbc:hsqldb:hsql://" + address + ":" + port + "/" + database;
                break;
            }
            case 9: {
                url = "jdbc:odbc:driver={Microsoft Access Driver (*.mdb)};DBQ=" + database;
                break;
            }
            case 10: {
                url = "jdbc:sapdb://" + address + "/" + database;
                break;
            }
            case 11: {
                url = "jdbc:interbase:" + address + "/" + port + " " + database;
                break;
            }
            case 12: {
                url = "jdbc:firebirdsql:" + address + "/" + port + " " + database;
            }
        }
        try {
            try {
                Class.forName(driverClass).newInstance();
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            conn = username != null && databaseType != 1 ? DriverManager.getConnection(url, username, password) : DriverManager.getConnection(url);
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        return conn;
    }

    public static void closeResultSet(ResultSet rs) throws SQLException {
        if (rs != null) {
            try {
                rs.close();
                rs = null;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void closePreStmt(PreparedStatement psmt) throws SQLException {
        if (psmt != null) {
            try {
                psmt.clearParameters();
                psmt.close();
                psmt = null;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void closeStmt(Statement stmt) throws SQLException {
        if (stmt != null) {
            try {
                stmt.clearBatch();
                stmt.close();
                stmt = null;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String getTables(String tbl) {
        StringBuffer sb;
        block12: {
            block13: {
                sb = new StringBuffer(1024);
                if (conn == null) break block13;
                String[] tbltypes = new String[]{"TABLE"};
                ResultSet rs = null;
                DatabaseMetaData dbm = conn.getMetaData();
                rs = dbm.getTables(null, null, null, tbltypes);
                while (rs.next()) {
                    sb.append("<option value=\"" + rs.getString(3) + "\"");
                    if (tbl != null && tbl.equals(rs.getString(3))) {
                        sb.append(" selected=\"selected\"");
                    }
                    sb.append(">" + rs.getString(3) + "</option>\n");
                }
                try {
                    DbImport.closeResultSet(rs);
                }
                catch (Exception e) {}
                break block12;
                catch (SQLException e) {
                    try {
                        DbImport.closeResultSet(rs);
                    }
                    catch (Exception e2) {}
                    break block12;
                    catch (Throwable throwable) {
                        try {
                            DbImport.closeResultSet(rs);
                        }
                        catch (Exception e3) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
            return "";
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String getFields(String tbl) {
        StringBuffer sb;
        block12: {
            sb = new StringBuffer(1024);
            if (conn != null && tbl != null) {
                PreparedStatement statement = null;
                ResultSet rs = null;
                statement = conn.prepareStatement("select * from " + tbl + " where 1=0");
                rs = statement.executeQuery();
                ResultSetMetaData rm = rs.getMetaData();
                for (int i = 1; i <= rm.getColumnCount(); ++i) {
                    sb.append("<option value=\"" + rm.getColumnName(i) + "\">" + rm.getColumnName(i) + "</option>\n");
                }
                try {
                    DbImport.closeResultSet(rs);
                    DbImport.closePreStmt(statement);
                }
                catch (Exception sqle) {}
                break block12;
                catch (SQLException sqle) {
                    try {
                        DbImport.closeResultSet(rs);
                        DbImport.closePreStmt(statement);
                    }
                    catch (Exception sqle2) {}
                    catch (Throwable throwable) {
                        try {
                            DbImport.closeResultSet(rs);
                            DbImport.closePreStmt(statement);
                        }
                        catch (Exception sqle3) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String getFieldsCheckBox(String tbl) {
        StringBuffer sb;
        block12: {
            sb = new StringBuffer(1024);
            if (conn != null && tbl != null) {
                PreparedStatement statement = null;
                ResultSet rs = null;
                statement = conn.prepareStatement("select * from " + tbl + " where 1=0");
                rs = statement.executeQuery();
                ResultSetMetaData rm = rs.getMetaData();
                for (int i = 1; i <= rm.getColumnCount(); ++i) {
                    sb.append("<input type=\"checkbox\" name=\"field_cb\" id=\"field_cb\" value=\"" + rm.getColumnName(i) + "\" />" + rm.getColumnName(i));
                }
                try {
                    DbImport.closeResultSet(rs);
                    DbImport.closePreStmt(statement);
                }
                catch (Exception sqle) {}
                break block12;
                catch (SQLException sqle) {
                    try {
                        DbImport.closeResultSet(rs);
                        DbImport.closePreStmt(statement);
                    }
                    catch (Exception sqle2) {}
                    catch (Throwable throwable) {
                        try {
                            DbImport.closeResultSet(rs);
                            DbImport.closePreStmt(statement);
                        }
                        catch (Exception sqle3) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close() {
        block6: {
            try {
                if (conn == null) break block6;
                try {
                    conn.close();
                    conn = null;
                }
                catch (SQLException e) {
                    conn.close();
                    conn = null;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

