/*
 * Decompiled with CFR 0.152.
 */
package tot.gather;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.bean.DataField;
import tot.gather.GatherThread;

public class GatherTask {
    private static Log log = LogFactory.getLog(GatherTask.class);
    ExecutorService executor = Executors.newFixedThreadPool(10);
    String[] urls = null;
    DataField params = null;

    public GatherTask(String[] u, DataField df) {
        this.urls = u;
        this.params = df;
    }

    public void start() throws IOException {
        log.info((Object)("start gather task with urls num:" + this.urls.length));
        for (int i = 0; i < this.urls.length; ++i) {
            this.executor.execute(new GatherThread(this.urls[i], this.params));
        }
    }

    public void shutdown() throws InterruptedException {
        this.executor.shutdown();
        this.executor.awaitTermination(2L, TimeUnit.SECONDS);
        if (this.executor.isTerminated()) {
            this.executor.shutdownNow();
            log.info((Object)"shutdown task");
        } else {
            log.debug((Object)"call shut down after 2 seconds");
            this.shutdown();
        }
    }
}

