/*
 * Decompiled with CFR 0.152.
 */
package tot.gather;

import java.sql.Timestamp;
import java.util.Random;
import tot.bean.DataField;
import tot.dao.DaoFactory;
import tot.global.Sysconfig;
import tot.util.DateUtil;
import tot.util.StringUtils;
import tot.util.UrlUtil;

public class GatherThread
implements Runnable {
    private String fileurl = null;
    private DataField para = null;

    public GatherThread(String u, DataField df) {
        this.fileurl = u;
        this.para = df;
    }

    public void run() {
        if (this.fileurl == null) {
            return;
        }
        boolean isgathered = DaoFactory.getGatherHisDAO().isGathered(this.fileurl);
        if (!isgathered) {
            String html = UrlUtil.getHtml(this.fileurl, this.para.getFieldValue("Encode"));
            String title = StringUtils.subStr(html, this.para.getFieldValue("TitleStart"), this.para.getFieldValue("TitleEnd"));
            String content = StringUtils.subStr(html, this.para.getFieldValue("ContentStart"), this.para.getFieldValue("ContentEnd"));
            String summary = "";
            if (content != null) {
                summary = StringUtils.removeHtml(content);
            }
            if (summary.length() > 250) {
                summary = summary.substring(0, 250);
            }
            String author = StringUtils.subStr(html, this.para.getFieldValue("AuthorStart"), this.para.getFieldValue("AuthorEnd"));
            String from = StringUtils.subStr(html, this.para.getFieldValue("FromStart"), this.para.getFieldValue("FromEnd"));
            String randStr = "";
            Random r = new Random();
            for (int j = 0; j < 6; ++j) {
                int rand = r.nextInt(99);
                randStr = randStr + rand;
            }
            String todayStr = DateUtil.getStringDateShort();
            String fileExt = Sysconfig.getFileExt();
            String fileName = randStr + fileExt;
            String SavePath = "/html/" + todayStr + "/" + fileName;
            int catalogid = Integer.parseInt(this.para.getFieldValue("CategoryId"));
            int parentid = Integer.parseInt(this.para.getFieldValue("ParentId"));
            int templateid = Integer.parseInt(this.para.getFieldValue("TemplateId"));
            Timestamp addtime = DateUtil.getCurrentGMTTimestamp();
            boolean bl = DaoFactory.getArticleDAO().addArticle(title, title, "", title, "", 10, content, 0, "", parentid, catalogid, templateid, 0, 0, 0, 0, 0, 0, 0, author, from, "", "", "", 0, SavePath, addtime, 0, summary);
            if (bl) {
                DaoFactory.getGatherHisDAO().addGatherHis(title, this.fileurl, addtime);
            }
        }
    }
}

