/*
 * Decompiled with CFR 0.152.
 */
package tot.gather;

import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.gather.ScheduledGatherThread;

public class ScheduledGatherTask {
    private static Log log = LogFactory.getLog(ScheduledGatherTask.class);
    ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
    public static HashMap taskList = new HashMap();
    int taskId = 0;
    long timeafter = 0L;
    long septime = 0L;

    public ScheduledGatherTask(int taskid, long time1, long time2) {
        this.taskId = taskid;
        this.timeafter = time1;
        this.septime = time2;
    }

    public void start() throws IOException {
        taskList.put(this.taskId, this);
        log.info((Object)("start timer gather taskID:" + this.taskId + " by timeafter:" + this.timeafter + "septime:" + this.septime));
        this.executor.scheduleAtFixedRate(new ScheduledGatherThread(this.taskId), this.timeafter, this.septime, TimeUnit.SECONDS);
    }

    public static ScheduledGatherTask get(int taskid) {
        return (ScheduledGatherTask)taskList.get(taskid);
    }

    public void shutdown() throws InterruptedException {
        log.info((Object)("shut down gather task" + this.executor));
        this.executor.shutdown();
        this.executor.awaitTermination(2L, TimeUnit.SECONDS);
        if (this.executor.isTerminated()) {
            this.executor.shutdownNow();
        }
    }
}

