/*
 * Decompiled with CFR 0.152.
 */
package tot.gather;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.bean.DataField;
import tot.dao.DaoFactory;
import tot.gather.GatherTask;
import tot.util.HtmlParse;
import tot.util.StringUtils;
import tot.util.UrlUtil;

public class ScheduledGatherThread
implements Runnable {
    private static Log log = LogFactory.getLog(ScheduledGatherThread.class);
    private int taskId = 0;
    private int count = 0;

    public ScheduledGatherThread(int taskid) {
        this.taskId = taskid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        DataField df;
        ++this.count;
        log.debug((Object)("start scheduled gather task:" + this.taskId + " for " + this.count + " times"));
        if (this.taskId > 0 && (df = DaoFactory.getGatherDAO().getGather(this.taskId)) != null) {
            int ReplaceUrl = Integer.parseInt(df.getFieldValue("ReplaceUrl"));
            String UrlFrom = df.getFieldValue("UrlFrom");
            String UrlTo = df.getFieldValue("UrlTo");
            String ReplaceStr = df.getFieldValue("ReplaceStr");
            String ListLabelStart = df.getFieldValue("ListLabelStart");
            String ListLabelEnd = df.getFieldValue("ListLabelEnd");
            String content = UrlUtil.getHtml(df.getFieldValue("Url"), df.getFieldValue("Encode"));
            if (content != null) {
                String links = StringUtils.subStr(content, ListLabelStart, ListLabelEnd);
                if (ReplaceUrl == 1) {
                    links = StringUtils.replaceString(links, UrlFrom, UrlTo);
                }
                if (ReplaceStr != null && ReplaceStr.length() > 0) {
                    links = StringUtils.replaceString(links, ReplaceStr, "");
                }
                String[] linkArr = HtmlParse.getUrls(links);
                GatherTask task = new GatherTask(linkArr, df);
                try {
                    task.start();
                }
                catch (IOException e) {
                    log.debug((Object)e);
                }
                finally {
                    try {
                        task.shutdown();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }
}

