/*
 * Decompiled with CFR 0.152.
 */
package tot.global;

import java.io.File;
import java.net.URLDecoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.util.FileUtil;
import tot.xml.DOM4JConfiguration;

public class Sysconfig {
    private static Log log = LogFactory.getLog(Sysconfig.class);
    static final String OPTION_FILE_NAME = "totcms.xml";
    private static String totcms_version = "Tot Cms 1.1";
    private static boolean useDataSource = false;
    private static String dataSourceName = "";
    private static int databaseType = 0;
    private static String driverClassName = "org.gjt.mm.mysql.Driver";
    private static String databaseURL = "jdbc:mysql://127.0.0.1/totcms?useUnicode=true&characterEncoding=utf-8";
    private static String databaseUser = "root";
    private static String databasePassword = "";
    private static int maxConnection = 20;
    private static int maxTimeToWait = 2000;
    private static int minutesBetweenRefresh = 30;
    private static boolean useMailSource = false;
    private static String mailSourceName = "";
    private static String mailServer = "mail.yourdomain";
    private static int mailServerPort = 25;
    private static String defaultMailFrom = "youruser@yourdomain";
    private static String mailUserName = "";
    private static String mailPassword = "";
    private static String contextPath = "";
    private static String site_url = "";
    private static String site_name = "totcms";
    private static String cookie_domain = "totcms.com";
    private static int article_num_per_page = 50;
    private static String file_ext = ".htm";
    private static int rss_new_num = 50;
    private static int page_send_maxnum = 50;
    private static int upload_photo_maxsize = 200;
    private static String upload_permit_ext = "gif,jpeg,png,bmp,rar,doc,txt,zip,wmv,rm,rmvb,mov,mp3,avi";
    private static boolean wartermark = false;
    private static int wartermark_type = 1;
    private static String wartermark_text = "";
    private static String wartermark_color = "";
    private static int wartermark_size = 1;
    private static int wartermark_position = 1;
    private static boolean save_admin_log = false;
    private static int minfetchmoney = 1;
    private static boolean mail_verify = false;
    private static String indexdir = "";
    private static String luceneAnalyzerClassName = "org.apache.lucene.analysis.standard.StandardAnalyzer";
    private static int serverHourOffset = 0;
    private static String blockedIPs = "";
    private static String distribute_ip = "";
    private static String distribute_key = "";
    private static boolean distribute_active = false;
    private static float tutor_money_per_pub = 0.0f;
    private static String paycomid = "";
    private static String paykey = "";
    private static String ninebill_paycomid = "";
    private static String ninebill_paykey = "";
    private static String alipay_paycomid = "";
    private static String alipay_paykey = "";

    public static String getTotCmsVersion() {
        return totcms_version;
    }

    public static boolean isUseDataSource() {
        return useDataSource;
    }

    public static String getDataSourceName() {
        return dataSourceName;
    }

    public static int getDatabaseType() {
        return databaseType;
    }

    public static String getDriverClassName() {
        return driverClassName;
    }

    public static String getDatabaseURL() {
        return databaseURL;
    }

    public static String getDatabaseUser() {
        return databaseUser;
    }

    public static String getDatabasePassword() {
        return databasePassword;
    }

    public static int getMaxConnection() {
        return maxConnection;
    }

    public static int getMaxTimeToWait() {
        return maxTimeToWait;
    }

    public static int getMinutesBetweenRefresh() {
        return minutesBetweenRefresh;
    }

    public static boolean isUseMailSource() {
        return useMailSource;
    }

    public static String getMailSourceName() {
        return mailSourceName;
    }

    public static String getMailServer() {
        return mailServer;
    }

    public static int getMailServerPort() {
        return mailServerPort;
    }

    public static String getDefaultMailFrom() {
        return defaultMailFrom;
    }

    public static String getMailUserName() {
        return mailUserName;
    }

    public static String getMailPassword() {
        return mailPassword;
    }

    public static String getContextPath() {
        return contextPath;
    }

    public static String getSiteUrl() {
        return site_url;
    }

    public static String getSiteName() {
        return site_name;
    }

    public static String getCookieDomain() {
        return cookie_domain;
    }

    public static int getArticleNumPerPage() {
        return article_num_per_page;
    }

    public static String getFileExt() {
        return file_ext;
    }

    public static int getRssNewNum() {
        return rss_new_num;
    }

    public static int getPageSendMaxNum() {
        return page_send_maxnum;
    }

    public static int getUploadPhotoMaxsize() {
        return upload_photo_maxsize;
    }

    public static String getUploadPermitExt() {
        return upload_permit_ext;
    }

    public static boolean isWarterMark() {
        return wartermark;
    }

    public static int getWarterMarkType() {
        return wartermark_type;
    }

    public static String getWarterMarkText() {
        return wartermark_text;
    }

    public static String getWarterMarkColor() {
        return wartermark_color;
    }

    public static int getWarterMarkSize() {
        return wartermark_size;
    }

    public static int getWarterMarkPosition() {
        return wartermark_position;
    }

    public static boolean isSaveAdminLog() {
        return save_admin_log;
    }

    public static int getMinFetchMoney() {
        return minfetchmoney;
    }

    public static boolean isMailVerify() {
        return mail_verify;
    }

    public static String getIndexDir() {
        return indexdir;
    }

    public static String getLuceneAnalyzerClassName() {
        return luceneAnalyzerClassName;
    }

    public static int getServerHourOffset() {
        return serverHourOffset;
    }

    public static String getBlockedIPs() {
        return blockedIPs;
    }

    public static String getDistributeIp() {
        return distribute_ip;
    }

    public static String getDistributeKey() {
        return distribute_key;
    }

    public static boolean isDistributeActive() {
        return distribute_active;
    }

    public static float getTutorMoneyPerPub() {
        return tutor_money_per_pub;
    }

    public static String getPayComId() {
        return paycomid;
    }

    public static String getPayKey() {
        return paykey;
    }

    public static String getNineBillPayComId() {
        return ninebill_paycomid;
    }

    public static String getNineBillPayKey() {
        return ninebill_paykey;
    }

    public static String getAlipayPayComId() {
        return alipay_paycomid;
    }

    public static String getAlipayPayKey() {
        return alipay_paykey;
    }

    public static void load() {
        Sysconfig.reload();
    }

    public static void reload() {
        String classPath = FileUtil.getServletClassesPath();
        String configFilename = classPath + OPTION_FILE_NAME;
        try {
            DOM4JConfiguration conf = new DOM4JConfiguration(new File(configFilename));
            totcms_version = conf.getString("global_options.totcms_version");
            useDataSource = conf.getBoolean("dboptions.use_datasource", false);
            databaseType = conf.getInt("dboptions.database_type", 0);
            if (useDataSource) {
                dataSourceName = conf.getString("dboptions.datasource_name");
            } else {
                driverClassName = conf.getString("dboptions.driver_class_name", driverClassName);
                databaseURL = conf.getString("dboptions.database_url", databaseURL);
                databaseUser = conf.getString("dboptions.database_user", databaseUser);
                databasePassword = conf.getString("dboptions.database_password", databasePassword);
                maxConnection = conf.getInt("dboptions.max_connection", maxConnection);
                maxTimeToWait = conf.getInt("dboptions.max_time_to_wait", maxTimeToWait);
                if ((minutesBetweenRefresh = conf.getInt("dboptions.minutes_between_refresh", minutesBetweenRefresh)) < 1) {
                    minutesBetweenRefresh = 1;
                }
            }
            useMailSource = conf.getBoolean("mailoptions.use_mailsource", false);
            if (useMailSource) {
                mailSourceName = conf.getString("mailoptions.mailsource_name");
            } else {
                mailServer = conf.getString("mailoptions.mail_server", mailServer);
                defaultMailFrom = conf.getString("mailoptions.default_mail_from", defaultMailFrom);
                mailUserName = conf.getString("mailoptions.username", mailUserName);
                mailPassword = conf.getString("mailoptions.password", mailPassword);
                mailServerPort = conf.getInt("mailoptions.port", mailServerPort);
            }
            contextPath = conf.getString("paramoptions.context_path", contextPath);
            if (contextPath.endsWith("/")) {
                contextPath = contextPath.substring(0, contextPath.length() - 1);
            }
            if ((site_url = conf.getString("paramoptions.site_url", site_url)).endsWith("/")) {
                site_url = site_url.substring(0, site_url.length() - 1);
            }
            if ((site_name = conf.getString("paramoptions.site_name", site_name)) != null) {
                site_name = URLDecoder.decode(new String(site_name.getBytes("iso-8859-1"), "utf-8"), "utf-8");
            }
            cookie_domain = conf.getString("paramoptions.cookie_domain", cookie_domain);
            article_num_per_page = conf.getInt("paramoptions.article_num_per_page", article_num_per_page);
            file_ext = conf.getString("paramoptions.file_ext", file_ext);
            rss_new_num = conf.getInt("paramoptions.rss_new_num", rss_new_num);
            page_send_maxnum = conf.getInt("paramoptions.page_send_maxnum", page_send_maxnum);
            upload_photo_maxsize = conf.getInt("paramoptions.upload_photo_maxsize", upload_photo_maxsize);
            upload_permit_ext = conf.getString("paramoptions.upload_permit_ext", upload_permit_ext);
            wartermark = conf.getBoolean("paramoptions.wartermark", wartermark);
            wartermark_type = conf.getInt("paramoptions.wartermark_type", wartermark_type);
            if ((wartermark_text = conf.getString("paramoptions.wartermark_text", wartermark_text)) != null) {
                wartermark_text = URLDecoder.decode(new String(wartermark_text.getBytes("iso-8859-1"), "utf-8"), "utf-8");
            }
            wartermark_color = conf.getString("paramoptions.wartermark_color", wartermark_color);
            wartermark_size = conf.getInt("paramoptions.wartermark_size", wartermark_size);
            wartermark_position = conf.getInt("paramoptions.wartermark_position", wartermark_position);
            save_admin_log = conf.getBoolean("paramoptions.save_admin_log", save_admin_log);
            minfetchmoney = conf.getInt("paramoptions.minfetchmoney", minfetchmoney);
            mail_verify = conf.getBoolean("paramoptions.mail_verify", mail_verify);
            indexdir = conf.getString("searchindex.indexdir", indexdir);
            luceneAnalyzerClassName = conf.getString("searchindex.lucene_analyzer_implementation", luceneAnalyzerClassName);
            if ((serverHourOffset = conf.getInt("dateoptions.server_hour_offset", serverHourOffset)) < -13 || serverHourOffset > 13) {
                serverHourOffset = 0;
            }
            blockedIPs = conf.getString("ipoptions.blocked_ip", blockedIPs);
            distribute_ip = conf.getString("distribute.distribute_ip", distribute_ip);
            distribute_active = conf.getBoolean("distribute.distribute_active", distribute_active);
            distribute_key = conf.getString("distribute.distribute_key", distribute_key);
            tutor_money_per_pub = conf.getFloat("tutor.tutor_money_per_pub", tutor_money_per_pub);
            paycomid = conf.getString("payapi.tenpay_paycomid", paycomid);
            paykey = conf.getString("payapi.tenpay_paykey", paykey);
            ninebill_paycomid = conf.getString("payapi.ninebill_paycomid", ninebill_paycomid);
            ninebill_paykey = conf.getString("payapi.ninebill_paykey", ninebill_paykey);
            alipay_paycomid = conf.getString("payapi.alipay_paycomid", alipay_paycomid);
            alipay_paykey = conf.getString("payapi.alipay_paykey", alipay_paykey);
        }
        catch (Exception e) {
            String message = "global.Sysconfig: Can't read the configuration file: '" + configFilename + "'. Make sure the file is in your CLASSPATH";
            log.error((Object)message, (Throwable)e);
        }
    }

    static {
        Sysconfig.load();
    }
}

