/*
 * Decompiled with CFR 0.152.
 */
package tot.search;

import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.bean.DataField;
import tot.search.ArticleIndex;

public class AddUpdateIndexTask
extends TimerTask {
    private static Log log = LogFactory.getLog(AddUpdateIndexTask.class);
    public static final int OPERATION_ADD = 0;
    public static final int OPERATION_UPDATE = 1;
    private DataField df;
    private int operation;

    AddUpdateIndexTask(DataField article, int operation) {
        this.df = article;
        this.operation = operation;
    }

    public void run() {
        log.debug((Object)("AddUpdateIndexTask.run : op = " + this.operation + " for article = " + this.df.getFieldValue("id")));
        try {
            switch (this.operation) {
                case 1: {
                    ArticleIndex.deleteFromIndex(Integer.parseInt(this.df.getFieldValue("id")));
                }
                case 0: {
                    ArticleIndex.addToIndex(this.df);
                    break;
                }
                default: {
                    log.warn((Object)("Cannot process the AddUpdateIndexTask with operation = " + this.operation));
                    break;
                }
            }
        }
        catch (Exception ex) {
            log.error((Object)"Error while performing index operation", (Throwable)ex);
        }
    }
}

