/*
 * Decompiled with CFR 0.152.
 */
package tot.search;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import tot.bean.DataField;
import tot.exception.SearchException;
import tot.global.Sysconfig;
import tot.search.AddUpdateIndexTask;
import tot.search.DeleteIndexTask;
import tot.search.RebuildIndexTask;
import tot.search.SearchService;
import tot.util.TimerUtil;

public class ArticleIndex {
    private static Log log = LogFactory.getLog(ArticleIndex.class);
    private static Analyzer analyzer;
    private static String searchArticleIndexDir;
    private static long lastOptimizeTime;

    public static void scheduleAddTask(DataField df) {
        AddUpdateIndexTask task = new AddUpdateIndexTask(df, 0);
        TimerUtil.getInstance().schedule((TimerTask)task, 0L);
    }

    public static void scheduleUpdateTask(DataField df) {
        AddUpdateIndexTask task = new AddUpdateIndexTask(df, 1);
        TimerUtil.getInstance().schedule((TimerTask)task, 0L);
    }

    public static void scheduleDeleteTask(int objectID) {
        DeleteIndexTask task = new DeleteIndexTask(objectID);
        TimerUtil.getInstance().schedule((TimerTask)task, 0L);
    }

    public static void scheduleRebuildIndexTask() {
        int maxPostID = 0;
        RebuildIndexTask task = new RebuildIndexTask(maxPostID);
        TimerUtil.getInstance().schedule((TimerTask)task, 0L);
    }

    static Analyzer getAnalyzer() {
        return analyzer;
    }

    private static void initializeAnalyzer() {
        String analyzerClassName = Sysconfig.getLuceneAnalyzerClassName();
        if (analyzerClassName == null || analyzerClassName.equals("")) {
            analyzer = new StandardAnalyzer();
            log.debug((Object)"Using StandardAnalyzer for indexing");
        } else {
            try {
                log.debug((Object)("About to load Analyzer [" + analyzerClassName + "] for indexing"));
                analyzer = (Analyzer)Class.forName(analyzerClassName).newInstance();
            }
            catch (Exception e) {
                log.warn((Object)("Cannot load " + analyzerClassName + ". Loading StandardAnalyzer"));
                analyzer = new StandardAnalyzer();
            }
        }
    }

    static IndexWriter getIndexWriter(Directory directory, boolean create) {
        IndexWriter writer = null;
        try {
            writer = new IndexWriter(directory, analyzer, create);
            writer.setUseCompoundFile(true);
        }
        catch (IOException e) {
            log.warn((Object)"Cannot open existed index. New index will be created.", (Throwable)e);
        }
        return writer;
    }

    static void doIndex(DataField df, IndexWriter writer) throws SearchException {
        if (df == null) {
            return;
        }
        String title = df.getFieldValue("Title");
        String content = df.getFieldValue("Content");
        String Summary = df.getFieldValue("Summary");
        String datetime = df.getFieldValue("ModiTime");
        if (title == null || title.equals("") || content == null || content.equals("")) {
            return;
        }
        if (Summary == null) {
            Summary = "...";
        }
        Document dfDocument = new Document();
        dfDocument.add((Fieldable)new Field("id", df.getFieldValue("id"), Field.Store.YES, Field.Index.UN_TOKENIZED));
        dfDocument.add((Fieldable)new Field("Hits", df.getFieldValue("Hits"), Field.Store.YES, Field.Index.UN_TOKENIZED));
        dfDocument.add((Fieldable)new Field("CatalogId", df.getFieldValue("CategoryId"), Field.Store.YES, Field.Index.UN_TOKENIZED));
        dfDocument.add((Fieldable)new Field("SavePath", df.getFieldValue("SavePath"), Field.Store.YES, Field.Index.UN_TOKENIZED));
        dfDocument.add((Fieldable)new Field("Title", title, Field.Store.YES, Field.Index.TOKENIZED));
        dfDocument.add((Fieldable)new Field("Summary", Summary, Field.Store.YES, Field.Index.TOKENIZED));
        dfDocument.add((Fieldable)new Field("Content", df.getFieldValue("Content"), Field.Store.NO, Field.Index.TOKENIZED));
        dfDocument.add((Fieldable)new Field("ModiTime", DateTools.dateToString((Date)Timestamp.valueOf(datetime), (DateTools.Resolution)DateTools.Resolution.MILLISECOND), Field.Store.YES, Field.Index.UN_TOKENIZED));
        try {
            writer.addDocument(dfDocument);
        }
        catch (IOException e) {
            log.error((Object)"ArticleIndexer.doIndex failed", (Throwable)e);
            throw new SearchException("Error writing new df to index");
        }
    }

    static void addToIndex(DataField df) throws SearchException, IOException {
        Directory directory = null;
        IndexWriter writer = null;
        try {
            directory = SearchService.getSearchIndexDir();
            writer = ArticleIndex.getIndexWriter(directory, false);
            if (writer == null) {
                log.warn((Object)"Cannot get the IndexWriter");
                return;
            }
            ArticleIndex.doIndex(df, writer);
            long now = System.currentTimeMillis();
            long timeFromLastOptimize = now - lastOptimizeTime;
            if (timeFromLastOptimize > 3600000L) {
                log.debug((Object)"writer.optimize() called in addToIndex");
                writer.optimize();
                lastOptimizeTime = now;
            }
        }
        catch (SearchException ex) {
            throw ex;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    log.debug((Object)"Error closing Lucene IndexWriter", (Throwable)e);
                }
            }
            if (directory != null) {
                try {
                    directory.close();
                }
                catch (IOException e) {
                    log.debug((Object)"Cannot close directory.", (Throwable)e);
                }
            }
        }
    }

    static void deleteFromIndex(int dfID) throws SearchException {
        Directory directory = null;
        IndexReader reader = null;
        try {
            directory = SearchService.getSearchIndexDir();
            reader = IndexReader.open((Directory)directory);
            if (reader == null) {
                log.warn((Object)"Cannot get the IndexReader");
                return;
            }
            Term term = new Term("id", String.valueOf(dfID));
            int deletedCount = reader.deleteDocuments(term);
            log.debug((Object)("deleteFromIndex: deleted articles = " + deletedCount));
        }
        catch (IOException e) {
            throw new SearchException("Error trying to delete df with article id = " + dfID);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    log.debug((Object)"Error closing Lucene IndexReader", (Throwable)e);
                }
            }
            if (directory != null) {
                try {
                    directory.close();
                }
                catch (IOException e) {
                    log.debug((Object)"Cannot close directory.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNumDocs() {
        int numDocs = -1;
        Directory directory = null;
        IndexReader reader = null;
        try {
            directory = SearchService.getSearchIndexDir();
            reader = IndexReader.open((Directory)directory);
            if (reader == null) {
                log.warn((Object)"Cannot get the IndexReader");
                int n = -1;
                return n;
            }
            numDocs = reader.numDocs();
        }
        catch (IOException ioe) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    log.debug((Object)"Error closing Lucene IndexReader", (Throwable)e);
                }
            }
            if (directory != null) {
                try {
                    directory.close();
                }
                catch (IOException e) {
                    log.debug((Object)"Cannot close directory.", (Throwable)e);
                }
            }
        }
        return numDocs;
    }

    static {
        lastOptimizeTime = 0L;
        searchArticleIndexDir = Sysconfig.getIndexDir();
        ArticleIndex.initializeAnalyzer();
    }
}

