/*
 * Decompiled with CFR 0.152.
 */
package tot.search;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import tot.exception.BadInputException;
import tot.search.SearchQueryNoSql;
import tot.util.DateUtil;

public class ArticleSearch {
    public void processSearch(HttpServletRequest request, HttpServletResponse response, String key, int scopein, int date, int offset, int rows, int beforafter, int sorttype, int catalogid) throws BadInputException, IOException {
        if (rows == 0) {
            rows = 20;
        }
        offset = offset / rows * rows;
        SearchQueryNoSql query = new SearchQueryNoSql();
        if (key != null && key.length() > 0) {
            query.setSearchString(key);
            query.setScopeInArticle(scopein);
        }
        if (date != 0 && date < 3650) {
            long deltaTime = 86400000L * (long)date;
            Timestamp now = DateUtil.getCurrentGMTTimestamp();
            Timestamp from = null;
            Timestamp to = null;
            long currentTime = now.getTime();
            if (beforafter == 1) {
                from = new Timestamp(currentTime - deltaTime);
            } else {
                to = new Timestamp(currentTime - deltaTime);
            }
            query.setFromDate(from);
            query.setToDate(to);
        }
        if (catalogid > 0) {
            query.setCatalogId(catalogid);
        }
        query.setSortType(sorttype);
        query.searchDocuments(offset, rows);
        int hitCount = query.getHitCount();
        Collection result = query.getArticleResult();
        if (offset > hitCount) {
            throw new BadInputException("Cannot search with offset(" + offset + ") > total(" + hitCount + ") posts");
        }
        request.setAttribute("rows", (Object)new Integer(rows));
        request.setAttribute("TotalArticles", (Object)new Integer(hitCount));
        request.setAttribute("ArticleBeans", (Object)result);
        request.setAttribute("SearchQuery", (Object)query);
    }
}

