/*
 * Decompiled with CFR 0.152.
 */
package tot.search;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import tot.bean.DataField;
import tot.dao.DaoFactory;
import tot.db.DBUtils;
import tot.search.ArticleIndex;
import tot.util.DateUtil;
import tot.util.RequestUtil;

public class IndexWebHander {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static int addIndexByDate(HttpServletRequest request) {
        String fromdate = RequestUtil.getString(request, "FromDate");
        String todate = RequestUtil.getString(request, "ToDate");
        Timestamp FromDate = null;
        if (fromdate != null && !fromdate.equals("")) {
            FromDate = new Timestamp(DateUtil.strToBirthday(fromdate).getTime());
        }
        Timestamp ToDate = null;
        if (todate != null && !todate.equals("")) {
            ToDate = new Timestamp(DateUtil.strToBirthday(todate).getTime());
        }
        String fieldArr = "id,Title,Content,SavePath,ModiTime,Hits,Checked,CategoryId";
        String sql = null;
        sql = "select " + fieldArr + " from t_article where ModiTime>? and ModiTime<?";
        ArrayList<DataField> articles = new ArrayList<DataField>();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = DBUtils.getConnection();
            ps = conn.prepareStatement(sql);
            ps.setTimestamp(1, FromDate);
            ps.setTimestamp(2, ToDate);
            rs = ps.executeQuery();
            String[] splitStr = null;
            splitStr = fieldArr.split(",");
            while (rs.next()) {
                DataField df = new DataField();
                for (int i = 0; i < splitStr.length; ++i) {
                    df.setField(splitStr[i], rs.getString(i + 1), 0);
                }
                articles.add(df);
            }
        }
        catch (SQLException e) {
            DBUtils.closeResultSet(rs);
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
            catch (Throwable throwable) {
                DBUtils.closeResultSet(rs);
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
                throw throwable;
            }
        }
        DBUtils.closeResultSet(rs);
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        int startN = 0;
        for (DataField df : articles) {
            ArticleIndex.scheduleAddTask(df);
            ++startN;
        }
        return startN;
    }

    public static int addIndexById(HttpServletRequest request) {
        int fromid = RequestUtil.getInt(request, "FromId");
        int ToId = RequestUtil.getInt(request, "ToId");
        String fieldArr = "id,Title,Content,SavePath,ModiTime,Hits,Checked,CategoryId";
        String sql = null;
        sql = "select " + fieldArr + " from t_article where IsOutLink=0 and id>=" + fromid + " and id<=" + ToId;
        Collection articles = DaoFactory.getArticleDAO().getData(sql, fieldArr);
        int startN = 0;
        for (DataField df : articles) {
            ArticleIndex.scheduleAddTask(df);
            ++startN;
        }
        return startN;
    }

    public static void addIndexById(int id) {
        DataField df = DaoFactory.getArticleDAO().getArticle(id);
        if (df != null) {
            ArticleIndex.scheduleAddTask(df);
        }
    }

    public static int runIndexByBat(HttpServletRequest request, String runtype) {
        String[] articleid = request.getParameterValues("articleid");
        int num = articleid.length;
        String fieldArr = "id,Title,Content,SavePath,ModiTime,Hits,Checked,CategoryId";
        String sql = null;
        sql = "select " + fieldArr + " from t_article where IsOutLink=0";
        if (runtype != null && runtype.equals("delete")) {
            for (int i = 0; i < num; ++i) {
                ArticleIndex.scheduleDeleteTask(Integer.parseInt(articleid[i]));
            }
        } else {
            for (int i = 0; i < num; ++i) {
                DataField df = DaoFactory.getArticleDAO().getFirstData(sql + " and id=" + articleid[i], fieldArr);
                if (runtype != null && runtype.equals("add")) {
                    ArticleIndex.scheduleAddTask(df);
                    continue;
                }
                if (runtype == null || !runtype.equals("update")) continue;
                ArticleIndex.scheduleUpdateTask(df);
            }
        }
        return num;
    }
}

