/*
 * Decompiled with CFR 0.152.
 */
package tot.search;

import java.io.IOException;
import java.util.Collection;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import tot.bean.DataField;
import tot.dao.DaoFactory;
import tot.search.ArticleIndex;
import tot.search.SearchService;

public class RebuildIndexTask
extends TimerTask {
    private static Log log = LogFactory.getLog(RebuildIndexTask.class);
    public static final int Articles_PER_FETCH = 200;
    public static final int MERGE_FACTOR = 20;
    private int maxArticleID = 0;
    private static boolean isRebuilding = false;

    public static boolean isRebuilding() {
        return isRebuilding;
    }

    RebuildIndexTask(int maxArticleID) {
        this.maxArticleID = maxArticleID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        isRebuilding = true;
        long start = System.currentTimeMillis();
        Directory directory = null;
        IndexWriter writer = null;
        try {
            directory = SearchService.getSearchIndexDir();
            writer = ArticleIndex.getIndexWriter(directory, true);
            writer.setMergeFactor(20);
            int articleTotal = DaoFactory.getArticleDAO().getTotalCount(0);
            int pagenum = (articleTotal - 1 + 200) / 200;
            int indexNum = 0;
            for (int index = 1; index <= pagenum; ++index) {
                Collection articles = DaoFactory.getArticleDAO().getArticleIndex_Limit(0, index, 200);
                for (DataField df : articles) {
                    ArticleIndex.doIndex(df, writer);
                    ++indexNum;
                }
            }
            writer.optimize();
            log.info((Object)("Rebuilt index finished successfully! " + indexNum + " article(s) indexed."));
        }
        catch (Exception e) {
            log.error((Object)"Error while rebuilding index", (Throwable)e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
                if (directory != null) {
                    directory.close();
                    log.debug((Object)"Cannot close directory.");
                }
            }
            catch (IOException e) {
                log.debug((Object)"Close directory case exception:", (Throwable)e);
            }
        }
        log.info((Object)("RebuildIndexTask took " + (System.currentTimeMillis() - start) + " ms"));
        isRebuilding = false;
    }
}

