/*
 * Decompiled with CFR 0.152.
 */
package tot.search;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RangeFilter;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import tot.bean.DataField;
import tot.dao.DaoFactory;
import tot.global.Sysconfig;
import tot.search.ArticleIndex;
import tot.search.SearchService;
import tot.search.filter.CombineFilter;
import tot.search.filter.IntegerFilter;

public class SearchQuery {
    private static Log log = LogFactory.getLog(SearchQuery.class);
    public static final int SEARCH_ANY_DATE = 0;
    public static final int SEARCH_NEWER = 1;
    public static final int SEARCH_OLDER = 2;
    public static final int SEARCH_ONLY_TITLE = 1;
    public static final int SEARCH_ONLY_BODY = 2;
    public static final int SEARCH_SORT_DEFAULT = 0;
    public static final int SEARCH_SORT_TIME_DESC = 1;
    public static final int SEARCH_SORT_TIME_ASC = 2;
    private String userName = null;
    private int catalogid = -1;
    private int blogHits = -1;
    private String searchString = null;
    private Timestamp fromDate = null;
    private Timestamp toDate = null;
    private String searchIndexDir = Sysconfig.getIndexDir();
    private int hitCount = 0;
    private Collection searchResult = null;
    private int scopeInArticle = 3;
    private int sort = 0;

    public void setUserName(String membername) {
        this.userName = membername;
    }

    public void setCatalogId(int catalogid) {
        this.catalogid = catalogid;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    public void setScopeInArticle(int scopeInArticle) {
        this.scopeInArticle = scopeInArticle;
    }

    public void setArticleHitsLimit(int hitsNum) {
        this.blogHits = hitsNum;
    }

    public void setFromDate(Timestamp fromDate) {
        this.fromDate = fromDate;
    }

    public void setToDate(Timestamp toDate) {
        this.toDate = toDate;
    }

    public void setSortType(int stype) {
        this.sort = stype;
    }

    protected IndexSearcher getSearcher(Directory directory) throws IOException {
        try {
            IndexSearcher searcher = new IndexSearcher(directory);
            return searcher;
        }
        catch (IOException ex) {
            log.error((Object)"Cannot access the lucene search index for query.  You can also go to Admin Zone to rebuild the Lucene index files.", (Throwable)ex);
            throw new IOException("Cannot access the lucene search index. Please report this error to web site Administrator .");
        }
    }

    public void searchDocuments(int offset, int rowsToReturn) throws IOException {
        if (this.searchString == null || this.searchString.equals("")) {
            return;
        }
        BooleanQuery query = new BooleanQuery();
        try {
            Query memberQuery;
            Query catalogQuery;
            Query topicBodyQuery = this.getTopicBodyQuery();
            if (topicBodyQuery != null) {
                query.add(topicBodyQuery, BooleanClause.Occur.MUST);
                log.debug((Object)("topicBodyQuery = " + topicBodyQuery));
            }
            if ((catalogQuery = this.getCatalogQuery()) != null) {
                log.debug((Object)("categoryForumQuery = " + catalogQuery));
                query.add(catalogQuery, BooleanClause.Occur.MUST);
            }
            if ((memberQuery = this.getMemberQuery()) != null) {
                log.debug((Object)("memberQuery = " + memberQuery));
                query.add(memberQuery, BooleanClause.Occur.MUST);
            }
        }
        catch (ParseException pe) {
            log.error((Object)"Cannot parse the search query", (Throwable)pe);
        }
        log.debug((Object)("booleanQuery = " + query));
        RangeFilter dateFilter = null;
        if (this.fromDate != null && this.toDate != null) {
            dateFilter = new RangeFilter("ModiTime", DateTools.dateToString((Date)this.fromDate, (DateTools.Resolution)DateTools.Resolution.MILLISECOND), DateTools.dateToString((Date)this.toDate, (DateTools.Resolution)DateTools.Resolution.MILLISECOND), true, true);
        } else if (this.fromDate != null) {
            dateFilter = RangeFilter.More((String)"ModiTime", (String)DateTools.dateToString((Date)this.fromDate, (DateTools.Resolution)DateTools.Resolution.MILLISECOND));
        } else if (this.toDate != null) {
            dateFilter = RangeFilter.Less((String)"ModiTime", (String)DateTools.dateToString((Date)this.toDate, (DateTools.Resolution)DateTools.Resolution.MILLISECOND));
        }
        IntegerFilter blogHitsFilter = null;
        if (this.blogHits > 0) {
            blogHitsFilter = IntegerFilter.greaterThan("Hits", this.blogHits);
        }
        Filter filter = null;
        filter = dateFilter != null ? (blogHitsFilter != null ? new CombineFilter((Filter)dateFilter, blogHitsFilter) : dateFilter) : blogHitsFilter;
        Directory directory = null;
        IndexSearcher searcher = null;
        try {
            directory = SearchService.getSearchIndexDir();
            searcher = this.getSearcher(directory);
            Hits postHits = null;
            postHits = filter != null ? searcher.search((Query)query, filter) : (filter != null ? searcher.search((Query)query, filter, this.getQuerySort()) : searcher.search((Query)query, this.getQuerySort()));
            this.hitCount = postHits.length();
            this.searchResult = this.getArticles(postHits, offset, rowsToReturn);
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            if (searcher != null) {
                try {
                    searcher.close();
                }
                catch (IOException ex) {
                    log.debug((Object)"Error closing Lucene IndexSearcher", (Throwable)ex);
                }
            }
        }
    }

    public int getHitCount() {
        return this.hitCount;
    }

    public Collection getArticleResult() {
        if (this.searchResult == null) {
            this.searchResult = new ArrayList();
        }
        return this.searchResult;
    }

    private Collection getArticles(Hits postHits, int offset, int rowsToReturn) throws IOException {
        if (offset < 0) {
            throw new IllegalArgumentException("The offset < 0 is not allowed.");
        }
        if (rowsToReturn <= 0) {
            throw new IllegalArgumentException("The rowsToReturn <= 0 is not allowed.");
        }
        ArrayList<DataField> retValue = new ArrayList<DataField>(this.hitCount);
        for (int i = offset; i < offset + rowsToReturn && i < this.hitCount; ++i) {
            Document postDocument = postHits.doc(i);
            int artId = Integer.parseInt(postDocument.get("id"));
            DataField df = DaoFactory.getArticleDAO().getArticle(artId);
            retValue.add(df);
        }
        return retValue;
    }

    private Query getTopicBodyQuery() throws ParseException {
        if (this.searchString == null || this.searchString.equals("")) {
            return null;
        }
        Analyzer analyzer = ArticleIndex.getAnalyzer();
        BooleanQuery topicBodyQuery = new BooleanQuery();
        Query topicQuery = new QueryParser("Title", analyzer).parse(this.searchString);
        topicBodyQuery.add(topicQuery, BooleanClause.Occur.SHOULD);
        Query bodyQuery = new QueryParser("Content", analyzer).parse(this.searchString);
        if (this.scopeInArticle == 1) {
            return topicQuery;
        }
        if (this.scopeInArticle == 2) {
            return bodyQuery;
        }
        topicBodyQuery.add(bodyQuery, BooleanClause.Occur.SHOULD);
        return topicBodyQuery;
    }

    private Query getMemberQuery() {
        TermQuery memberQuery = null;
        if (this.userName != null) {
            Term memberTerm = new Term("UserName", this.userName);
            memberQuery = new TermQuery(memberTerm);
        }
        return memberQuery;
    }

    private Query getCatalogQuery() {
        TermQuery catalogQuery = null;
        if (this.catalogid > 0) {
            Term catalogTerm = new Term("CatalogId", String.valueOf(this.catalogid));
            catalogQuery = new TermQuery(catalogTerm);
        }
        return catalogQuery;
    }

    public void setSort(int sort) {
        if (sort != 0 && sort != 2 && sort != 1) {
            throw new IllegalArgumentException("Does not support sort = " + sort);
        }
        this.sort = sort;
    }

    public int getSort() {
        return this.sort;
    }

    private Sort getQuerySort() {
        Sort sortObj = null;
        switch (this.sort) {
            case 2: {
                sortObj = new Sort(new SortField("ModiTime", 3, false));
                break;
            }
            case 1: {
                sortObj = new Sort(new SortField("ModiTime", 3, true));
                break;
            }
            default: {
                sortObj = new Sort();
            }
        }
        return sortObj;
    }
}

