/*
 * Decompiled with CFR 0.152.
 */
package tot.search.filter;

import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Filter;

public class CombineFilter
extends Filter {
    private Filter leftFilter;
    private Filter rightFilter;

    public CombineFilter(Filter f1, Filter f2) {
        if (f1 == null && f2 == null) {
            throw new IllegalArgumentException("At least f1 or f2 must not be null.");
        }
        this.leftFilter = f1;
        this.rightFilter = f2;
    }

    public BitSet bits(IndexReader reader) throws IOException {
        BitSet resultBits = null;
        if (this.leftFilter != null && this.rightFilter != null) {
            BitSet leftBits = this.leftFilter.bits(reader);
            BitSet rightBits = this.rightFilter.bits(reader);
            resultBits = (BitSet)leftBits.clone();
            resultBits.and(rightBits);
        } else if (this.leftFilter != null) {
            resultBits = this.leftFilter.bits(reader);
        } else if (this.rightFilter != null) {
            resultBits = this.rightFilter.bits(reader);
        } else {
            throw new IllegalArgumentException("At least f1 or f2 must not be null.");
        }
        return resultBits;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.leftFilter);
        buffer.append("\n");
        buffer.append(this.rightFilter);
        return buffer.toString();
    }
}

