/*
 * Decompiled with CFR 0.152.
 */
package tot.search.filter;

import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.Filter;

public class IntegerFilter
extends Filter {
    String field;
    String start = IntegerFilter.intToString(0);
    String end = IntegerFilter.intToString(Integer.MAX_VALUE);

    private IntegerFilter(String f) {
        this.field = f;
    }

    public IntegerFilter(String field, int from, int to) {
        this.field = field;
        this.start = IntegerFilter.intToString(from);
        this.end = IntegerFilter.intToString(to);
    }

    public IntegerFilter(String field, Integer from, Integer to) {
        this.field = field;
        this.start = IntegerFilter.intToString(from);
        this.end = IntegerFilter.intToString(to);
    }

    public static IntegerFilter greaterThan(String field, Integer i) {
        IntegerFilter result = new IntegerFilter(field);
        result.start = IntegerFilter.intToString(i);
        return result;
    }

    public static IntegerFilter greaterThan(String field, int i) {
        IntegerFilter result = new IntegerFilter(field);
        result.start = IntegerFilter.intToString(i);
        return result;
    }

    public static IntegerFilter lessThan(String field, Integer i) {
        IntegerFilter result = new IntegerFilter(field);
        result.end = IntegerFilter.intToString(i);
        return result;
    }

    public static IntegerFilter lessThan(String field, int i) {
        IntegerFilter result = new IntegerFilter(field);
        result.end = IntegerFilter.intToString(i);
        return result;
    }

    public static String intToString(int i) {
        return Integer.toString(i, 36);
    }

    public static int stringToInt(String i) {
        return Integer.parseInt(i, 36);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BitSet bits(IndexReader reader) throws IOException {
        BitSet bits = new BitSet(reader.maxDoc());
        TermEnum enumerator = reader.terms(new Term(this.field, this.start));
        TermDocs termDocs = reader.termDocs();
        if (enumerator.term() == null) {
            return bits;
        }
        try {
            Term stop = new Term(this.field, this.end);
            while (enumerator.term().compareTo(stop) <= 0) {
                termDocs.seek(enumerator.term());
                while (termDocs.next()) {
                    bits.set(termDocs.doc());
                }
                if (enumerator.next()) continue;
                break;
            }
        }
        finally {
            enumerator.close();
            termDocs.close();
        }
        return bits;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.field);
        buffer.append(":");
        buffer.append(this.start);
        buffer.append("-");
        buffer.append(this.end);
        return buffer.toString();
    }
}

