/*
 * Decompiled with CFR 0.152.
 */
package tot.send;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.bean.DataField;
import tot.dao.DaoFactory;
import tot.exception.BadInputException;
import tot.global.Sysconfig;
import tot.util.DateUtil;
import tot.util.DistributeUtil;
import tot.util.FileUtil;
import tot.util.LabelUtil;
import tot.util.ResourceBundleUtil;
import tot.util.StringUtils;

public class SendCategory {
    private static Log log = LogFactory.getLog(SendCategory.class);
    private boolean isauthoried = true;

    public void createCategoryIndex(Locale locale, int categoryId, String savePath, String template, String distributepath) throws BadInputException {
        String templateContent = "";
        if (DateUtil.isExpire()) {
            throw new BadInputException("System get error");
        }
        try {
            FileUtil.createDir(savePath, true);
        }
        catch (IOException e) {
            log.error((Object)("Can't create Dir:" + savePath));
        }
        try {
            templateContent = FileUtil.readFile(template, "UTF-8");
            templateContent = templateContent.replaceAll("</(?i)title>", " Powered by Tot Jsp Cms </title>");
            if (!this.isauthoried) {
                templateContent = templateContent + "<a href=\"http://www.totcms.com\">Powered by Tot Jsp Cms</a>";
            }
        }
        catch (Exception e) {
            log.error((Object)("Can't find template file:" + template));
        }
        String diagonal = FileUtil.getSeparator();
        templateContent = LabelUtil.replaceAllLabel(templateContent, categoryId);
        FileUtil.createFile(templateContent, savePath + diagonal + "index.htm", "UTF-8");
        log.info((Object)("create file:" + savePath + diagonal + "index.htm" + " success "));
        try {
            DistributeUtil.send(distributepath + "/" + "index.htm", templateContent);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void createCategoryList(Locale locale, int categoryId, int pagesizes, String savePath, String template, String distributepath) throws BadInputException {
        int totalnum = 0;
        int pagenum = 0;
        int maxPageNum = Sysconfig.getPageSendMaxNum();
        totalnum = DaoFactory.getArticleDAO().getCheckedTotalCount(categoryId);
        String templateContent = "";
        String contextPath = Sysconfig.getContextPath();
        String url = Sysconfig.getSiteUrl();
        if (DateUtil.isExpire()) {
            throw new BadInputException("System get error");
        }
        try {
            FileUtil.createDir(savePath, true);
        }
        catch (IOException e) {
            log.error((Object)("Can't create Dir:" + savePath));
        }
        try {
            templateContent = FileUtil.readFile(template, "UTF-8");
            templateContent = templateContent.replaceAll("</(?i)title>", " Powered by Tot Jsp Cms </title>");
        }
        catch (Exception e) {
            log.error((Object)("Can't find template file:" + template));
        }
        String diagonal = FileUtil.getSeparator();
        if (totalnum != 0) {
            pagenum = (totalnum + pagesizes - 1) / pagesizes;
            if (pagenum < 1) {
                pagenum = 1;
            }
            if (pagenum > maxPageNum) {
                pagenum = maxPageNum;
            }
            for (int i = 1; i <= pagenum; ++i) {
                StringBuffer newsliststr = new StringBuffer(512);
                String showpagestr = "";
                showpagestr = this.showPage(locale, i, totalnum, pagenum);
                ArrayList list = (ArrayList)DaoFactory.getArticleDAO().getArticleList_Limit(categoryId, i, pagesizes);
                int j = 0;
                StringBuffer goPage = new StringBuffer(512);
                goPage.append("&nbsp;&nbsp;GO&gt;&gt;<select size=1 onChange=\"javascript:window.location.href='index_'+(this.selectedIndex+1)+'.htm'\" name=\"this\">\n");
                for (int go_n = 1; go_n <= pagenum; ++go_n) {
                    if (go_n == i) {
                        goPage.append("<option value=\"" + go_n + "\" selected=\"selected\">" + go_n + "</option>\n");
                        continue;
                    }
                    goPage.append("<option value=\"" + go_n + "\">" + go_n + "</option>\n");
                }
                goPage.append("</select>&nbsp;&nbsp;");
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    ++j;
                    String tlinkurl = "";
                    DataField df = (DataField)iter.next();
                    StringTokenizer st = new StringTokenizer(df.getFieldValue("ModiTime"), " ");
                    tlinkurl = Integer.parseInt(df.getFieldValue("IsOutLink")) == 0 ? url + contextPath + df.getFieldValue("SavePath") : df.getFieldValue("OutLinkUrl");
                    newsliststr.append("<li>");
                    newsliststr.append("<span class=\"col_right\">");
                    newsliststr.append(st.nextToken());
                    newsliststr.append("</span>");
                    newsliststr.append("<a href=\"");
                    newsliststr.append(tlinkurl);
                    newsliststr.append("\" target=\"_blank\">");
                    newsliststr.append(df.getFieldValue("Title"));
                    newsliststr.append("</a>");
                    newsliststr.append("</li>\n");
                    if (j % 5 != 0) continue;
                    newsliststr.append("<hr />\n");
                }
                String Temptemplatecontent = templateContent;
                Temptemplatecontent = StringUtils.replaceString(Temptemplatecontent, "$ArticleList$", newsliststr.toString());
                Temptemplatecontent = i == maxPageNum ? StringUtils.replaceString(Temptemplatecontent, "$ShowPage$", "[<a href=\"index_" + (i - 1) + ".htm\">&lt;&lt;</a>]&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"" + contextPath + "/list_more.jsp?CatalogId=" + categoryId + "\">MORE=></a>&nbsp;&nbsp;&nbsp;&nbsp;") : StringUtils.replaceString(Temptemplatecontent, "$ShowPage$", showpagestr + goPage.toString());
                Temptemplatecontent = LabelUtil.replaceAllLabel(Temptemplatecontent, categoryId);
                FileUtil.createFile(Temptemplatecontent, savePath + diagonal + "index_" + i + ".htm", "UTF-8");
                log.info((Object)("create file:" + savePath + diagonal + "index_" + i + ".htm" + " success "));
                try {
                    DistributeUtil.send(distributepath + "/" + "index_" + i + ".htm", Temptemplatecontent);
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        } else {
            String Temptemplatecontent = templateContent;
            Temptemplatecontent = StringUtils.replaceString(Temptemplatecontent, "$ArticleList$", "");
            Temptemplatecontent = StringUtils.replaceString(Temptemplatecontent, "$ShowPage$", "");
            Temptemplatecontent = LabelUtil.replaceAllLabel(Temptemplatecontent, categoryId);
            FileUtil.createFile(Temptemplatecontent, savePath + diagonal + "index_1.htm", "UTF-8");
            log.info((Object)("create file:" + savePath + diagonal + "index_1.htm" + "success "));
        }
    }

    public void createCategoryListDesc(Locale locale, int categoryId, int pagesizes, String savePath, String template, String distributepath) {
        int totalnum = 0;
        int pagenum = 0;
        int maxPageNum = Sysconfig.getPageSendMaxNum();
        totalnum = DaoFactory.getArticleDAO().getCheckedTotalCount(categoryId);
        String templateContent = "";
        String contextPath = Sysconfig.getContextPath();
        String url = Sysconfig.getSiteUrl();
        try {
            FileUtil.createDir(savePath, true);
        }
        catch (IOException e) {
            log.error((Object)("Can't create Dir:" + savePath));
        }
        try {
            templateContent = FileUtil.readFile(template, "UTF-8");
        }
        catch (Exception e) {
            log.error((Object)("Can't find template file:" + template));
        }
        String diagonal = FileUtil.getSeparator();
        if (totalnum != 0) {
            pagenum = (totalnum + pagesizes - 1) / pagesizes;
            if (pagenum < 1) {
                pagenum = 1;
            }
            if (pagenum > maxPageNum) {
                pagenum = maxPageNum;
            }
            for (int i = 1; i <= pagenum; ++i) {
                StringBuffer newsliststr = new StringBuffer(512);
                String showpagestr = "";
                showpagestr = this.showPage(locale, i, totalnum, pagenum);
                ArrayList list = (ArrayList)DaoFactory.getArticleDAO().getArticleList_Limit(categoryId, i, pagesizes);
                int j = 0;
                StringBuffer goPage = new StringBuffer(512);
                goPage.append("&nbsp;&nbsp;GO&gt;&gt;<select size=1 onChange=\"javascript:window.location.href='index_'+(this.selectedIndex+1)+'.htm'\" name=\"this\">\n");
                for (int go_n = 1; go_n <= pagenum; ++go_n) {
                    if (go_n == i) {
                        goPage.append("<option value=\"" + go_n + "\" selected=\"selected\">" + go_n + "</option>\n");
                        continue;
                    }
                    goPage.append("<option value=\"" + go_n + "\">" + go_n + "</option>\n");
                }
                goPage.append("</select>&nbsp;&nbsp;");
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    ++j;
                    String tlinkurl = "";
                    DataField df = (DataField)iter.next();
                    StringTokenizer st = new StringTokenizer(df.getFieldValue("ModiTime"), " ");
                    tlinkurl = Integer.parseInt(df.getFieldValue("IsOutLink")) == 0 ? url + contextPath + df.getFieldValue("SavePath") : df.getFieldValue("OutLinkUrl");
                    newsliststr.append("<dt>");
                    newsliststr.append("<span class=\"col_right\">");
                    newsliststr.append(st.nextToken());
                    newsliststr.append("</span>");
                    newsliststr.append("\u00b7<a href=\"");
                    newsliststr.append(tlinkurl);
                    newsliststr.append("\" target=\"_blank\">");
                    newsliststr.append(df.getFieldValue("Title"));
                    newsliststr.append("</a>");
                    newsliststr.append("</dt>\n");
                    newsliststr.append("<dd>");
                    newsliststr.append(df.getFieldValue("Summary"));
                    newsliststr.append("</dd>\n");
                    if (j % 5 != 0) continue;
                    newsliststr.append("<div class=\"split\"></div>\n");
                }
                String Temptemplatecontent = templateContent;
                Temptemplatecontent = StringUtils.replaceString(Temptemplatecontent, "$ArticleList$", newsliststr.toString());
                Temptemplatecontent = i == maxPageNum ? StringUtils.replaceString(Temptemplatecontent, "$ShowPage$", "[<a href=\"index_" + (i - 1) + ".htm\">&lt;&lt;</a>]&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"" + contextPath + "/list_more.jsp?CatalogId=" + categoryId + "\">MORE=></a>&nbsp;&nbsp;&nbsp;&nbsp;") : StringUtils.replaceString(Temptemplatecontent, "$ShowPage$", showpagestr + goPage.toString());
                Temptemplatecontent = LabelUtil.replaceAllLabel(Temptemplatecontent, categoryId);
                FileUtil.createFile(Temptemplatecontent, savePath + diagonal + "index_" + i + ".htm", "UTF-8");
                log.info((Object)("create file:" + savePath + diagonal + "index_" + i + ".htm" + " success "));
                try {
                    DistributeUtil.send(distributepath + "/" + "index_" + i + ".htm", Temptemplatecontent);
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        } else {
            String Temptemplatecontent = templateContent;
            Temptemplatecontent = StringUtils.replaceString(Temptemplatecontent, "$ArticleList$", "");
            Temptemplatecontent = StringUtils.replaceString(Temptemplatecontent, "$ShowPage$", "");
            Temptemplatecontent = LabelUtil.replaceAllLabel(Temptemplatecontent, categoryId);
            FileUtil.createFile(Temptemplatecontent, savePath + diagonal + "index_1.htm", "UTF-8");
            log.info((Object)("create file:" + savePath + diagonal + "index_1.htm" + "success "));
            try {
                DistributeUtil.send(distributepath + "/" + "index_1.htm", Temptemplatecontent);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public void createCategoryImgListDesc(Locale locale, int categoryId, int imgw, int imgh, int pagesizes, String savePath, String template, String distributepath) {
        int totalnum = 0;
        int pagenum = 0;
        int maxPageNum = Sysconfig.getPageSendMaxNum();
        totalnum = DaoFactory.getArticleDAO().getCheckedTotalCount(categoryId);
        String templateContent = "";
        String contextPath = Sysconfig.getContextPath();
        String url = Sysconfig.getSiteUrl();
        try {
            FileUtil.createDir(savePath, true);
        }
        catch (IOException e) {
            log.error((Object)("Can't create Dir:" + savePath));
        }
        try {
            templateContent = FileUtil.readFile(template, "UTF-8");
        }
        catch (Exception e) {
            log.error((Object)("Can't find template file:" + template));
        }
        String diagonal = FileUtil.getSeparator();
        if (totalnum != 0) {
            pagenum = (totalnum + pagesizes - 1) / pagesizes;
            if (pagenum < 1) {
                pagenum = 1;
            }
            if (pagenum > maxPageNum) {
                pagenum = maxPageNum;
            }
            for (int i = 1; i <= pagenum; ++i) {
                StringBuffer newsliststr = new StringBuffer(512);
                String showpagestr = "";
                showpagestr = this.showPage(locale, i, totalnum, pagenum);
                ArrayList list = (ArrayList)DaoFactory.getArticleDAO().getArticleList_Limit(categoryId, i, pagesizes);
                int j = 0;
                StringBuffer goPage = new StringBuffer(512);
                goPage.append("&nbsp;&nbsp;GO&gt;&gt;<select size=1 onChange=\"javascript:window.location.href='index_'+(this.selectedIndex+1)+'.htm'\" name=\"this\">\n");
                for (int go_n = 1; go_n <= pagenum; ++go_n) {
                    if (go_n == i) {
                        goPage.append("<option value=\"" + go_n + "\" selected=\"selected\">" + go_n + "</option>\n");
                        continue;
                    }
                    goPage.append("<option value=\"" + go_n + "\">" + go_n + "</option>\n");
                }
                goPage.append("</select>&nbsp;&nbsp;");
                newsliststr.append("<div class=\"picTextWithDesc\">");
                newsliststr.append("<ul>");
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    ++j;
                    String tlinkurl = "";
                    DataField df = (DataField)iter.next();
                    StringTokenizer st = new StringTokenizer(df.getFieldValue("ModiTime"), " ");
                    tlinkurl = Integer.parseInt(df.getFieldValue("IsOutLink")) == 0 ? url + contextPath + df.getFieldValue("SavePath") : df.getFieldValue("OutLinkUrl");
                    String viewimg = df.getFieldValue("Photo");
                    if (viewimg == null || viewimg.length() < 4) {
                        viewimg = "/images/nopic.jpg";
                    }
                    newsliststr.append("<li>");
                    newsliststr.append("<span>");
                    newsliststr.append("<h6>");
                    newsliststr.append("<a href=\"");
                    newsliststr.append(tlinkurl);
                    newsliststr.append("\" target=\"_blank\">");
                    newsliststr.append(df.getFieldValue("Title"));
                    newsliststr.append("</a></h6>");
                    newsliststr.append("<a href=\"");
                    newsliststr.append(tlinkurl);
                    newsliststr.append("\" target=\"_blank\">");
                    newsliststr.append(df.getFieldValue("Summary"));
                    newsliststr.append("</a>");
                    newsliststr.append("</span>");
                    newsliststr.append("<a href=\"");
                    newsliststr.append(tlinkurl);
                    newsliststr.append("\" target=\"_blank\">");
                    newsliststr.append("<img src=\"");
                    newsliststr.append(viewimg);
                    newsliststr.append("\" border=\"0\"");
                    newsliststr.append(" width=\"" + imgw + "\"");
                    newsliststr.append(" height=\"" + imgh + "\"");
                    newsliststr.append(" alt=\"" + df.getFieldValue("Title") + "\"");
                    newsliststr.append(" /></a>");
                    newsliststr.append("</li>\n");
                    if (j % 5 != 0) continue;
                    newsliststr.append("<div class=\"split\"></div>\n");
                }
                newsliststr.append("</ul>");
                newsliststr.append("</div>");
                String Temptemplatecontent = templateContent;
                Temptemplatecontent = StringUtils.replaceString(Temptemplatecontent, "$ArticleList$", newsliststr.toString());
                Temptemplatecontent = i == maxPageNum ? StringUtils.replaceString(Temptemplatecontent, "$ShowPage$", "[<a href=\"index_" + (i - 1) + ".htm\">&lt;&lt;</a>]&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"" + contextPath + "/list_more.jsp?CatalogId=" + categoryId + "\">MORE=></a>&nbsp;&nbsp;&nbsp;&nbsp;") : StringUtils.replaceString(Temptemplatecontent, "$ShowPage$", showpagestr + goPage.toString());
                Temptemplatecontent = LabelUtil.replaceAllLabel(Temptemplatecontent, categoryId);
                FileUtil.createFile(Temptemplatecontent, savePath + diagonal + "index_" + i + ".htm", "UTF-8");
                log.info((Object)("create file:" + savePath + diagonal + "index_" + i + ".htm" + " success "));
                try {
                    DistributeUtil.send(distributepath + "/" + "index_" + i + ".htm", Temptemplatecontent);
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        } else {
            String Temptemplatecontent = templateContent;
            Temptemplatecontent = StringUtils.replaceString(Temptemplatecontent, "$ArticleList$", "");
            Temptemplatecontent = StringUtils.replaceString(Temptemplatecontent, "$ShowPage$", "");
            Temptemplatecontent = LabelUtil.replaceAllLabel(Temptemplatecontent, categoryId);
            FileUtil.createFile(Temptemplatecontent, savePath + diagonal + "index_1.htm", "UTF-8");
            log.info((Object)("create file:" + savePath + diagonal + "index_1.htm" + "success "));
            try {
                DistributeUtil.send(distributepath + "/" + "index_1.htm", Temptemplatecontent);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public void createCategoryMultiList(Locale locale, int categoryId, int rows, int cols, String savePath, String template, String distributepath) {
        int totalnum = 0;
        int pagenum = 0;
        int pagesizes = rows * cols;
        int maxPageNum = Sysconfig.getPageSendMaxNum();
        totalnum = DaoFactory.getArticleDAO().getCheckedTotalCount(categoryId);
        String templateContent = "";
        String contextPath = Sysconfig.getContextPath();
        String url = Sysconfig.getSiteUrl();
        try {
            FileUtil.createDir(savePath, true);
        }
        catch (IOException e) {
            log.error((Object)("Can't create Dir:" + savePath));
        }
        try {
            templateContent = FileUtil.readFile(template, "UTF-8");
        }
        catch (Exception e) {
            log.error((Object)("Can't find template file:" + template));
        }
        String diagonal = FileUtil.getSeparator();
        if (totalnum != 0) {
            pagenum = (totalnum + pagesizes - 1) / pagesizes;
            if (pagenum < 1) {
                pagenum = 1;
            }
            if (pagenum > maxPageNum) {
                pagenum = maxPageNum;
            }
            for (int i = 1; i <= pagenum; ++i) {
                StringBuffer newsliststr = new StringBuffer(512);
                String showpagestr = "";
                showpagestr = this.showPage(locale, i, totalnum, pagenum);
                ArrayList list = (ArrayList)DaoFactory.getArticleDAO().getArticleList_Limit(categoryId, i, pagesizes);
                boolean j = false;
                StringBuffer goPage = new StringBuffer(512);
                goPage.append("&nbsp;&nbsp;GO&gt;&gt;<select size=1 onChange=\"javascript:window.location.href='index_'+(this.selectedIndex+1)+'.htm'\" name=\"this\">\n");
                for (int go_n = 1; go_n <= pagenum; ++go_n) {
                    if (go_n == i) {
                        goPage.append("<option value=\"" + go_n + "\" selected=\"selected\">" + go_n + "</option>\n");
                        continue;
                    }
                    goPage.append("<option value=\"" + go_n + "\">" + go_n + "</option>\n");
                }
                goPage.append("</select>&nbsp;&nbsp;");
                Iterator iter = list.iterator();
                for (int rowsi = 0; rowsi < rows && iter.hasNext(); ++rowsi) {
                    newsliststr.append("<div class=\"rows_list\">\n");
                    for (int colsi = 0; colsi < cols && iter.hasNext(); ++colsi) {
                        DataField df = (DataField)iter.next();
                        String tlinkurl = "";
                        tlinkurl = Integer.parseInt(df.getFieldValue("IsOutLink")) == 0 ? url + contextPath + df.getFieldValue("SavePath") : df.getFieldValue("OutLinkUrl");
                        newsliststr.append("<div class=\"div_cols\">\n");
                        newsliststr.append("<a href=\"" + tlinkurl + "\" target=\"_blank\">" + df.getFieldValue("Title") + "</a>");
                        newsliststr.append("</div>\n");
                    }
                    newsliststr.append("</div>\n");
                }
                String Temptemplatecontent = templateContent;
                Temptemplatecontent = StringUtils.replaceString(Temptemplatecontent, "$ArticleList$", newsliststr.toString());
                Temptemplatecontent = i == maxPageNum ? StringUtils.replaceString(Temptemplatecontent, "$ShowPage$", "[<a href=\"index_" + (i - 1) + ".htm\">&lt;&lt;</a>]&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"" + contextPath + "/list_more.jsp?CatalogId=" + categoryId + "\">MORE=></a>&nbsp;&nbsp;&nbsp;&nbsp;") : StringUtils.replaceString(Temptemplatecontent, "$ShowPage$", showpagestr + goPage.toString());
                Temptemplatecontent = LabelUtil.replaceAllLabel(Temptemplatecontent, categoryId);
                FileUtil.createFile(Temptemplatecontent, savePath + diagonal + "index_" + i + ".htm", "UTF-8");
                log.info((Object)("create file:" + savePath + diagonal + "index_" + i + ".htm" + " success "));
                try {
                    DistributeUtil.send(distributepath + "/" + "index_" + i + ".htm", Temptemplatecontent);
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        } else {
            String Temptemplatecontent = templateContent;
            Temptemplatecontent = StringUtils.replaceString(Temptemplatecontent, "$ArticleList$", "");
            Temptemplatecontent = StringUtils.replaceString(Temptemplatecontent, "$ShowPage$", "");
            Temptemplatecontent = LabelUtil.replaceAllLabel(Temptemplatecontent, categoryId);
            FileUtil.createFile(Temptemplatecontent, savePath + diagonal + "index_1.htm", "UTF-8");
            log.info((Object)("create file:" + savePath + diagonal + "index_1.htm" + " success "));
            try {
                DistributeUtil.send(distributepath + "/" + "index_1.htm", Temptemplatecontent);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public void createCategoryPicList(Locale locale, int categoryId, int rows, int cols, int imgw, int imgh, String savePath, String template, String distributepath) {
        int totalnum = 0;
        int pagenum = 0;
        int pagesizes = rows * cols;
        int maxPageNum = Sysconfig.getPageSendMaxNum();
        totalnum = DaoFactory.getArticleDAO().getCheckedTotalCount(categoryId);
        String templateContent = "";
        String contextPath = Sysconfig.getContextPath();
        String url = Sysconfig.getSiteUrl();
        try {
            FileUtil.createDir(savePath, true);
        }
        catch (IOException e) {
            log.error((Object)("Can't create Dir:" + savePath));
        }
        try {
            templateContent = FileUtil.readFile(template, "UTF-8");
        }
        catch (Exception e) {
            log.error((Object)("Can't find template file:" + template));
        }
        String diagonal = FileUtil.getSeparator();
        if (totalnum != 0) {
            pagenum = (totalnum + pagesizes - 1) / pagesizes;
            if (pagenum < 1) {
                pagenum = 1;
            }
            if (pagenum > maxPageNum) {
                pagenum = maxPageNum;
            }
            for (int i = 1; i <= pagenum; ++i) {
                StringBuffer newsliststr = new StringBuffer(512);
                String showpagestr = "";
                showpagestr = this.showPage(locale, i, totalnum, pagenum);
                ArrayList list = (ArrayList)DaoFactory.getArticleDAO().getArticleList_Limit(categoryId, i, pagesizes);
                boolean j = false;
                StringBuffer goPage = new StringBuffer(512);
                goPage.append("&nbsp;&nbsp;GO&gt;&gt;<select size=1 onChange=\"javascript:window.location.href='index_'+(this.selectedIndex+1)+'.htm'\" name=\"this\">\n");
                for (int go_n = 1; go_n <= pagenum; ++go_n) {
                    if (go_n == i) {
                        goPage.append("<option value=\"" + go_n + "\" selected=\"selected\">" + go_n + "</option>\n");
                        continue;
                    }
                    goPage.append("<option value=\"" + go_n + "\">" + go_n + "</option>\n");
                }
                goPage.append("</select>&nbsp;&nbsp;");
                newsliststr.append("<div class=\"photo_list\"><ul>\n");
                Iterator iter = list.iterator();
                for (int rowsi = 0; rowsi < rows && iter.hasNext(); ++rowsi) {
                    for (int colsi = 0; colsi < cols && iter.hasNext(); ++colsi) {
                        DataField df = (DataField)iter.next();
                        String tlinkurl = "";
                        tlinkurl = Integer.parseInt(df.getFieldValue("IsOutLink")) == 0 ? url + contextPath + df.getFieldValue("SavePath") : df.getFieldValue("OutLinkUrl");
                        String viewimg = df.getFieldValue("Photo");
                        if (viewimg == null || viewimg.length() < 4) {
                            viewimg = "/images/nopic.jpg";
                        }
                        newsliststr.append("<li>\n");
                        newsliststr.append("<a href=\"" + tlinkurl + "\" target=\"_blank\"><img width=\"" + imgw + "\" height=\"" + imgh + "\" src=\"" + viewimg + "\" alt=\"" + df.getFieldValue("Title") + "\" align=\"absmiddle\" border=\"0\" /></a>\n");
                        newsliststr.append("<h6>");
                        newsliststr.append("<a href=\"" + tlinkurl + "\" title=\"" + df.getFieldValue("Title") + "\" target=\"_blank\">" + StringUtils.getTopic(df.getFieldValue("Title"), imgw / 12) + "</a>");
                        newsliststr.append("</h6>\n");
                        newsliststr.append("</li>\n");
                    }
                }
                newsliststr.append("</ul></div>\n");
                String Temptemplatecontent = templateContent;
                Temptemplatecontent = StringUtils.replaceString(Temptemplatecontent, "$ArticleList$", newsliststr.toString());
                Temptemplatecontent = i == maxPageNum ? StringUtils.replaceString(Temptemplatecontent, "$ShowPage$", "[<a href=\"index_" + (i - 1) + ".htm\">&lt;&lt;</a>]&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"" + contextPath + "/list_more.jsp?CatalogId=" + categoryId + "\">MORE=></a>&nbsp;&nbsp;&nbsp;&nbsp;") : StringUtils.replaceString(Temptemplatecontent, "$ShowPage$", showpagestr + goPage.toString());
                Temptemplatecontent = LabelUtil.replaceAllLabel(Temptemplatecontent, categoryId);
                FileUtil.createFile(Temptemplatecontent, savePath + diagonal + "index_" + i + ".htm", "UTF-8");
                log.info((Object)("create file:" + savePath + diagonal + "index_" + i + ".htm" + " success "));
                try {
                    DistributeUtil.send(distributepath + "/" + "index_" + i + ".htm", Temptemplatecontent);
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        } else {
            String Temptemplatecontent = templateContent;
            Temptemplatecontent = StringUtils.replaceString(Temptemplatecontent, "$ArticleList$", "");
            Temptemplatecontent = StringUtils.replaceString(Temptemplatecontent, "$ShowPage$", "");
            Temptemplatecontent = LabelUtil.replaceAllLabel(Temptemplatecontent, categoryId);
            FileUtil.createFile(Temptemplatecontent, savePath + diagonal + "index_1.htm", "UTF-8");
            log.info((Object)("create file:" + savePath + diagonal + "index_1.htm" + " success "));
            try {
                DistributeUtil.send(distributepath + "/" + "index_1.htm", Temptemplatecontent);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public String showPage(Locale locale, int currentpage, int totalnum, int pagenum) {
        int prepage = 0;
        int nextpage = 0;
        String returnStr = "";
        prepage = currentpage - 1;
        nextpage = currentpage + 1;
        returnStr = currentpage > 1 ? returnStr + "[" + "<a href='index_" + prepage + ".htm'>" + ResourceBundleUtil.getString(locale, "totcms.common.previous") + "</a>]&nbsp;&nbsp;&nbsp;" : returnStr + "[" + ResourceBundleUtil.getString(locale, "totcms.common.previous") + "]&nbsp;&nbsp;&nbsp;";
        returnStr = currentpage >= pagenum ? returnStr + "[" + ResourceBundleUtil.getString(locale, "totcms.common.next") + "]" : returnStr + "[" + "<a href='index_" + nextpage + ".htm'>" + ResourceBundleUtil.getString(locale, "totcms.common.next") + "</a>]&nbsp;&nbsp;&nbsp;";
        returnStr = returnStr + "&nbsp;" + ResourceBundleUtil.getString(locale, "totcms.common.total") + ":" + totalnum;
        returnStr = returnStr + "&nbsp;" + currentpage + "/";
        returnStr = returnStr + "" + pagenum;
        return returnStr;
    }
}

