/*
 * Decompiled with CFR 0.152.
 */
package tot.send;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.bean.DataField;
import tot.dao.DaoFactory;
import tot.global.Sysconfig;
import tot.send.SendCategory;
import tot.util.FileUtil;
import tot.util.LabelUtil;
import tot.util.ResourceBundleUtil;
import tot.util.StringUtils;

public class SendSpecial {
    private static Log log = LogFactory.getLog(SendCategory.class);

    public void createSpecialList(Locale locale, int specialId, int pagesizes, String savePath, String template, String distributePath) {
        int totalnum = 0;
        int pagenum = 0;
        int maxPageNum = Sysconfig.getPageSendMaxNum();
        totalnum = DaoFactory.getArticleDAO().getTotalCount_Special(specialId);
        String templateContent = "";
        String contextPath = Sysconfig.getContextPath();
        String url = Sysconfig.getSiteUrl();
        try {
            FileUtil.createDir(savePath, true);
        }
        catch (IOException e) {
            log.error((Object)("Can't create Dir:" + savePath));
        }
        try {
            templateContent = FileUtil.readFile(template, "UTF-8");
        }
        catch (Exception e) {
            log.error((Object)("Can't find template file:" + template));
        }
        String diagonal = FileUtil.getSeparator();
        if (totalnum != 0) {
            pagenum = (totalnum + pagesizes - 1) / pagesizes;
            if (pagenum < 1) {
                pagenum = 1;
            }
            if (pagenum > maxPageNum) {
                pagenum = maxPageNum;
            }
            for (int i = 1; i <= pagenum; ++i) {
                StringBuffer newsliststr = new StringBuffer(512);
                String showpagestr = "";
                showpagestr = this.showPage(locale, i, totalnum, pagenum);
                ArrayList list = (ArrayList)DaoFactory.getArticleDAO().getArticleSpecialList_Limit(specialId, i, pagesizes);
                newsliststr.append("<table>\n");
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    String tlinkurl = "";
                    DataField df = (DataField)iter.next();
                    tlinkurl = Integer.parseInt(df.getFieldValue("IsOutLink")) == 0 ? url + contextPath + df.getFieldValue("SavePath") : df.getFieldValue("OutLinkUrl");
                    newsliststr.append("<tr><td>");
                    newsliststr.append("\u00b7<a href=\"");
                    newsliststr.append(tlinkurl);
                    newsliststr.append("\" target=\"_blank\">");
                    newsliststr.append(df.getFieldValue("Title"));
                    newsliststr.append("</a>");
                    newsliststr.append("</td></tr>");
                }
                newsliststr.append("</table>");
                String Temptemplatecontent = templateContent;
                Temptemplatecontent = StringUtils.replaceString(Temptemplatecontent, "$ArticleList$", newsliststr.toString());
                Temptemplatecontent = i == maxPageNum ? StringUtils.replaceString(Temptemplatecontent, "$ShowPage$", "[<a href=\"index_" + (i - 1) + ".htm\">&lt;&lt;</a>]&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"/special/more.jsp?id=" + specialId + "\">MORE=></a>&nbsp;&nbsp;&nbsp;&nbsp;") : StringUtils.replaceString(Temptemplatecontent, "$ShowPage$", showpagestr);
                Temptemplatecontent = LabelUtil.replaceAllLabel(Temptemplatecontent, specialId);
                FileUtil.createFile(Temptemplatecontent, savePath + diagonal + "index_" + i + ".htm", "UTF-8");
                log.info((Object)("create file:" + savePath + diagonal + "index_" + i + ".htm" + " success "));
            }
        } else {
            String Temptemplatecontent = templateContent;
            Temptemplatecontent = StringUtils.replaceString(Temptemplatecontent, "$ArticleList$", "");
            Temptemplatecontent = StringUtils.replaceString(Temptemplatecontent, "$ShowPage$", "");
            Temptemplatecontent = LabelUtil.replaceAllLabel(Temptemplatecontent, specialId);
            FileUtil.createFile(Temptemplatecontent, savePath + diagonal + "index_1.htm", "UTF-8");
            log.info((Object)("create file:" + savePath + diagonal + "index_1.htm" + " success "));
        }
    }

    public String showPage(Locale locale, int currentpage, int totalnum, int pagenum) {
        int prepage = 0;
        int nextpage = 0;
        String returnStr = "";
        prepage = currentpage - 1;
        nextpage = currentpage + 1;
        returnStr = currentpage > 1 ? returnStr + "[" + "<a href='index_" + prepage + ".htm'>" + ResourceBundleUtil.getString(locale, "totcms.common.previous") + "</a>]&nbsp;&nbsp;&nbsp;" : returnStr + "[" + ResourceBundleUtil.getString(locale, "totcms.common.previous") + "]&nbsp;&nbsp;&nbsp;";
        returnStr = currentpage >= pagenum ? returnStr + "[" + ResourceBundleUtil.getString(locale, "totcms.common.next") + "]" : returnStr + "[" + "<a href='index_" + nextpage + ".htm'>" + ResourceBundleUtil.getString(locale, "totcms.common.next") + "</a>]&nbsp;&nbsp;&nbsp;";
        returnStr = returnStr + "&nbsp;" + ResourceBundleUtil.getString(locale, "totcms.common.total") + ":" + totalnum;
        returnStr = returnStr + "&nbsp;" + pagenum + "/";
        returnStr = returnStr + "&nbsp;" + currentpage;
        return returnStr;
    }
}

