/*
 * Decompiled with CFR 0.152.
 */
package tot.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Timestamp;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import tot.bean.DataField;
import tot.dao.DaoFactory;
import tot.dao.jdbc.AdminDaoImplJDBC;
import tot.global.Sysconfig;
import tot.util.DateUtil;
import tot.util.DistributeUtil;
import tot.util.FileUtil;
import tot.util.LabelUtil;
import tot.util.RequestUtil;
import tot.util.StringUtils;

public class ArticleReset
extends HttpServlet {
    ServletContext sc;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.sc = config.getServletContext();
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        request.setCharacterEncoding("utf-8");
        PrintWriter out = response.getWriter();
        HttpSession session = request.getSession();
        String admin = null;
        String haspriv = null;
        int id = RequestUtil.getInt(request, "id");
        DataField df = DaoFactory.getArticleDAO().getArticle(id);
        if (session.getAttribute("admin") != null) {
            admin = (String)session.getAttribute("admin");
        }
        if (session.getAttribute("role") != null) {
            haspriv = (String)session.getAttribute("role");
        }
        if (admin == null || haspriv == null) {
            response.sendRedirect("login.jsp");
        }
        if (DateUtil.isExpire()) {
            throw new ServletException("System get error");
        }
        if (df != null) {
            String RelateKey;
            int CategoryId = Integer.parseInt(df.getFieldValue("CategoryId"));
            int ParentId = DaoFactory.getCategoryDAO().getParentId(CategoryId);
            DaoFactory.getAdminDAO();
            if (!AdminDaoImplJDBC.ifHasPrivilege(haspriv, "p03" + CategoryId)) {
                throw new ServletException("you don't have privilege");
            }
            String currentPath = this.sc.getRealPath("/");
            String SavePath = df.getFieldValue("SavePath");
            String[] tempArr = SavePath.split("/");
            String fileName = tempArr[tempArr.length - 1];
            String todayStr = tempArr[tempArr.length - 2];
            String rand = fileName.substring(0, fileName.indexOf("."));
            String separator = FileUtil.getSeparator();
            String todayFolder = currentPath + "html" + separator + todayStr + separator;
            FileUtil.createDir(todayFolder, true);
            String fileExt = Sysconfig.getFileExt();
            String fileSavePath = todayFolder + fileName;
            String Title = df.getFieldValue("Title");
            String SubHeading = df.getFieldValue("SubHeading");
            String TitleColor = df.getFieldValue("TitleColor");
            String KeyWords = df.getFieldValue("KeyWords");
            if (KeyWords == null) {
                KeyWords = "";
            }
            if ((RelateKey = df.getFieldValue("RelateKey")) == null) {
                RelateKey = "";
            }
            int RelateNum = Integer.parseInt(df.getFieldValue("RelateNum"));
            String Content = df.getFieldValue("Content");
            String Summary = df.getFieldValue("Summary");
            int IsOutLink = Integer.parseInt(df.getFieldValue("IsOutLink"));
            String OutLinkUrl = df.getFieldValue("OutLinkUrl");
            int TemplateId = Integer.parseInt(df.getFieldValue("TemplateId"));
            int SpecialId = Integer.parseInt(df.getFieldValue("SpecialId"));
            int Top1 = Integer.parseInt(df.getFieldValue("Top1"));
            int ToTop = Integer.parseInt(df.getFieldValue("ToTop"));
            int ToHot = Integer.parseInt(df.getFieldValue("ToHot"));
            int Recommend = Integer.parseInt(df.getFieldValue("Recommend"));
            int Images = Integer.parseInt(df.getFieldValue("Images"));
            int Checked = Integer.parseInt(df.getFieldValue("Checked"));
            String Author = df.getFieldValue("Author");
            String SourceFrom = df.getFieldValue("SourceFrom");
            String Editor = df.getFieldValue("Editor");
            String UserName = (String)session.getAttribute("admin");
            String Photo = df.getFieldValue("Photo");
            int Hits2 = Integer.parseInt(df.getFieldValue("Hits"));
            String ModDate = df.getFieldValue("ModDate");
            Timestamp addtime = DateUtil.getCurrentGMTTimestamp();
            int lastid = id;
            String template = DaoFactory.getTemplateDAO().getContent(TemplateId);
            if (template == null) {
                throw new ServletException("template is null(id:" + TemplateId + ")");
            }
            String RelateLink = DaoFactory.getArticleDAO().getRelate(RelateKey, RelateNum, true);
            template = StringUtils.replaceString(template, "$Title$", Title);
            template = StringUtils.replaceString(template, "$SubHeading$", SubHeading);
            template = StringUtils.replaceString(template, "$Summary$", Summary);
            template = StringUtils.replaceString(template, "$KeyWords$", KeyWords);
            template = StringUtils.replaceString(template, "$id$", lastid + "");
            template = StringUtils.replaceString(template, "$Author$", Author);
            template = StringUtils.replaceString(template, "$Editor$", Editor);
            template = StringUtils.replaceString(template, "$SourceFrom$", SourceFrom);
            template = StringUtils.replaceString(template, "$ModiTime$", ModDate);
            template = StringUtils.replaceString(template, "$RelateLink$", RelateLink);
            template = LabelUtil.replaceAllLabel(template, CategoryId);
            String[] contentArr = Content.split("\\$PageSplit\\$");
            int pageNums = contentArr.length;
            for (int i = 0; i < pageNums; ++i) {
                String newstemp = template;
                StringBuffer PageSplitLists = new StringBuffer(512);
                for (int j = 0; j < pageNums; ++j) {
                    if (j == 0) {
                        PageSplitLists.append("<a href=\"" + rand + fileExt + "\">[" + (j + 1) + "]</a>\n");
                        continue;
                    }
                    PageSplitLists.append("<a href=\"" + rand + "_" + j + fileExt + "\"");
                    if (j == i) {
                        PageSplitLists.append(" class=\"currentpage\"");
                    }
                    PageSplitLists.append(">[" + (j + 1) + "]</a>\n");
                }
                String homelink = " <a href=\"" + rand + fileExt + "\">\u9996\u9875</a> ";
                String taillink = " <a href=\"" + rand + "_" + (pageNums - 1) + fileExt + "\">\u5c3e\u9875</a> ";
                try {
                    if (pageNums == 1) {
                        newstemp = StringUtils.replaceString(newstemp, "$Content$", Content);
                        newstemp = StringUtils.replaceString(newstemp, "$PageSplitList$", "");
                        FileUtil.createFile(newstemp, fileSavePath, "UTF-8");
                        out.print("<br>Create a file " + fileSavePath);
                        DistributeUtil.send(SavePath, newstemp);
                        continue;
                    }
                    int prePage = i - 1;
                    int nextPage = i + 1;
                    if (i == 0) {
                        newstemp = StringUtils.replaceString(newstemp, "$Content$", contentArr[i]);
                        newstemp = StringUtils.replaceString(newstemp, "$PageSplitList$", "<div class=\"PageSplits\">" + homelink + " \u4e0a\u4e00\u9875 " + PageSplitLists.toString() + " <a href=\"" + rand + "_" + nextPage + fileExt + "\">\u4e0b\u4e00\u9875</a> " + taillink + "</div>");
                    }
                    if (i == 1) {
                        if (pageNums == 2) {
                            newstemp = StringUtils.replaceString(newstemp, "$Content$", contentArr[i]);
                            newstemp = StringUtils.replaceString(newstemp, "$PageSplitList$", "<div class=\"PageSplits\">" + homelink + " <a href=\"" + rand + fileExt + "\">\u4e0a\u4e00\u9875</a> " + PageSplitLists.toString() + " \u4e0b\u4e00\u9875 " + taillink + "</div>");
                        } else {
                            newstemp = StringUtils.replaceString(newstemp, "$Content$", contentArr[i]);
                            newstemp = StringUtils.replaceString(newstemp, "$PageSplitList$", "<div class=\"PageSplits\">" + homelink + " <a href=\"" + rand + fileExt + "\">\u4e0a\u4e00\u9875</a> " + PageSplitLists.toString() + " <a href=\"" + rand + "_" + nextPage + fileExt + "\">\u4e0b\u4e00\u9875</a> " + taillink + "</div>");
                        }
                    }
                    if (i == pageNums - 1) {
                        newstemp = StringUtils.replaceString(newstemp, "$Content$", contentArr[i]);
                        newstemp = StringUtils.replaceString(newstemp, "$PageSplitList$", "<div class=\"PageSplits\">" + homelink + " <a href=\"" + rand + "_" + prePage + fileExt + "\">\u4e0a\u4e00\u9875</a> " + PageSplitLists.toString() + " \u4e0b\u4e00\u9875 " + taillink + "</div>");
                    } else {
                        newstemp = StringUtils.replaceString(newstemp, "$Content$", contentArr[i]);
                        newstemp = StringUtils.replaceString(newstemp, "$PageSplitList$", "<div class=\"PageSplits\">" + homelink + " <a href=\"" + rand + "_" + prePage + fileExt + "\">\u4e0a\u4e00\u9875</a> " + PageSplitLists.toString() + " <a href=\"" + rand + "_" + nextPage + fileExt + "\">\u4e0b\u4e00\u9875</a> " + taillink + "</div>");
                    }
                    if (i == 0) {
                        FileUtil.createFile(newstemp, todayFolder + rand + fileExt, "UTF-8");
                        out.print("<br>Create first file " + todayFolder + rand + fileExt);
                        DistributeUtil.send("/html/" + todayStr + "/" + rand + fileExt, newstemp);
                        continue;
                    }
                    FileUtil.createFile(newstemp, todayFolder + rand + "_" + i + fileExt, "UTF-8");
                    out.print("<br>Create files " + todayFolder + rand + "_" + i + fileExt);
                    DistributeUtil.send("/html/" + todayStr + "/" + rand + "_" + i + fileExt, newstemp);
                    continue;
                }
                catch (Exception e) {
                    System.out.print("file write error " + e.getMessage());
                }
            }
            out.println("<br>Send article by id:" + id + "<br>\n");
            out.close();
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }
}

