/*
 * Decompiled with CFR 0.152.
 */
package tot.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.bean.DataField;
import tot.dao.DaoFactory;
import tot.dao.jdbc.AdminDaoImplJDBC;
import tot.global.Sysconfig;
import tot.util.FileUtil;
import tot.util.LabelUtil;
import tot.util.RequestUtil;
import tot.util.ResourceBundleUtil;

public class SendCategory
extends HttpServlet {
    private static Log log = LogFactory.getLog(SendCategory.class);
    ServletContext sc;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.sc = config.getServletContext();
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        HttpSession session = request.getSession();
        String admin = null;
        String haspriv = null;
        int isChannel = 0;
        int parentId = 0;
        String savePath = "";
        String template = "";
        Locale locale = request.getLocale();
        int CategoryId = RequestUtil.getInt(request, "CategoryId");
        int NumPerPage = RequestUtil.getInt(request, "NumPerPage");
        if (session.getAttribute("admin") != null) {
            admin = (String)session.getAttribute("admin");
        }
        if (session.getAttribute("role") != null) {
            haspriv = (String)session.getAttribute("role");
        }
        if (admin == null || haspriv == null) {
            response.sendRedirect("login.jsp");
        }
        DaoFactory.getAdminDAO();
        if (!AdminDaoImplJDBC.ifHasPrivilege(haspriv, "p06")) {
            throw new ServletException("you don't have privilege");
        }
        if (CategoryId < 0 || NumPerPage < 0) {
            throw new ServletException("CategoryId and NumPerPage must not less than zero");
        }
        DataField df = DaoFactory.getCategoryDAO().getCategory(CategoryId);
        if (df != null) {
            isChannel = Integer.parseInt(df.getFieldValue("IsChannel"));
            parentId = Integer.parseInt(df.getFieldValue("ParentId"));
            savePath = df.getFieldValue("SavePath");
            template = df.getFieldValue("Template");
        }
        String currentPath = this.sc.getRealPath("/");
        savePath = currentPath + savePath;
        template = currentPath + template;
        FileUtil.createDir(savePath, true);
        if (isChannel == 0) {
            this.createCategoryList(locale, CategoryId, NumPerPage, savePath, template);
        }
        out.close();
    }

    public void createCategoryList(Locale locale, int categoryId, int pagesizes, String savePath, String template) {
        int totalnum = 0;
        int pagenum = 0;
        int maxPageNum = Sysconfig.getPageSendMaxNum();
        totalnum = DaoFactory.getArticleDAO().getTotalCount(categoryId);
        String templateContent = "";
        if (totalnum != 0) {
            pagenum = (totalnum + pagesizes - 1) / pagesizes;
            if (pagenum < 1) {
                pagenum = 1;
            }
            if (pagenum > maxPageNum) {
                pagenum = maxPageNum;
            }
            try {
                templateContent = FileUtil.readFile(template, "UTF-8");
            }
            catch (Exception e) {
                log.error((Object)("Can't find template file:" + template));
            }
            String diagonal = FileUtil.getSeparator();
            for (int i = 1; i <= pagenum; ++i) {
                StringBuffer newsliststr = new StringBuffer(512);
                String showpagestr = "";
                showpagestr = this.showPage(locale, i, totalnum, pagenum);
                ArrayList list = (ArrayList)DaoFactory.getArticleDAO().getArticleList_Limit(categoryId, i, pagesizes);
                newsliststr.append("<table>\n");
                for (DataField df : list) {
                    newsliststr.append("<tr><td>");
                    newsliststr.append(df.getFieldValue("Title"));
                    newsliststr.append("</td></tr>");
                }
                newsliststr.append("</table>");
                String Temptemplatecontent = templateContent;
                Temptemplatecontent = Temptemplatecontent.replaceAll("\\$ArticleList\\$", newsliststr.toString());
                Temptemplatecontent = i == maxPageNum ? Temptemplatecontent.replaceAll("\\$ShowPage\\$", "[<a href=\"index_" + (i - 1) + ".htm\">&lt;&lt;</a>]&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"" + Sysconfig.getContextPath() + "more.jsp?catalogid=" + categoryId + "\">MORE=></a>&nbsp;&nbsp;&nbsp;&nbsp;") : Temptemplatecontent.replaceAll("\\$ShowPage\\$", showpagestr);
                Temptemplatecontent = LabelUtil.replaceAllLabel(Temptemplatecontent, categoryId);
                FileUtil.createFile(Temptemplatecontent, savePath + diagonal + "index_" + i + ".htm", "UTF-8");
                log.info((Object)("create file:" + savePath + diagonal + "index_" + i + ".htm" + "success "));
            }
        }
    }

    public String showPage(Locale locale, int currentpage, int totalnum, int pagenum) {
        int prepage = 0;
        int nextpage = 0;
        String returnStr = "";
        prepage = currentpage - 1;
        nextpage = currentpage + 1;
        returnStr = currentpage > 1 ? returnStr + "[" + "<a href='index_" + prepage + ".htm'>" + ResourceBundleUtil.getString(locale, "totcms.common.previous") + "</a>]&nbsp;&nbsp;&nbsp;" : returnStr + "[" + ResourceBundleUtil.getString(locale, "totcms.common.previous") + "]&nbsp;&nbsp;&nbsp;";
        returnStr = currentpage >= pagenum ? returnStr + "[" + ResourceBundleUtil.getString(locale, "totcms.common.next") + "]" : returnStr + "[" + "<a href='index_" + nextpage + ".htm'>" + ResourceBundleUtil.getString(locale, "totcms.common.next") + "</a>]&nbsp;&nbsp;&nbsp;";
        returnStr = returnStr + "&nbsp;" + ResourceBundleUtil.getString(locale, "totcms.common.total") + ":" + totalnum;
        returnStr = returnStr + "&nbsp;" + pagenum + "/";
        returnStr = returnStr + "&nbsp;" + currentpage;
        return returnStr;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }
}

