/*
 * Decompiled with CFR 0.152.
 */
package tot.upload;

import javax.servlet.http.HttpServletRequest;
import tot.upload.OutputStreamListener;
import tot.upload.UploadInfo;

public class UploadListener
implements OutputStreamListener {
    private HttpServletRequest request;
    private long delay = 0L;
    private long startTime = 0L;
    private int totalToRead = 0;
    private int totalBytesRead = 0;
    private int totalFiles = -1;

    public UploadListener(HttpServletRequest request, long debugDelay) {
        this.request = request;
        this.delay = debugDelay;
        this.totalToRead = request.getContentLength();
        this.startTime = System.currentTimeMillis();
    }

    public void start() {
        ++this.totalFiles;
        this.updateUploadInfo("start");
    }

    public void bytesRead(int bytesRead) {
        this.totalBytesRead += bytesRead;
        this.updateUploadInfo("progress");
        try {
            Thread.sleep(this.delay);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void error(String message) {
        this.updateUploadInfo("error");
    }

    public void done() {
        this.updateUploadInfo("done");
    }

    private long getDelta() {
        return (System.currentTimeMillis() - this.startTime) / 1000L;
    }

    private void updateUploadInfo(String status) {
        long delta = (System.currentTimeMillis() - this.startTime) / 1000L;
        this.request.getSession().setAttribute("uploadInfo", (Object)new UploadInfo(this.totalFiles, this.totalToRead, this.totalBytesRead, delta, status));
    }
}

