/*
 * Decompiled with CFR 0.152.
 */
package tot.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.io.PrintWriter;
import javax.servlet.http.HttpSession;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.servlet.ServletUtilities;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.urls.PieURLGenerator;
import org.jfree.chart.urls.StandardPieURLGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public class ChartUtil {
    private DefaultPieDataset piedata = new DefaultPieDataset();
    private DefaultCategoryDataset bardata = new DefaultCategoryDataset();

    public void setPieValue(String key, double value) {
        this.piedata.setValue((Comparable)((Object)key), value);
    }

    public void setBarValue(double value, String row, String col) {
        this.bardata.addValue(value, (Comparable)((Object)row), (Comparable)((Object)col));
    }

    public String generatePieChart(String title, HttpSession session, PrintWriter pw, String url) {
        String filename = null;
        try {
            PiePlot plot = new PiePlot((PieDataset)this.piedata);
            plot.setToolTipGenerator((PieToolTipGenerator)new StandardPieToolTipGenerator());
            plot.setNoDataMessage("No data available");
            plot.setExplodePercent(1, 0.5);
            plot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator("{0} ({2})"));
            JFreeChart chart = new JFreeChart("", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
            chart.setBackgroundPaint((Paint)Color.white);
            Font font = new Font("\u9ed1\u4f53", 1, 20);
            TextTitle _title = new TextTitle(title);
            _title.setFont(font);
            chart.setTitle(_title);
            ChartRenderingInfo info = new ChartRenderingInfo((EntityCollection)new StandardEntityCollection());
            filename = ServletUtilities.saveChartAsPNG((JFreeChart)chart, (int)500, (int)300, (ChartRenderingInfo)info, (HttpSession)session);
            ChartUtilities.writeImageMap((PrintWriter)pw, (String)filename, (ChartRenderingInfo)info, (boolean)true);
            pw.flush();
        }
        catch (Exception e) {
            System.out.println("Exception - " + e.toString());
            e.printStackTrace(System.out);
            filename = "public_error_500x300.png";
        }
        return filename;
    }

    public String generate3dPieChart(String title, HttpSession session, PrintWriter pw, String url) {
        String filename = null;
        try {
            PiePlot plot = new PiePlot((PieDataset)this.piedata);
            plot.setURLGenerator((PieURLGenerator)new StandardPieURLGenerator(url, "category"));
            plot.setToolTipGenerator((PieToolTipGenerator)new StandardPieToolTipGenerator());
            JFreeChart chart = ChartFactory.createPieChart3D((String)"", (PieDataset)this.piedata, (boolean)true, (boolean)false, (boolean)false);
            PiePlot pie = (PiePlot)chart.getPlot();
            pie.setBackgroundPaint((Paint)Color.white);
            pie.setBackgroundAlpha(0.6f);
            pie.setForegroundAlpha(0.9f);
            chart.setBackgroundPaint((Paint)Color.white);
            Font font = new Font("\u9ed1\u4f53", 1, 20);
            TextTitle _title = new TextTitle(title);
            _title.setFont(font);
            chart.setTitle(_title);
            ChartRenderingInfo info = new ChartRenderingInfo((EntityCollection)new StandardEntityCollection());
            filename = ServletUtilities.saveChartAsPNG((JFreeChart)chart, (int)500, (int)300, (ChartRenderingInfo)info, (HttpSession)session);
            ChartUtilities.writeImageMap((PrintWriter)pw, (String)filename, (ChartRenderingInfo)info, (boolean)true);
            pw.flush();
        }
        catch (Exception e) {
            System.out.println("Exception - " + e.toString());
            e.printStackTrace(System.out);
            filename = "public_error_500x300.png";
        }
        return filename;
    }

    public String generateBarChart(String title, HttpSession session, PrintWriter pw, String url) {
        String filename = null;
        try {
            CategoryAxis categoryAxis = new CategoryAxis("");
            NumberAxis valueAxis = new NumberAxis("");
            BarRenderer renderer = new BarRenderer();
            renderer.setToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
            CategoryPlot plot = new CategoryPlot((CategoryDataset)this.bardata, categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
            JFreeChart chart = new JFreeChart("", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, false);
            chart.setBackgroundPaint((Paint)Color.white);
            Font font = new Font("\u9ed1\u4f53", 1, 20);
            TextTitle _title = new TextTitle(title);
            _title.setFont(font);
            chart.setTitle(_title);
            ChartRenderingInfo info = new ChartRenderingInfo((EntityCollection)new StandardEntityCollection());
            filename = ServletUtilities.saveChartAsPNG((JFreeChart)chart, (int)(this.bardata.getColumnCount() * 100), (int)300, (ChartRenderingInfo)info, (HttpSession)session);
            ChartUtilities.writeImageMap((PrintWriter)pw, (String)filename, (ChartRenderingInfo)info, (boolean)true);
            pw.flush();
        }
        catch (Exception e) {
            System.out.println("Exception - " + e.toString());
            e.printStackTrace(System.out);
            filename = "public_error_500x300.png";
        }
        return filename;
    }

    public String generate3dBarChart(String title, HttpSession session, PrintWriter pw, String url) {
        String filename = null;
        try {
            CategoryAxis categoryAxis = new CategoryAxis("");
            NumberAxis valueAxis = new NumberAxis("");
            BarRenderer renderer = new BarRenderer();
            JFreeChart jfreechart = ChartFactory.createBarChart3D((String)title, (String)"\u5206\u7c7b", (String)"\u6570\u503c", (CategoryDataset)this.bardata, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)true, (boolean)false);
            CategoryPlot categoryplot = jfreechart.getCategoryPlot();
            categoryplot.setForegroundAlpha(1.0f);
            ChartRenderingInfo info = new ChartRenderingInfo((EntityCollection)new StandardEntityCollection());
            filename = ServletUtilities.saveChartAsPNG((JFreeChart)jfreechart, (int)700, (int)300, (ChartRenderingInfo)info, (HttpSession)session);
            ChartUtilities.writeImageMap((PrintWriter)pw, (String)filename, (ChartRenderingInfo)info, (boolean)true);
            pw.flush();
        }
        catch (Exception e) {
            System.out.println("Exception - " + e.toString());
            e.printStackTrace(System.out);
            filename = "public_error_500x300.png";
        }
        return filename;
    }
}

