/*
 * Decompiled with CFR 0.152.
 */
package tot.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import tot.util.ControlledIP;

class ControlledAction {
    private int actionsPerHour = 0;
    private Map ipMap = new TreeMap();
    private long lastRemoveTime = 0L;

    ControlledAction() {
    }

    void setActionsPerHour(int actionsPerHour) {
        if (actionsPerHour >= 0) {
            this.actionsPerHour = actionsPerHour;
        }
    }

    int getActionsPerHour() {
        return this.actionsPerHour;
    }

    boolean reachMaximum(String strIP) {
        this.removeTimeoutControlledIP();
        return this.getControlledIP(strIP).reachMaximum();
    }

    void increaseCount(String strIP) {
        this.removeTimeoutControlledIP();
        this.getControlledIP(strIP).increaseCount();
    }

    void resetActionHistory(String strIP) {
        this.removeTimeoutControlledIP();
        this.getControlledIP(strIP).resetActionHistory();
    }

    private synchronized ControlledIP getControlledIP(String strIP) {
        ControlledIP controlledIP = (ControlledIP)this.ipMap.get(strIP);
        if (controlledIP == null) {
            controlledIP = new ControlledIP(this.actionsPerHour);
            this.ipMap.put(strIP, controlledIP);
        } else {
            controlledIP.setActionsPerHour(this.actionsPerHour);
        }
        return controlledIP;
    }

    private synchronized void removeTimeoutControlledIP() {
        long now = System.currentTimeMillis();
        if (now - this.lastRemoveTime > 2000L) {
            this.lastRemoveTime = now;
            Collection ipList = this.ipMap.values();
            Iterator iter = ipList.iterator();
            while (iter.hasNext()) {
                ControlledIP currentControlledIP = (ControlledIP)iter.next();
                if (now - currentControlledIP.getLastIncrementTime() <= 10000L) continue;
                iter.remove();
            }
        }
    }
}

