/*
 * Decompiled with CFR 0.152.
 */
package tot.util;

import java.io.IOException;
import java.util.StringTokenizer;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.SimpleEmail;
import tot.exception.BadInputException;
import tot.global.Sysconfig;

public class EmailUtil {
    private static Log log = LogFactory.getLog(EmailUtil.class);
    public static final int MAX_MESSAGES_PER_TRANSPORT = 100;

    public static String getEmailUsername(String email) {
        if (email == null) {
            return "";
        }
        int atIndex = email.indexOf(64);
        if (atIndex == -1) {
            return "";
        }
        return email.substring(0, atIndex);
    }

    public static String getEmailDomain(String email) {
        if (email == null) {
            return "";
        }
        int atIndex = email.indexOf(64);
        if (atIndex == -1) {
            return "";
        }
        return email.substring(atIndex + 1);
    }

    public static void checkGoodEmail(String input) throws BadInputException {
        if (input == null) {
            throw new BadInputException("Sorry, null string is not a good email.");
        }
        int atIndex = input.indexOf(64);
        int dotIndex = input.lastIndexOf(46);
        if (atIndex == -1 || dotIndex == -1 || atIndex >= dotIndex) {
            throw new BadInputException("Error: '" + input + "' is not a valid email value. Please try again.");
        }
        int length = input.length();
        char c = '\u0000';
        for (int i = 0; i < length; ++i) {
            c = input.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || (c == '_' || c == '-' || c == '.' || c == '@') && i != 0) continue;
            throw new BadInputException(input + " is not a valid email. Reason: character '" + c + "' is not accepted in an email.");
        }
        try {
            new InternetAddress(input);
        }
        catch (Exception ex) {
            log.error((Object)"Error when running checkGoodEmail", (Throwable)ex);
            throw new BadInputException("Assertion: dont want to occur in Util.checkGoodEmail");
        }
    }

    public static String[] getEmails(String email) throws BadInputException {
        if (email == null) {
            email = "";
        }
        email = email.trim();
        email = email.replace(',', ';');
        StringTokenizer t = new StringTokenizer(email, ";");
        String[] ret = new String[t.countTokens()];
        int index = 0;
        while (t.hasMoreTokens()) {
            String mail = t.nextToken().trim();
            EmailUtil.checkGoodEmail(mail);
            ret[index] = mail;
            ++index;
        }
        return ret;
    }

    private static InternetAddress[] getInternetAddressEmails(String email) throws BadInputException, AddressException {
        String[] mails = EmailUtil.getEmails(email);
        if (mails.length == 0) {
            return null;
        }
        InternetAddress[] address = new InternetAddress[mails.length];
        for (int i = 0; i < mails.length; ++i) {
            address[i] = new InternetAddress(mails[i]);
        }
        return address;
    }

    public static String send(String to, String cc, String bcc, String subject, String message) throws EmailException, IOException {
        String ret = "";
        SimpleEmail email = new SimpleEmail();
        email.setHostName(Sysconfig.getMailServer());
        email.setAuthentication(Sysconfig.getMailUserName(), Sysconfig.getMailPassword());
        email.setCharset("UTF-8");
        email.addTo(to, EmailUtil.getEmailUsername(to));
        if (cc != null && cc.indexOf(64) != -1 && cc.indexOf(46) != -1) {
            email.addCc(cc, EmailUtil.getEmailUsername(cc));
        }
        if (bcc != null && bcc.indexOf(64) != -1 && bcc.indexOf(46) != -1) {
            email.addBcc(bcc, EmailUtil.getEmailUsername(bcc));
        }
        email.setFrom(Sysconfig.getDefaultMailFrom(), Sysconfig.getSiteName());
        email.setSubject(subject);
        email.setMsg(message);
        ret = email.send();
        return ret;
    }

    public static String sendHtml(String to, String cc, String bcc, String subject, String message) throws EmailException, IOException {
        String ret = "";
        HtmlEmail email = new HtmlEmail();
        email.setHostName(Sysconfig.getMailServer());
        email.setAuthentication(Sysconfig.getMailUserName(), Sysconfig.getMailPassword());
        email.setCharset("UTF-8");
        email.addTo(to, EmailUtil.getEmailUsername(to));
        if (cc != null && cc.indexOf(64) != -1 && cc.indexOf(46) != -1) {
            email.addCc(cc, EmailUtil.getEmailUsername(cc));
        }
        if (bcc != null && bcc.indexOf(64) != -1 && bcc.indexOf(46) != -1) {
            email.addBcc(bcc, EmailUtil.getEmailUsername(bcc));
        }
        email.setFrom(Sysconfig.getDefaultMailFrom(), Sysconfig.getSiteName());
        email.setSubject(subject);
        email.setHtmlMsg(message);
        email.setTextMsg("Your email client does not support HTML messages");
        email.send();
        return ret;
    }
}

