/*
 * Decompiled with CFR 0.152.
 */
package tot.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.StringReader;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.bean.DataField;
import tot.exception.BadInputException;
import tot.filter.DisableHtmlTagFilter;
import tot.util.DateUtil;

public final class FileUtil {
    private static Log log = LogFactory.getLog(FileUtil.class);
    private static FileUtil instance = new FileUtil();
    private static String servletClassesPath = null;

    private FileUtil() {
    }

    public static String getSeparator() {
        return System.getProperty("file.separator");
    }

    public static String getDefaultEncoding() {
        String temp = System.getProperty("file.encoding");
        return temp;
    }

    public static Collection getList(String strPath) {
        ArrayList<DataField> returnList = new ArrayList<DataField>();
        DataField df = null;
        String isdirectory = "0";
        File files = new File(strPath);
        if (files.isDirectory()) {
            File[] listFile = files.listFiles();
            for (int i = 0; i < listFile.length; ++i) {
                df = new DataField();
                isdirectory = listFile[i].isDirectory() ? "1" : "0";
                Date mod = new Date(listFile[i].lastModified());
                df.setField("name", listFile[i].getName(), 0);
                df.setField("path", listFile[i].getPath(), 0);
                df.setField("size", listFile[i].length() + "", 0);
                df.setField("moditime", DateUtil.dateToStr(mod), 0);
                df.setField("isdirectory", isdirectory, 0);
                returnList.add(df);
            }
        }
        return returnList;
    }

    public static void checkGoodFilePath(String str) throws BadInputException {
        byte[] s = str.getBytes();
        int length = s.length;
        byte b = 0;
        for (int i = 0; i < length; ++i) {
            b = s[i];
            if (b != 42 && b != 63 && b != 60 && b != 62 && b != 34 && b != 124 && b != 0) continue;
            throw new BadInputException("The string '" + DisableHtmlTagFilter.filter(str) + "' is not a good file path. Reason: character '" + (char)b + "' is not allowed.");
        }
    }

    public static void checkGoodFileName(String str) throws BadInputException {
        FileUtil.checkGoodFilePath(str);
        byte[] s = str.getBytes();
        int length = s.length;
        byte b = 0;
        for (int i = 0; i < length; ++i) {
            b = s[i];
            if (b != 47 && b != 92 && b != 58) continue;
            throw new BadInputException("The string '" + DisableHtmlTagFilter.filter(str) + "' is not a good file name. Reason: character '" + (char)b + "' is not allowed.");
        }
    }

    public static void createDir(String dir, boolean ignoreIfExitst) throws IOException {
        File file = new File(dir);
        if (ignoreIfExitst && file.exists()) {
            return;
        }
        if (!file.mkdir()) {
            throw new IOException("Cannot create the directory = " + dir);
        }
    }

    public static void createDirs(String dir, boolean ignoreIfExitst) throws IOException {
        File file = new File(dir);
        if (ignoreIfExitst && file.exists()) {
            return;
        }
        if (!file.mkdirs()) {
            throw new IOException("Cannot create directories = " + dir);
        }
    }

    public static void deleteFile(String filename) throws IOException {
        File file = new File(filename);
        log.trace((Object)("Delete file = " + filename));
        if (file.isDirectory()) {
            throw new IOException("IOException -> BadInputException: not a file.");
        }
        if (!file.exists()) {
            throw new IOException("IOException -> BadInputException: file is not exist.");
        }
        if (!file.delete()) {
            throw new IOException("Cannot delete file. filename = " + filename);
        }
    }

    public static void deleteDir(File dir) throws IOException {
        if (dir.isFile()) {
            throw new IOException("IOException -> BadInputException: not a directory.");
        }
        File[] files = dir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (file.isFile()) {
                    file.delete();
                    continue;
                }
                FileUtil.deleteDir(file);
            }
        }
        dir.delete();
    }

    public static long getDirLength(File dir) throws IOException {
        if (dir.isFile()) {
            throw new IOException("BadInputException: not a directory.");
        }
        long size = 0L;
        File[] files = dir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                long length = 0L;
                length = file.isFile() ? file.length() : FileUtil.getDirLength(file);
                size += length;
            }
        }
        return size;
    }

    public static long getDirLength_onDisk(File dir) throws IOException {
        if (dir.isFile()) {
            throw new IOException("BadInputException: not a directory.");
        }
        long size = 0L;
        File[] files = dir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                long length = 0L;
                length = file.isFile() ? file.length() : FileUtil.getDirLength_onDisk(file);
                double mod = Math.ceil((double)length / 512.0);
                if (mod == 0.0) {
                    mod = 1.0;
                }
                length = (long)mod * 512L;
                size += length;
            }
        }
        return size;
    }

    public static void emptyFile(String srcFilename) throws IOException {
        File srcFile = new File(srcFilename);
        if (!srcFile.exists()) {
            throw new FileNotFoundException("Cannot find the file: " + srcFile.getAbsolutePath());
        }
        if (!srcFile.canWrite()) {
            throw new IOException("Cannot write the file: " + srcFile.getAbsolutePath());
        }
        FileOutputStream outputStream = new FileOutputStream(srcFilename);
        outputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String srcFilename, String destFilename, boolean overwrite) throws IOException {
        File srcFile = new File(srcFilename);
        if (!srcFile.exists()) {
            throw new FileNotFoundException("Cannot find the source file: " + srcFile.getAbsolutePath());
        }
        if (!srcFile.canRead()) {
            throw new IOException("Cannot read the source file: " + srcFile.getAbsolutePath());
        }
        File destFile = new File(destFilename);
        if (!overwrite) {
            if (destFile.exists()) {
                return;
            }
        } else if (destFile.exists() ? !destFile.canWrite() : !destFile.createNewFile()) {
            throw new IOException("Cannot write the destination file: " + destFile.getAbsolutePath());
        }
        BufferedInputStream inputStream = null;
        FilterOutputStream outputStream = null;
        byte[] block = new byte[1024];
        try {
            int readLength;
            inputStream = new BufferedInputStream(new FileInputStream(srcFile));
            outputStream = new BufferedOutputStream(new FileOutputStream(destFile));
            while ((readLength = inputStream.read(block)) != -1) {
                ((BufferedOutputStream)outputStream).write(block, 0, readLength);
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ex) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    public static byte[] getBytes(InputStream inputStream) throws IOException {
        int readLength;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        byte[] block = new byte[512];
        while ((readLength = bufferedInputStream.read(block)) != -1) {
            byteArrayOutputStream.write(block, 0, readLength);
        }
        byte[] retValue = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        return retValue;
    }

    public static String getFileName(String fullFilePath) {
        int index2;
        int index;
        if (fullFilePath == null) {
            return "";
        }
        int index1 = fullFilePath.lastIndexOf(47);
        int n = index = index1 > (index2 = fullFilePath.lastIndexOf(92)) ? index1 : index2;
        if (index == -1) {
            return fullFilePath;
        }
        String fileName = fullFilePath.substring(index + 1);
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void popFile(File srcFile, OutputStream output) throws IOException {
        BufferedInputStream input = null;
        byte[] block = new byte[1024];
        try {
            int length;
            input = new BufferedInputStream(new FileInputStream(srcFile), 1024);
            while ((length = input.read(block)) != -1) {
                output.write(block, 0, length);
            }
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    public static void setServletClassesPath(String path) {
        log.debug((Object)("FileUtil.setServletClassesPath called with path = " + path));
        servletClassesPath = path;
        if (servletClassesPath == null) {
            return;
        }
        if (!servletClassesPath.endsWith(File.separator)) {
            servletClassesPath = servletClassesPath + File.separatorChar;
            log.debug((Object)("FileUtil.setServletClassesPath change path to value = " + servletClassesPath));
        }
    }

    public static String getServletClassesPath() {
        if (servletClassesPath == null) {
            ClassLoader classLoader;
            URL url;
            String strPath = System.getProperty("totcms.context.path");
            servletClassesPath = strPath != null && strPath.length() > 0 ? strPath : ((url = (classLoader = instance.getClass().getClassLoader()).getResource("/")) == null ? "." : url.getPath());
            log.debug((Object)("servletClassesPath = " + servletClassesPath));
            if (!servletClassesPath.endsWith(File.separator)) {
                servletClassesPath = servletClassesPath + File.separatorChar;
            }
        }
        return servletClassesPath;
    }

    public static void createTextFile(InputStream inputStream, String textFile) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("Does not accept null input");
        }
        FileOutputStream outputStream = null;
        try {
            byte[] srcByte = FileUtil.getBytes(inputStream);
            outputStream = new FileOutputStream(textFile);
            ((OutputStream)outputStream).write(srcByte);
            return;
        }
        catch (IOException e) {
            log.error((Object)"Error", (Throwable)e);
            throw e;
        }
        finally {
            inputStream.close();
            if (outputStream != null) {
                ((OutputStream)outputStream).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(String content, String fileName, String destEncoding) throws FileNotFoundException, IOException {
        File file = null;
        file = new File(fileName);
        if (!file.isFile()) {
            throw new IOException("'" + fileName + "' is not a file.");
        }
        if (!file.canWrite()) {
            throw new IOException("'" + fileName + "' is a read-only file.");
        }
        BufferedWriter out = null;
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, destEncoding));
            out.write(content);
            out.flush();
        }
        catch (FileNotFoundException fe) {
            log.error((Object)"Error", (Throwable)fe);
            throw fe;
        }
        catch (IOException e) {
            log.error((Object)"Error", (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createFile(String content, String fileName, String destEncoding) {
        BufferedWriter bw = null;
        try {
            File files = new File(fileName);
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(files), destEncoding));
            bw.write(content, 0, content.length());
            bw.flush();
        }
        catch (IOException e) {
            log.error((Object)"Error", (Throwable)e);
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(String fileName, String srcEncoding) throws FileNotFoundException, IOException {
        File file = null;
        file = new File(fileName);
        if (!file.isFile()) {
            throw new IOException("'" + fileName + "' is not a file.");
        }
        BufferedReader reader = null;
        try {
            int readLength;
            StringBuffer result = new StringBuffer(1024);
            FileInputStream fis = new FileInputStream(fileName);
            reader = new BufferedReader(new InputStreamReader((InputStream)fis, srcEncoding));
            char[] block = new char[512];
            while ((readLength = reader.read(block)) != -1) {
                result.append(block, 0, readLength);
            }
            String string = result.toString();
            return string;
        }
        catch (FileNotFoundException fe) {
            log.error((Object)"Error", (Throwable)fe);
            throw fe;
        }
        catch (IOException e) {
            log.error((Object)"Error", (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getLastLines(File file, int linesToReturn) throws IOException, FileNotFoundException {
        int AVERAGE_CHARS_PER_LINE = 250;
        int BYTES_PER_CHAR = 2;
        RandomAccessFile randomAccessFile = null;
        StringBuffer buffer = new StringBuffer(linesToReturn * 250);
        int lineTotal = 0;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
            long byteTotal = randomAccessFile.length();
            long byteEstimateToRead = linesToReturn * 250 * 2;
            long offset = byteTotal - byteEstimateToRead;
            if (offset < 0L) {
                offset = 0L;
            }
            randomAccessFile.seek(offset);
            String line = null;
            String lineUTF8 = null;
            while ((line = randomAccessFile.readLine()) != null) {
                lineUTF8 = new String(line.getBytes("ISO8859_1"), "UTF-8");
                ++lineTotal;
                buffer.append(lineUTF8).append("\n");
            }
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException ex) {}
            }
        }
        String[] resultLines = new String[linesToReturn];
        BufferedReader in = null;
        try {
            int i;
            in = new BufferedReader(new StringReader(buffer.toString()));
            int start = lineTotal - linesToReturn;
            if (start < 0) {
                start = 0;
            }
            for (i = 0; i < start; ++i) {
                in.readLine();
            }
            i = 0;
            String line = null;
            while ((line = in.readLine()) != null) {
                resultLines[i] = line;
                ++i;
            }
        }
        catch (IOException ie) {
            log.error((Object)("Error" + ie));
            throw ie;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {}
            }
        }
        return resultLines;
    }

    public static String getHumanSize(long size) {
        int sizeToStringLength = String.valueOf(size).length();
        String humanSize = "";
        DecimalFormat formatter = new DecimalFormat("##0.##");
        humanSize = sizeToStringLength > 9 ? humanSize + formatter.format((double)size / 1.073741824E9) + " GB" : (sizeToStringLength > 6 ? humanSize + formatter.format((double)size / 1048576.0) + " MB" : (sizeToStringLength > 3 ? humanSize + formatter.format((double)size / 1024.0) + " KB" : humanSize + String.valueOf(size) + " Bytes"));
        return humanSize;
    }
}

