/*
 * Decompiled with CFR 0.152.
 */
package tot.util;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.bean.DataField;
import tot.dao.DaoFactory;
import tot.db.DBUtils;
import tot.global.Sysconfig;
import tot.util.DateUtil;
import tot.util.FileUtil;
import tot.util.StringUtils;
import tot.util.UrlUtil;

public class LabelUtil {
    private static Log log = LogFactory.getLog(LabelUtil.class);

    public static String ImportFile(int t, String encode, String uri) {
        String ret = "";
        if (t == 0) {
            try {
                String filepath = FileUtil.getServletClassesPath();
                String diagonal = FileUtil.getSeparator();
                filepath = StringUtils.replaceString(filepath, diagonal + "WEB-INF" + diagonal + "classes" + diagonal, "");
                if (!uri.startsWith("/")) {
                    uri = "/" + uri;
                }
                uri = StringUtils.replaceString(uri, "/", diagonal);
                ret = FileUtil.readFile(filepath + uri, encode);
            }
            catch (Exception e) {
                ret = "\u65e0\u6cd5\u8bfb\u53d6\u8d44\u6e90\u6587\u4ef6\uff1a" + uri;
            }
        } else if (t == 1) {
            try {
                ret = UrlUtil.getHtml(uri, encode);
            }
            catch (Exception e) {
                ret = "\u65e0\u6cd5\u8bfb\u53d6\u8d44\u6e90\u6587\u4ef6\uff1a" + uri;
            }
        }
        return ret;
    }

    public static String replaceStaticLabel(String str, int categoryid) {
        String returnStr = str;
        returnStr = returnStr.replaceAll("\\$Year\\$", DateUtil.getYear() + "");
        returnStr = returnStr.replaceAll("\\$Month\\$", DateUtil.getMonth() + "");
        returnStr = returnStr.replaceAll("\\$Day\\$", DateUtil.getDay() + "");
        returnStr = returnStr.replaceAll("\\$Random\\$", StringUtils.getRandomNumber(1, 9999));
        if (categoryid > 0) {
            DataField df = DaoFactory.getCategoryDAO().getCategory(categoryid);
            if (df != null) {
                returnStr = returnStr.replaceAll("\\$CategoryName\\$", df.getFieldValue("Title"));
                returnStr = returnStr.replaceAll("\\$LinkUrl\\$", df.getFieldValue("LinkUrl"));
                returnStr = returnStr.replaceAll("\\$Description\\$", df.getFieldValue("Desrb"));
                returnStr = returnStr.replaceAll("\\$Keywords\\$", df.getFieldValue("Keywords"));
            }
            df = null;
            returnStr = returnStr.replaceAll("\\$CategoryId\\$", categoryid + "");
        }
        returnStr = returnStr.replaceAll("\\$SiteUrl\\$", Sysconfig.getSiteUrl());
        returnStr = returnStr.replaceAll("\\$SiteName\\$", Sysconfig.getSiteName());
        returnStr = returnStr.replaceAll("\\$Position\\$", DaoFactory.getCategoryDAO().getPosition(categoryid, "&gt;"));
        returnStr = returnStr.replaceAll("\\$ContextPath\\$", Sysconfig.getContextPath());
        returnStr = returnStr.replaceAll("\\$GetChilds\\$", DaoFactory.getCategoryDAO().getChilds(categoryid));
        returnStr = returnStr.replaceAll("\\$GetBrothers\\$", DaoFactory.getCategoryDAO().getBrothers(categoryid));
        return returnStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String replaceFunction(String str, int categoryid) {
        String returnStr = str;
        String sql = "";
        StringBuffer sb = new StringBuffer(512);
        Pattern p = Pattern.compile("\\$Sub\\[([\\w]+)\\]\\$([\\s|\\S]*?)\\$End\\$");
        Matcher m = p.matcher(returnStr);
        while (m.find()) {
            String fname = m.group(1);
            String fstr = m.group(2);
            StringBuffer dbs = new StringBuffer(512);
            sql = DaoFactory.getFunctionDAO().getContent(fname);
            if (sql == null) continue;
            Connection conn = null;
            Statement stmt = null;
            ResultSet rs = null;
            Object df = null;
            try {
                conn = DBUtils.getConnection();
                stmt = conn.createStatement();
                rs = stmt.executeQuery(sql);
                ResultSetMetaData rsmd = rs.getMetaData();
                int cols = rsmd.getColumnCount();
                while (rs.next()) {
                    String trstr = fstr;
                    for (int j = 1; j <= cols; ++j) {
                        String ttm;
                        int max = 0;
                        trstr = StringUtils.replaceString(trstr, "f(" + j + ")", rs.getString(j));
                        Pattern pcol = Pattern.compile("f\\(" + j + "(\\-*)(\\d*)\\)");
                        Matcher mcol = pcol.matcher(trstr);
                        if (mcol.find() && (ttm = mcol.group(2)) != null && !ttm.equals("")) {
                            max = Integer.parseInt(ttm);
                        }
                        trstr = max > 0 ? StringUtils.replaceString(trstr, "f(" + j + "-" + max + ")", StringUtils.getTopic(rs.getString(j), max)) : StringUtils.replaceString(trstr, "f(" + j + ")", rs.getString(j));
                    }
                    dbs.append(trstr);
                }
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"Sql Exception Error:", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtils.closeResultSet(rs);
                    DBUtils.closeStatement(stmt);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
                DBUtils.closeResultSet(rs);
                DBUtils.closeStatement(stmt);
                DBUtils.closeConnection(conn);
            }
            DBUtils.closeResultSet(rs);
            DBUtils.closeStatement(stmt);
            DBUtils.closeConnection(conn);
            m.appendReplacement(sb, dbs.toString());
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static String replaceAllLabel(String content, int categoryid) {
        String tempStr = content;
        tempStr = LabelUtil.replaceStaticLabel(tempStr, categoryid);
        tempStr = LabelUtil.replaceFunction(tempStr, categoryid);
        ArrayList list = (ArrayList)DaoFactory.getLabelDAO().getLabelByCategory(categoryid);
        for (DataField df : list) {
            if (tempStr.indexOf(df.getFieldValue("Title")) == -1) continue;
            String labeltitle = df.getFieldValue("Title");
            String labelcontent = df.getFieldValue("Content");
            labelcontent = labelcontent.replaceAll("\\(", ",");
            labelcontent = labelcontent.replaceAll("\\)", "");
            labelcontent = labelcontent.replaceAll("\\\"", "");
            String labeldata = LabelUtil.getLabelData(labelcontent, categoryid);
            tempStr = StringUtils.replaceString(tempStr, labeltitle, labeldata);
        }
        return tempStr;
    }

    public static String getLabelData(String label, int categoryid) {
        String[] temparr = label.split(",");
        String returnStr = "";
        if (temparr == null || temparr.length <= 0) {
            return "error,Please check the label you have made;";
        }
        if (temparr[0].equalsIgnoreCase("GetArticle") && temparr.length == 14) {
            returnStr = DaoFactory.getArticleDAO().getArticles(Integer.parseInt(temparr[1]), temparr[2], temparr[3], Integer.parseInt(temparr[4]), Integer.parseInt(temparr[5]), Integer.parseInt(temparr[6]), temparr[7], Integer.parseInt(temparr[8]), temparr[9], Integer.parseInt(temparr[10]), Integer.parseInt(temparr[11]), Integer.parseInt(temparr[12]), temparr[13]);
        } else if (temparr[0].equalsIgnoreCase("GetArticleDiv") && temparr.length == 10) {
            returnStr = DaoFactory.getArticleDAO().getArticlesDiv(Integer.parseInt(temparr[1]), Integer.parseInt(temparr[2]), temparr[3], Integer.parseInt(temparr[4]), temparr[5], Integer.parseInt(temparr[6]), Integer.parseInt(temparr[7]), Integer.parseInt(temparr[8]), temparr[9]);
        } else if (temparr[0].equalsIgnoreCase("GetCategorysArticleDiv") && temparr.length == 10) {
            returnStr = DaoFactory.getCategoryDAO().getCategoryArticlesDiv(categoryid, Integer.parseInt(temparr[1]), Integer.parseInt(temparr[2]), temparr[3], Integer.parseInt(temparr[4]), temparr[5], Integer.parseInt(temparr[6]), Integer.parseInt(temparr[7]), Integer.parseInt(temparr[8]), temparr[9]);
        } else if (temparr[0].equalsIgnoreCase("GetSpecialArticle") && temparr.length == 13) {
            returnStr = DaoFactory.getArticleDAO().getSpecialArticles(Integer.parseInt(temparr[1]), temparr[2], temparr[3], Integer.parseInt(temparr[4]), Integer.parseInt(temparr[5]), Integer.parseInt(temparr[6]), temparr[7], Integer.parseInt(temparr[8]), temparr[9], Integer.parseInt(temparr[10]), Integer.parseInt(temparr[11]), temparr[12]);
        } else if (temparr[0].equalsIgnoreCase("GetDynamicArticle") && temparr.length == 14) {
            returnStr = DaoFactory.getArticleDAO().getArticles(categoryid, temparr[2], temparr[3], Integer.parseInt(temparr[4]), Integer.parseInt(temparr[5]), Integer.parseInt(temparr[6]), temparr[7], Integer.parseInt(temparr[8]), temparr[9], Integer.parseInt(temparr[10]), Integer.parseInt(temparr[11]), Integer.parseInt(temparr[12]), temparr[13]);
        } else if (temparr[0].equalsIgnoreCase("GetImgs") && temparr.length == 14) {
            returnStr = DaoFactory.getArticleDAO().getImgs(Integer.parseInt(temparr[1]), temparr[2], temparr[3], Integer.parseInt(temparr[4]), Integer.parseInt(temparr[5]), temparr[6], Integer.parseInt(temparr[7]), temparr[8], Integer.parseInt(temparr[9]), Integer.parseInt(temparr[10]), Integer.parseInt(temparr[11]), Integer.parseInt(temparr[12]), temparr[13]);
        } else if (temparr[0].equalsIgnoreCase("GetImgsDiv") && temparr.length == 12) {
            returnStr = DaoFactory.getArticleDAO().getImgsDiv(Integer.parseInt(temparr[1]), Integer.parseInt(temparr[2]), Integer.parseInt(temparr[3]), temparr[4], Integer.parseInt(temparr[5]), temparr[6], Integer.parseInt(temparr[7]), Integer.parseInt(temparr[8]), Integer.parseInt(temparr[9]), Integer.parseInt(temparr[10]), temparr[11]);
        } else if (temparr[0].equalsIgnoreCase("GetImgsDivDesc") && temparr.length == 12) {
            returnStr = DaoFactory.getArticleDAO().getImgsDivDesc(Integer.parseInt(temparr[1]), Integer.parseInt(temparr[2]), Integer.parseInt(temparr[3]), temparr[4], Integer.parseInt(temparr[5]), temparr[6], Integer.parseInt(temparr[7]), Integer.parseInt(temparr[8]), Integer.parseInt(temparr[9]), Integer.parseInt(temparr[10]), temparr[11]);
        } else if (temparr[0].equalsIgnoreCase("GetDynamicImgs") && temparr.length == 14) {
            returnStr = DaoFactory.getArticleDAO().getImgs(categoryid, temparr[2], temparr[3], Integer.parseInt(temparr[4]), Integer.parseInt(temparr[5]), temparr[6], Integer.parseInt(temparr[7]), temparr[8], Integer.parseInt(temparr[9]), Integer.parseInt(temparr[10]), Integer.parseInt(temparr[11]), Integer.parseInt(temparr[12]), temparr[13]);
        } else if (temparr[0].equalsIgnoreCase("GetCategory") && temparr.length == 6) {
            returnStr = DaoFactory.getCategoryDAO().getCategory(Integer.parseInt(temparr[1]), temparr[2], Integer.parseInt(temparr[3]), Integer.parseInt(temparr[4]), temparr[5]);
        } else if (temparr[0].equalsIgnoreCase("GetEduCategory") && temparr.length == 6) {
            returnStr = DaoFactory.getCategoryDAO().getEduCategory(Integer.parseInt(temparr[1]), temparr[2], Integer.parseInt(temparr[3]), Integer.parseInt(temparr[4]), temparr[5]);
        } else if (temparr[0].equalsIgnoreCase("GetSpecials") && temparr.length == 5) {
            returnStr = DaoFactory.getSpecialDAO().getSpecials(temparr[1], Integer.parseInt(temparr[2]), Integer.parseInt(temparr[3]), temparr[4]);
        } else if (temparr[0].equalsIgnoreCase("GetDynamicCategory") && temparr.length == 6) {
            returnStr = DaoFactory.getCategoryDAO().getCategory(categoryid, temparr[2], Integer.parseInt(temparr[3]), Integer.parseInt(temparr[4]), temparr[5]);
        } else if (temparr[0].equalsIgnoreCase("Get1Title") && temparr.length == 6) {
            returnStr = DaoFactory.getArticleDAO().get1Title(Integer.parseInt(temparr[1]), temparr[2], temparr[3], Integer.parseInt(temparr[4]), temparr[5]);
        } else if (temparr[0].equalsIgnoreCase("Get1Content") && temparr.length == 6) {
            returnStr = DaoFactory.getArticleDAO().get1Content(Integer.parseInt(temparr[1]), temparr[2], temparr[3], Integer.parseInt(temparr[4]), temparr[5]);
        } else if (temparr[0].equalsIgnoreCase("GetFlinks") && temparr.length == 6) {
            returnStr = DaoFactory.getFlinkDAO().getLinkList(Integer.parseInt(temparr[1]), Integer.parseInt(temparr[2]), Integer.parseInt(temparr[3]), temparr[4], temparr[5]);
        } else if (temparr[0].equalsIgnoreCase("GetEduDownDiv") && temparr.length == 14) {
            returnStr = DaoFactory.getEduDownloadDAO().getLabelList(Integer.parseInt(temparr[1]), Integer.parseInt(temparr[2]), temparr[3], Integer.parseInt(temparr[4]), Integer.parseInt(temparr[5]), Integer.parseInt(temparr[6]), Integer.parseInt(temparr[7]), Integer.parseInt(temparr[8]), Integer.parseInt(temparr[9]), Integer.parseInt(temparr[10]), Integer.parseInt(temparr[11]), Integer.parseInt(temparr[12]), Integer.parseInt(temparr[13]));
        } else if (temparr[0].equalsIgnoreCase("GetEduDownImgDiv") && temparr.length == 15) {
            returnStr = DaoFactory.getEduDownloadDAO().getImgLabelList(Integer.parseInt(temparr[1]), Integer.parseInt(temparr[2]), Integer.parseInt(temparr[3]), Integer.parseInt(temparr[4]), Integer.parseInt(temparr[5]), temparr[6], Integer.parseInt(temparr[7]), Integer.parseInt(temparr[8]), Integer.parseInt(temparr[9]), Integer.parseInt(temparr[10]), Integer.parseInt(temparr[11]), Integer.parseInt(temparr[12]), Integer.parseInt(temparr[13]), Integer.parseInt(temparr[14]));
        } else if (temparr[0].equalsIgnoreCase("GetEduDownImgDescDiv") && temparr.length == 15) {
            returnStr = DaoFactory.getEduDownloadDAO().getImgLabelListDesc(Integer.parseInt(temparr[1]), Integer.parseInt(temparr[2]), Integer.parseInt(temparr[3]), Integer.parseInt(temparr[4]), Integer.parseInt(temparr[5]), temparr[6], Integer.parseInt(temparr[7]), Integer.parseInt(temparr[8]), Integer.parseInt(temparr[9]), Integer.parseInt(temparr[10]), Integer.parseInt(temparr[11]), Integer.parseInt(temparr[12]), Integer.parseInt(temparr[13]), Integer.parseInt(temparr[14]));
        } else if (temparr[0].equalsIgnoreCase("GetCategorysEduDiv") && temparr.length == 5) {
            returnStr = DaoFactory.getCategoryDAO().getCategoryEdusDiv(categoryid, Integer.parseInt(temparr[1]), Integer.parseInt(temparr[2]), Integer.parseInt(temparr[3]), temparr[4]);
        } else if (temparr[0].equalsIgnoreCase("GetVideoTxtDiv") && temparr.length == 9) {
            returnStr = DaoFactory.getVideoDAO().getLabelList(Integer.parseInt(temparr[1]), Integer.parseInt(temparr[2]), temparr[3], Integer.parseInt(temparr[4]), Integer.parseInt(temparr[5]), Integer.parseInt(temparr[6]), Integer.parseInt(temparr[7]), Integer.parseInt(temparr[8]));
        } else if (temparr[0].equalsIgnoreCase("GetVideoImgsDiv") && temparr.length == 10) {
            returnStr = DaoFactory.getVideoDAO().getImgLabelList(Integer.parseInt(temparr[1]), Integer.parseInt(temparr[2]), Integer.parseInt(temparr[3]), Integer.parseInt(temparr[4]), Integer.parseInt(temparr[5]), temparr[6], Integer.parseInt(temparr[7]), Integer.parseInt(temparr[8]), Integer.parseInt(temparr[9]));
        } else if (temparr[0].equalsIgnoreCase("ImportUri") && temparr.length == 4) {
            returnStr = LabelUtil.ImportFile(Integer.parseInt(temparr[1]), temparr[2], temparr[3]);
        } else {
            return "error,Please check the label you have made:" + label;
        }
        return returnStr;
    }
}

