/*
 * Decompiled with CFR 0.152.
 */
package tot.util;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TimerUtil {
    private static Log log = LogFactory.getLog(TimerUtil.class);
    private static TimerUtil instance = null;
    private static boolean isCanceled = false;
    private Timer timer = null;

    private TimerUtil() {
        log.debug((Object)"TimerUtil is instantiated.");
        this.timer = new Timer();
    }

    private void reloadTimer() {
        log.info((Object)"Reload Timer in TimerUtil.");
        if (!isCanceled) {
            this.timer.cancel();
            this.timer = new Timer();
        }
    }

    public static synchronized TimerUtil getInstance() {
        if (instance == null) {
            instance = new TimerUtil();
        }
        return instance;
    }

    public void cancel() {
        isCanceled = true;
        this.timer.cancel();
    }

    public void schedule(TimerTask task, Date firstTime, long period) {
        if (!isCanceled) {
            try {
                this.timer.schedule(task, firstTime, period);
            }
            catch (IllegalStateException ex) {
                log.error((Object)"Cannot schedule task!", (Throwable)ex);
                this.reloadTimer();
            }
        }
    }

    public void schedule(TimerTask task, Date time) {
        if (!isCanceled) {
            try {
                this.timer.schedule(task, time);
            }
            catch (IllegalStateException ex) {
                log.error((Object)"Cannot schedule task!", (Throwable)ex);
                this.reloadTimer();
            }
        }
    }

    public void schedule(TimerTask task, long delay) {
        if (!isCanceled) {
            try {
                this.timer.schedule(task, delay);
            }
            catch (IllegalStateException ex) {
                log.error((Object)"Cannot schedule task!", (Throwable)ex);
                this.reloadTimer();
            }
        }
    }

    public void schedule(TimerTask task, long delay, long period) {
        if (!isCanceled) {
            try {
                this.timer.schedule(task, delay, period);
            }
            catch (IllegalStateException ex) {
                log.error((Object)"Cannot schedule task!", (Throwable)ex);
                this.reloadTimer();
            }
        }
    }

    public void scheduleAtFixedRate(TimerTask task, Date firstTime, long period) {
        if (!isCanceled) {
            try {
                this.timer.schedule(task, firstTime, period);
            }
            catch (IllegalStateException ex) {
                log.error((Object)"Cannot schedule task!", (Throwable)ex);
                this.reloadTimer();
            }
        }
    }

    public void scheduleAtFixedRate(TimerTask task, long delay, long period) {
        if (!isCanceled) {
            try {
                this.timer.schedule(task, delay, period);
            }
            catch (IllegalStateException ex) {
                log.error((Object)"Cannot schedule task!", (Throwable)ex);
                this.reloadTimer();
            }
        }
    }
}

