/*
 * Decompiled with CFR 0.152.
 */
package tot.util;

import java.sql.Timestamp;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.service.TotCmsServiceImpl;
import tot.util.DateUtil;
import tot.util.FileUtil;

public class TotCmsContextListener
implements ServletContextListener {
    private static Log log = LogFactory.getLog(TotCmsContextListener.class);
    private static TotCmsContextListener instance;
    private Timestamp startTimestamp;

    public TotCmsContextListener() {
        instance = this;
    }

    public void contextInitialized(ServletContextEvent event) {
        log.debug((Object)"contextInitialized");
        String realPath = event.getServletContext().getRealPath("/WEB-INF/classes");
        FileUtil.setServletClassesPath(realPath);
        TotCmsServiceImpl service = new TotCmsServiceImpl();
        service.contextInitialized(event);
        this.startTimestamp = DateUtil.getCurrentGMTTimestamp();
    }

    public void contextDestroyed(ServletContextEvent event) {
        TotCmsServiceImpl service = new TotCmsServiceImpl();
        service.contextDestroyed(event);
        instance = null;
        try {
            log.debug((Object)"About to sleep 2 seconds.");
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        log.debug((Object)"contextDestroyed");
    }

    public static TotCmsContextListener getInstance() {
        return instance;
    }

    public Timestamp getStartTimestamp() {
        return this.startTimestamp;
    }
}

