/*
 * AdDaoImplJDBC.java
 *
 * Created on 20061115, 9:14
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package tot.dao.jdbc;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.bean.*;
import tot.exception.ObjectNotFoundException;
import tot.exception.DatabaseException;
import java.sql.*;
import java.util.*;
import java.io.StringReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 *
 * @author tot
 */
public class AdDaoImplJDBC extends AbstractDao{
    private static Log log = LogFactory.getLog(AdDaoImplJDBC.class);
    /** Creates a new instance of AdDaoImplJDBC */
    public AdDaoImplJDBC() {
    }
    /*
     * get last id
     */
    public int getLastId(){        
        int returnValue=0;
        String sql=null;
        DataField df=null;/*
        if (DBUtils.getDatabaseType() == DBUtils.DATABASE_SQLSERVER) {
            sql="select top 1 id from t_ad order by id desc";
            df=getFirstData(sql,"id");
        }else if(DBUtils.getDatabaseType() == DBUtils.DATABASE_MYSQL){
            sql="select id from t_ad order by id desc limit 0,1";
            df=getFirstData(sql,"id");
        }else if(DBUtils.getDatabaseType()==DBUtils.DATABASE_DB2){
            sql="select id from t_ad order by id desc fetch first 1 rows only";
            df=getFirstData(sql,"id");
        }else if(DBUtils.getDatabaseType()==DBUtils.DATABASE_ORACLE){
            sql="select id from t_ad where rownum=1 order by id desc";
            df=getFirstData(sql,"id");
        }else{
            
        }*/
        sql="select id from t_ad order by id desc";
        Collection lists =this.getDataList_Limit_Normal(sql,"id",1,0);
            Iterator iter = lists.iterator();
            if (iter.hasNext()) {
                df= (DataField)iter.next();                
            }
        if(df!=null){
            returnValue=Integer.parseInt(df.getFieldValue("id"));
        }else{
            returnValue=1;
        }
        return returnValue;
    }
    /** add Ad */
    public boolean addAd(int id,int categoryid,String title,String content,int adtype,Timestamp expirestime,Timestamp moditime){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        String sql="insert into t_ad(id,CategoryId,Title,Content,AdType,ExpiresTime,ModiTime) values(?,?,?,?,?,?,?)";
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setInt(1,id);
            ps.setInt(2,categoryid);
            ps.setString(3,title);
            if(DBUtils.getDatabaseType()==DBUtils.DATABASE_ORACLE){
                ps.setCharacterStream(4, new StringReader(content), content.length());
            }else{
                ps.setString(4,content);
            }
            ps.setInt(5,adtype);
            ps.setTimestamp(6,expirestime);
            ps.setTimestamp(7,moditime);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            log.error("add Ad error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    /*
     * mod Ad
     */
    public boolean modAd(int id,int categoryid,String title,String content,int adtype,Timestamp expirestime,Timestamp moditime){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        String sql="update t_ad set CategoryId=?,Title=?,Content=?,AdType=?,ExpiresTime=?,ModiTime=? where id=?";
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setInt(1,categoryid);
            ps.setString(2,title);
            if(DBUtils.getDatabaseType()==DBUtils.DATABASE_ORACLE){
                ps.setCharacterStream(3, new StringReader(content), content.length());
            }else{
                ps.setString(3,content);
            }
            ps.setInt(4,adtype);
            ps.setTimestamp(5,expirestime);
            ps.setTimestamp(6,moditime);
            ps.setInt(7,id);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            log.error("mod Ad error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    public boolean delAd(int id) throws ObjectNotFoundException,DatabaseException{
        return exe("delete from t_ad where id="+id);
    }
    public Collection getAds(){
        String sql="select id,CategoryId,Title,AdType,ExpiresTime,ModiTime from t_ad order by id asc";
        return getData(sql,"id,CategoryId,Title,AdType,ExpiresTime,ModiTime");
    }
    public Collection getAdList_Limit(int categoryid,int currentpage,int pagesize){
        if(DBUtils.getDatabaseType() == DBUtils.DATABASE_MYSQL){
            StringBuffer sql=new StringBuffer(512);
            sql.append("select id,CategoryId,Title,AdType,ExpiresTime,ModiTime from t_ad");
            if(categoryid>0) sql.append(" where CategoryId="+categoryid);
            sql.append(" order by id desc");
            return getDataList_mysqlLimit(sql.toString(),"id,CategoryId,Title,AdType,ExpiresTime,ModiTime",pagesize,(currentpage-1)*pagesize);
        } else if (DBUtils.getDatabaseType() == DBUtils.DATABASE_SQLSERVER) {
            StringBuffer sql=new StringBuffer(512);
            sql.append("SELECT TOP ");
            sql.append(pagesize);
            sql.append(" id,CategoryId,Title,AdType,ExpiresTime,ModiTime FROM t_ad WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP ");
            sql.append((currentpage-1)*pagesize+1);
            sql.append(" id  FROM t_ad");
            if(categoryid>0) sql.append(" where CategoryId="+categoryid);
            sql.append(" ORDER BY id DESC) AS t))");
            if(categoryid>0) sql.append(" and CategoryId="+categoryid);
            sql.append(" ORDER BY id DESC");
            return getData(sql.toString(),"id,CategoryId,Title,AdType,ExpiresTime,ModiTime");
        } else{
            StringBuffer sql=new StringBuffer(512);
            sql.append("select id,CategoryId,Title,AdType,ExpiresTime,ModiTime from t_ad");
            if(categoryid>0) sql.append(" where CategoryId="+categoryid);
            sql.append(" order by id desc");
            return getDataList_Limit_Normal(sql.toString(),"id,CategoryId,Title,AdType,ExpiresTime,ModiTime",pagesize,(currentpage-1)*pagesize);
        }
    }
    public DataField getAd(int id){
        return getFirstData("select id,CategoryId,Title,Content,AdType,ExpiresTime,ModiTime from t_ad where id="+id,"id,CategoryId,Title,Content,AdType,ExpiresTime,ModiTime");
    }
    public int getTotalCount(int categoryid){
        StringBuffer sql=new StringBuffer(512);
        sql.append("select count(*) from t_ad");
        if(categoryid>0){
            sql.append(" where CategoryId=");
            sql.append(categoryid);
        }
        return(this.getDataCount(sql.toString()));
    }
}
