/*
 * AdminDaoImplJDBC.java
 *
 * Created on 200681, 2:51
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package tot.dao.jdbc;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.bean.*;
import tot.exception.ObjectNotFoundException;
import tot.exception.DatabaseException;
import tot.util.MD5;
import tot.util.DateUtil;
import java.sql.*;
import java.util.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 *
 * @author totcms
 */
public class AdminDaoImplJDBC extends AbstractDao{
    private static Log log = LogFactory.getLog(AdminDaoImplJDBC.class);
    /** Creates a new instance of AdminDaoImplJDBC */
    public AdminDaoImplJDBC() {
    }
    public boolean addAdmin(String admin,String passwd,int roleid,Timestamp moditime){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        String sql="insert into t_admin(UserName,PassWord,RoleId,ModiTime,IsLock,LoginNum) values(?,?,?,?,0,0)";
        try{
            MD5 md5=new MD5();
            String password=md5.getMD5of32(passwd);
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setString(1, admin);
            ps.setString(2, password);
            ps.setInt(3, roleid);
            ps.setTimestamp(4,moditime);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            e.printStackTrace();
            return false;
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    public boolean modAdmin(String admin,int roleid,int adminid){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        String sql="update t_admin set UserName=?,RoleId=? where id=?";
        try{
            MD5 md5=new MD5();            
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setString(1, admin);
            ps.setInt(2, roleid);
            ps.setInt(3, adminid);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            e.printStackTrace();
            return false;
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    /*
     * change password
     */
    public boolean changePass(String username,String passwd){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        String sql="update t_admin set PassWord=? where UserName=?";
        try{
            MD5 md5=new MD5();
            String password=md5.getMD5of32(passwd);
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setString(1, passwd);
            ps.setString(2, username);            
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            e.printStackTrace();
            return false;
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    public boolean deleAdmin(int adminid) throws ObjectNotFoundException,DatabaseException{
        return exe("delete from t_admin where id="+adminid);
    }
    public void updateLoginNum(String admin) throws ObjectNotFoundException,DatabaseException{
        exe("update t_admin set LoginNum=LoginNum+1 where UserName='"+admin+"'");
    }
    public boolean adminLogin(String admin,String passwd) throws ObjectNotFoundException,DatabaseException{
        Connection conn = null;
        PreparedStatement ps=null;
        ResultSet rs = null;
        boolean returnValue=false;
        if(DateUtil.isExpire())
            throw new ObjectNotFoundException("System get error");
        try{
            MD5 md5=new MD5();
            String password=md5.getMD5of32(passwd);
            conn = DBUtils.getConnection();
            ps = conn.prepareStatement("select id from t_admin where UserName=? and PassWord=? and IsLock=0");
            ps.setString(1,admin);
            ps.setString(2,password);
            rs=ps.executeQuery();
            if(rs.next()){
                returnValue=true;
            }
            if(returnValue){
                updateLoginNum(admin);
            }
        } catch(SQLException e){
            log.error("Sql Execution Error!",e);
            return false;
        } finally{
            DBUtils.closeResultSet(rs);
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    public Collection getAdminStat(Timestamp startDate,Timestamp endDate,int offset,int rowsNum){
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        Collection returnList = new ArrayList();
        try{
            conn = DBUtils.getConnection();
            ps = conn.prepareStatement("select t_admin.UserName,count(*) as c from t_article,t_admin where t_admin.UserName=t_article.UserName and t_article.ModiTime>? and t_article.ModiTime<? group by t_admin.UserName order by c desc", ResultSet.TYPE_SCROLL_INSENSITIVE, ResultSet.CONCUR_READ_ONLY);
            ps.setTimestamp(1, startDate);
            ps.setTimestamp(2, endDate);
            ps.setMaxRows(offset+rowsNum);
            try {
                ps.setFetchSize(rowsNum);
            } catch (SQLException sqle) {
                //do nothing, postgreSQL doesnt support this method
            }
            rs=ps.executeQuery();
            boolean loop = rs.absolute(offset + 1);
            DataField df;
            String[] splitStr=null;            
            while(loop) {
                df=new DataField();
                df.setField("Title", rs.getString(1),0);
                df.setField("Num", rs.getString(2),0);
                returnList.add(df);
                if (returnList.size() >= rowsNum) break;// Fix the Sybase bug
                loop = rs.next();
            }
        } catch(SQLException e){
            
        } finally{
            DBUtils.closeResultSet(rs);
            DBUtils.resetStatement(ps);
            DBUtils.closeStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnList;        
    }
    public Collection getAdminList(int roleid,int currentpage,int pagesize){
        StringBuffer sql=new StringBuffer(512);
        String fieldArr="id,UserName,LoginNum,IsLock,RoleId,ModiTime,RoleId";
        if (DBUtils.getDatabaseType() == DBUtils.DATABASE_SQLSERVER) {
            sql.append("select top ");
            sql.append(pagesize);
            sql.append(fieldArr);
            sql.append(" from t_admin WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP "+((currentpage-1)*pagesize+1)+" id  FROM t_admin where 1=1");
            if(roleid>0){
                sql.append(" and RoleId="+roleid);
            }
            sql.append(" ORDER BY id DESC) AS t))");
            if(roleid>0){
                sql.append(" and RoleId="+roleid);
            }
            sql.append(" ORDER BY id DESC");
            return this.getData(sql.toString(),fieldArr);
        } else if(DBUtils.getDatabaseType() == DBUtils.DATABASE_MYSQL){
            sql.append("select ");
            sql.append(fieldArr);
            sql.append(" from t_admin where 1=1");
            if(roleid>0){
                sql.append(" and RoleId="+roleid);
            }
            sql.append(" order by id desc limit ");
            sql.append((currentpage-1)*pagesize);
            sql.append(",");
            sql.append(pagesize);
            return this.getData(sql.toString(),fieldArr);
        }else{
            sql.append("select ");
            sql.append(fieldArr);
            sql.append(" from t_admin order by id desc");
            return getDataList_Limit_Normal(sql.toString(),fieldArr,pagesize,(currentpage-1)*pagesize);
        }
    }
    public DataField getAdmin(int id){
        String fieldArr="id,UserName,PassWord,LoginNum,IsLock,RoleId,ModiTime";
        String sql="select "+fieldArr+" from t_admin where id="+id;
        return getFirstData(sql, fieldArr);
    }
    public static boolean ifHasPrivilege(String privilege,String rolecode){
        boolean returnValue=false;
        String[] privArr=null;
        if(privilege!=null && rolecode!=null){
            privArr=privilege.split(",");
            for(int i=0;i<privArr.length;i++){
                if(privArr[i].equalsIgnoreCase(rolecode)){
                    returnValue=true;
                    break;
                }
            }
        }
        return returnValue;
    }
    public String getPrivelege(String username){
        Connection conn = null;
        PreparedStatement ps=null;
        ResultSet rs = null;
        String returnValue=null;
        try{
            conn = DBUtils.getConnection();
            ps = conn.prepareStatement("select t_role.Privilege from t_admin,t_role where t_admin.UserName=? and t_admin.RoleId=t_role.id");
            ps.setString(1,username);
            rs=ps.executeQuery();
            if(rs.next()){
                returnValue=rs.getString(1);
            }
        } catch(SQLException e){
            log.error("Sql Execution Error!",e);
        } finally{
            DBUtils.closeResultSet(rs);
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    public String getId(String username){
        Connection conn = null;
        PreparedStatement ps=null;
        ResultSet rs = null;
        String returnValue=null;
        try{
            conn = DBUtils.getConnection();
            ps = conn.prepareStatement("select id from t_admin where UserName=?");
            ps.setString(1,username);
            rs=ps.executeQuery();
            if(rs.next()){
                returnValue=rs.getString(1);
            }
        } catch(SQLException e){
            log.error("Sql Execution Error!",e);
        } finally{
            DBUtils.closeResultSet(rs);
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    /** lock admin **/
    public void lockAdmin (String[] s){
        this.bat("update t_admin set IsLock=1 where id=?",s);        
    }
    /** unlock admin **/
    public void unlockAdmin (String[] s){
        this.bat("update t_admin set IsLock=0 where id=?",s);        
    }
    public int getAdminNum(int roleid){
        int returnValue=0;
        String sql="select count(*) from t_admin where 1=1";
        if(roleid>0){
            sql+=" and RoleId="+roleid;
        }
        returnValue=getDataCount(sql);
        return returnValue;
    }
}
