/*
 * AgencyDaoImplJDBC.java
 *
 * Created on 2007610, 11:52
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package tot.dao.jdbc;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.bean.*;
import tot.exception.ObjectNotFoundException;
import tot.exception.DatabaseException;
import java.sql.*;
import java.util.*;
import java.io.StringReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 *
 * @author totcms
 */
public class AgencyDaoImplJDBC extends AbstractDao{
    private static Log log = LogFactory.getLog(AgencyDaoImplJDBC.class);
    /** Creates a new instance of AgencyDaoImplJDBC */
    public AgencyDaoImplJDBC() {
    }
    public int findIdByUserName(String username){
        int returnValue=0;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement("select id from t_2agency where UserName=?");
            ps.setString(1,username);
            rs=ps.executeQuery();
            if(rs.next()){
                returnValue=rs.getInt(1);
            }else{
                returnValue=0;
            }
        } catch(SQLException e){
            e.printStackTrace();
            return 0;
        } finally{
            DBUtils.closeResultSet(rs);
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    /*
     * check if user exits by userid
     */
    public boolean findByUserId(String userid){
        boolean returnValue=false;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement("select * from t_2agency where UserName=?");
            ps.setString(1,userid);
            rs=ps.executeQuery();
            if(rs.next()){
                returnValue=true;
            }else{
                returnValue=false;
            }
        } catch(SQLException e){
            e.printStackTrace();
            return false;
        } finally{
            DBUtils.closeResultSet(rs);
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    /** add floor level */
    public boolean addAgency(String username,String password,String title,int cityid,String address,String tel,String fax,String contactman,String mobile,
            String email,String weburl,String master,String manager,String cercard,String cerno,String regmoney,String regtime,String hasman,String othershop,String servtype,
            String descri,Timestamp begintime,Timestamp endtime,int maxlimit,int usednum,int sortnum,String photo){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        String sql="insert into t_2agency(UserName,PassWord,Title,CityId,Address,Tel,Fax,ContactMan,Mobile,Email,WebUrl,Master,Manager," +
                "CerCard,CerNo,RegMoney,RegTime,HasMan,OtherShop,ServType,Descri,BeginTime,EndTime,MaxLimit,UsedNum,SortNum,Photo)" +
                " values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setString(1,username);
            ps.setString(2,password);
            ps.setString(3,title);
            ps.setInt(4,cityid);
            ps.setString(5,address);
            ps.setString(6,tel);
            ps.setString(7,fax);
            ps.setString(8,contactman);
            ps.setString(9,mobile);
            ps.setString(10,email);
            ps.setString(11,weburl);
            ps.setString(12,master);
            ps.setString(13,manager);
            ps.setString(14,cercard);
            ps.setString(15,cerno);
            ps.setString(16,regmoney);
            ps.setString(17,regtime);
            ps.setString(18,hasman);
            ps.setString(19,othershop);
            ps.setString(20,servtype);            
            if(DBUtils.getDatabaseType()==DBUtils.DATABASE_ORACLE){
                ps.setCharacterStream(21, new StringReader(descri), descri.length());
            }else{
                ps.setString(21,descri);
            }
            ps.setTimestamp(22,begintime);
            ps.setTimestamp(23,endtime);
            ps.setInt(24,maxlimit);
            ps.setInt(25,usednum);
            ps.setInt(26,sortnum);
            ps.setString(27,photo);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            log.error("add Agency error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    /*
     * mod floor level
     */
    public boolean modAgency(int id,String username,String password,String title,int cityid,String address,String tel,String fax,String contactman,String mobile,
            String email,String weburl,String master,String manager,String cercard,String cerno,String regmoney,String regtime,String hasman,String othershop,String servtype,
            String descri,Timestamp begintime,Timestamp endtime,int maxlimit,int usednum,int sortnum,String photo){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        String sql="update t_2agency set UserName=?,PassWord=?,Title=?,CityId=?,Address=?,Tel=?,Fax=?,ContactMan=?,Mobile=?,Email=?,WebUrl=?,Master=?,Manager=?," +
                "CerCard=?,CerNo=?,RegMoney=?,RegTime=?,HasMan=?,OtherShop=?,ServType=?,Descri=?,BeginTime=?,EndTime=?,MaxLimit=?,UsedNum=?,SortNum=?,Photo=? where id=?";
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setString(1,username);
            ps.setString(2,password);
            ps.setString(3,title);
            ps.setInt(4,cityid);
            ps.setString(5,address);
            ps.setString(6,tel);
            ps.setString(7,fax);
            ps.setString(8,contactman);
            ps.setString(9,mobile);
            ps.setString(10,email);
            ps.setString(11,weburl);
            ps.setString(12,master);
            ps.setString(13,manager);
            ps.setString(14,cercard);
            ps.setString(15,cerno);
            ps.setString(16,regmoney);
            ps.setString(17,regtime);
            ps.setString(18,hasman);
            ps.setString(19,othershop);
            ps.setString(20,servtype);
            if(DBUtils.getDatabaseType()==DBUtils.DATABASE_ORACLE){
                ps.setCharacterStream(21, new StringReader(descri), descri.length());
            }else{
                ps.setString(21,descri);
            }
            ps.setTimestamp(22,begintime);
            ps.setTimestamp(23,endtime);
            ps.setInt(24,maxlimit);
            ps.setInt(25,usednum);
            ps.setInt(26,sortnum);
            ps.setString(27,photo);
            ps.setInt(28,id);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            log.error("mod Agency error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    /* delete floor level by id */
    public boolean delAgency(int id) throws ObjectNotFoundException,DatabaseException{
        return exe("delete from t_2agency where id="+id);
    }
    /* get Agency by id */
    public DataField getAgency(int id){
        String fields="UserName,PassWord,Title,CityId,Address,Tel,Fax,ContactMan,Mobile,Email,WebUrl,Master,Manager," +
                "CerCard,CerNo,RegMoney,RegTime,HasMan,OtherShop,ServType,Descri,BeginTime,EndTime,MaxLimit,UsedNum,SortNum,Photo";
        return getFirstData("select "+fields+" from t_2agency where id="+id,fields);
    }
    /* get Agency count */
    public int getTotalCount(int check){
        String sql="select count(*) from t_2agency";
        sql+=" where IsOk="+check;
        return(this.getDataCount(sql));
    }
    /* get list */
    public Collection getAgencyList(int check,int currentpage,int pagesize){
        StringBuffer sql=new StringBuffer(512);
        String fieldArr="id,UserName,PassWord,Title,Address,Tel,BeginTime,EndTime,MaxLimit,UsedNum,IsOk,SortNum,Photo";
        if (DBUtils.getDatabaseType() == DBUtils.DATABASE_SQLSERVER) {
            sql.append("select top ");
            sql.append(pagesize);
            sql.append(fieldArr);
            sql.append(" from t_2agency WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP "+((currentpage-1)*pagesize+1)+" id  FROM t_2agency");
            sql.append(" where IsOk=").append(check);
            sql.append("ORDER BY id DESC) AS t))");
            sql.append(" and IsOk=").append(check);
            sql.append(" ORDER BY id DESC");
            return this.getData(sql.toString(),fieldArr);
        } else if(DBUtils.getDatabaseType() == DBUtils.DATABASE_MYSQL){
            sql.append("select ");
            sql.append(fieldArr);
            sql.append(" from t_2agency");
            sql.append(" where IsOk=").append(check);
            sql.append(" order by id desc limit ");
            sql.append((currentpage-1)*pagesize);
            sql.append(",");
            sql.append(pagesize);
            return this.getData(sql.toString(),fieldArr);
        }else{
            sql.append("select ");
            sql.append(fieldArr);
            sql.append(" from t_2agency");
            sql.append(" where IsOk=").append(check);
            sql.append(" order by id desc");
            return getDataList_Limit_Normal(sql.toString(),fieldArr,pagesize,(currentpage-1)*pagesize);
        }
    }
    /*
     * get agency list
     */
    public Collection getAgencys(){
        StringBuffer sql=new StringBuffer(512);
        String fieldArr="id,Title,Address,Tel,Photo";
        sql.append("select ");
        sql.append(fieldArr);
        sql.append(" from t_2agency where IsOk=1 order by SortNum asc");
        return this.getData(sql.toString(),fieldArr);
    }
    /* get agency select */
    public String getSelect(int currentid){
        StringBuffer sb=new StringBuffer();
        Connection conn = null;
        Statement stmt=null;
        ResultSet rs = null;
        try{
            conn = DBUtils.getConnection();
            stmt = conn.createStatement();
            rs=stmt.executeQuery("select id,Title from t_2agency where IsOk=1 order by id asc");
            while(rs.next()) {
                sb.append("<option value=\"");
                sb.append(rs.getInt(1));
                sb.append("\"");
                if(currentid==rs.getInt(1))
                    sb.append(" selected=\"selected\"");
                sb.append(">");
                sb.append(rs.getString(2));
                sb.append("</option>\n");
            }
        } catch(SQLException e){
            log.error("Sql Exception Error:",e);
        } finally{
            DBUtils.closeResultSet(rs);
            DBUtils.closeStatement(stmt);
            DBUtils.closeConnection(conn);
        }
        return sb.toString();
    }
    /*
     * agency login
     */
    public boolean agencyLogin(String userid,String passwd) throws ObjectNotFoundException,DatabaseException{
        Connection conn = null;
        PreparedStatement ps=null;
        ResultSet rs = null;
        boolean returnValue=false;
        try{
            conn = DBUtils.getConnection();
            ps = conn.prepareStatement("select EndTime from t_2agency where UserName=? and PassWord=? and IsOk=1");
            ps.setString(1,userid);
            ps.setString(2,passwd);
            rs=ps.executeQuery();
            if(rs.next()){
                long endt=rs.getTimestamp(1).getTime();
                if(System.currentTimeMillis()>endt){
                    returnValue=false;
                }else{
                    returnValue=true;
                }
            }
        } catch(SQLException e){
            log.error("Sql Execution Error!",e);
            return false;
        } finally{
            DBUtils.closeResultSet(rs);
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    /*
     * reach max limit set
     */
    public boolean reachMaxLimit(int id){
        Connection conn = null;
        PreparedStatement ps=null;
        ResultSet rs = null;
        boolean returnValue=true;
        try{
            conn = DBUtils.getConnection();
            ps = conn.prepareStatement("select MaxLimit,UsedNum from t_2agency where id=?");
            ps.setInt(1,id);
            rs=ps.executeQuery();
            if(rs.next()){
                int maxlimit=rs.getInt(1);
                int usednum=rs.getInt(2);
                if(usednum>=maxlimit){
                    returnValue=true;
                }else{
                    returnValue=false;
                }
            }
        } catch(SQLException e){
            log.error("Sql Execution Error!",e);
            return false;
        } finally{
            DBUtils.closeResultSet(rs);
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    public void batDel(String[] s){
        this.bat("delete from t_2agency where id=?",s);
    }
    public void batCheck(String[] s){
        this.bat("update t_2agency set IsOk=1 where id=?",s);
    }
    public void batUnCheck(String[] s){
        this.bat("update t_2agency set IsOk=0 where id=?",s);
    }
    public void updateUsedNum(int id) throws ObjectNotFoundException,DatabaseException{
        this.exe("update t_2agency set UsedNum=UsedNum+1 where id="+id);
    }
    public void minusUsedNum(int id) throws ObjectNotFoundException,DatabaseException{
        this.exe("update t_2agency set UsedNum=UsedNum-1 where id="+id);
    }
}
