/*
 * CategoryDaoImplJDBC.java
 *
 * Created on 2006916, 4:14
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package tot.dao.jdbc;
import tot.dao.AbstractDao;
import tot.dao.DaoFactory;
import tot.db.DBUtils;
import tot.util.LabelUtil;
import tot.util.StringUtils;
import tot.global.Sysconfig;
import tot.bean.*;
import tot.exception.ObjectNotFoundException;
import tot.exception.DatabaseException;
import java.sql.*;
import java.util.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 *
 * @author totcms
 */
public class CategoryDaoImplJDBC extends AbstractDao{
    private static Log log = LogFactory.getLog(CategoryDaoImplJDBC.class);
    /** Creates a new instance of CategoryDaoImplJDBC */
    public CategoryDaoImplJDBC() {
    }
    public int getLastId(){
        DataField df=null;
        int returnValue=0;
        String sql=null;
        sql="select id from t_category order by id desc";
        Collection lists =this.getDataList_Limit_Normal(sql,"id",1,0);
        Iterator iter = lists.iterator();
        if (iter.hasNext()) {
            df= (DataField)iter.next();
        }
        if(df!=null){
            returnValue=Integer.parseInt(df.getFieldValue("id"))+1;
        }else{
            returnValue=1;
        }
        return returnValue;
    }
    public int getLastSendId(int id){
        DataField df=null;
        int returnValue=0;
        String sql=null;
        sql="select id from t_category where id>"+id+" order by id asc";
        Collection lists =this.getDataList_Limit_Normal(sql,"id",1,0);
        Iterator iter = lists.iterator();
        if (iter.hasNext()) {
            df= (DataField)iter.next();
        }
        if(df!=null){
            returnValue=Integer.parseInt(df.getFieldValue("id"));
        }else{
            returnValue=0;
        }
        return returnValue;    
    }
    public int getLastSendId(int id,int parentid){
        DataField df=null;
        int returnValue=0;
        String sql=null;
        sql="select id from t_category where ParentId="+parentid+" and id>"+id+" order by id asc";
        Collection lists =this.getDataList_Limit_Normal(sql,"id",1,0);
        Iterator iter = lists.iterator();
        if (iter.hasNext()) {
            df= (DataField)iter.next();
        }
        if(df!=null){
            returnValue=Integer.parseInt(df.getFieldValue("id"));
        }else{
            returnValue=0;
        }
        return returnValue;    
    }
    public DataField getCategory(int id){
        String fieldArr="id,Title,Template,SavePath,ParentId,IsChannel,LinkUrl,Desrb,Keywords,SortNum,ModiTime,ShowTemplateId";
        return getFirstData("select "+fieldArr+" from t_category where id="+id,fieldArr);
    }
    public boolean addCategory(String title,String template,String savepath,int parentid,int ischannel,
            String linkUrl,String desrb,String keywords,int sortNum,Timestamp moditime,int showtemplateid){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        int lastid=getLastId();
        savepath=LabelUtil.replaceStaticLabel(savepath,lastid);
        linkUrl=LabelUtil.replaceStaticLabel(linkUrl,lastid);
        String sql="insert into t_category(id,Title,Template,SavePath,ParentId,IsChannel,LinkUrl,Desrb,Keywords,SortNum,ModiTime,ShowTemplateId) values(?,?,?,?,?,?,?,?,?,?,?,?)";
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setInt(1,lastid);
            ps.setString(2,title);
            ps.setString(3,template);
            ps.setString(4,savepath);
            ps.setInt(5,parentid);
            ps.setInt(6,ischannel);
            ps.setString(7,linkUrl);
            ps.setString(8,desrb);
            ps.setString(9,keywords);
            ps.setInt(10,sortNum);
            ps.setTimestamp(11,moditime);
            ps.setInt(12,showtemplateid);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            log.error("add Category error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    /*
     * mod category
     */
    public boolean modCategory(int id,String title,String template,String savepath,int parentid,int ischannel,
            String linkUrl,String desrb,String keywords,int sortNum,Timestamp moditime,int showtemplateid){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        String sql="update t_category set Title=?,Template=?,SavePath=?,ParentId=?,IsChannel=?,LinkUrl=?,Desrb=?,Keywords=?,SortNum=?,ModiTime=?,ShowTemplateId=? where id=?";
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setString(1,title);
            ps.setString(2,template);
            ps.setString(3,savepath);
            ps.setInt(4,parentid);
            ps.setInt(5,ischannel);
            ps.setString(6,linkUrl);
            ps.setString(7,desrb);
            ps.setString(8,keywords);
            ps.setInt(9,sortNum);
            ps.setTimestamp(10,moditime);
            ps.setInt(11,showtemplateid);
            ps.setInt(12,id);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            log.error("mod Category error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    public boolean delCategory(int id) throws ObjectNotFoundException,DatabaseException{
        return exe("delete from t_category where id="+id);
    }
    public Collection getCategoryByParentId(int parentid){
        StringBuffer sql=new StringBuffer(512);
        String fieldArr="id,Title,Template,SavePath,IsChannel,LinkUrl,Desrb,Keywords,SortNum,ModiTime,ShowTemplateId";
        sql.append("select ");
        sql.append(fieldArr);
        sql.append(" from t_category where ParentId=");
        sql.append(parentid);
        sql.append(" order by SortNum asc ");
        return getData(sql.toString(),fieldArr);
    }
    /*
     * get categorys
     */
    public Collection getCategorys(){
        String fieldArr="id,Title,Template,SavePath,IsChannel,LinkUrl,Desrb,Keywords,SortNum,ModiTime,ShowTemplateId";
        String sql="select "+fieldArr+" from t_category";
        return getData(sql,fieldArr);
    }
    /**
     * get category by channnel
     */
    public Collection getCategorysByChannel(){
        String fieldArr="id,Title,Template,SavePath,LinkUrl,Desrb,Keywords,SortNum,ModiTime,ShowTemplateId";
        String sql="select "+fieldArr+" from t_category where IsChannel=1 order by SortNum asc ";
        return getData(sql,fieldArr);
    }
    public String getCategoryName(int id){
        DataField df=getFirstData("select Title from t_category where id="+id,"Title");
        String returnValue=null;
        if(df!=null){
            returnValue=df.getFieldValue("Title");
        }
        return returnValue;
    }
    public int getParentId(int categoryid){
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        int returnValue=0;
        String sql=null;
        sql="select ParentId from t_category where id=?";
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setInt(1,categoryid);
            rs=ps.executeQuery();
            if(rs.next()){
                returnValue=rs.getInt(1);
            }
        } catch(SQLException e){
            log.error("get Parentid",e);
        } finally{
            DBUtils.closeResultSet(rs);
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    public String getPosition(int categoryid,String separator){
        String returnValue="";
        DataField df=getCategory(categoryid);
        String contextPath=Sysconfig.getContextPath();
        String url=Sysconfig.getSiteUrl();
        if(df!=null){
            StringBuffer sb=new StringBuffer(512);
            int ischannel=Integer.parseInt(df.getFieldValue("IsChannel"));
            sb.append(separator);
            sb.append(" <a href=\"");
            //sb.append(url+contextPath);
            sb.append(df.getFieldValue("LinkUrl"));
            if(ischannel!=1) sb.append("/index_1.htm");
            sb.append("\">");
            sb.append(df.getFieldValue("Title"));
            sb.append("</a> \n");
            int parentid=Integer.parseInt(df.getFieldValue("ParentId"));
            returnValue=sb.toString();
            if(parentid!=0){
                returnValue=getPosition(parentid,separator)+returnValue;
            }
        }
        return returnValue;
    }
    //
    public String getChilds(int categoryId){
        String contextPath=Sysconfig.getContextPath();
        String url=Sysconfig.getSiteUrl();
        StringBuffer sb=new StringBuffer(512);
        ArrayList list=(ArrayList)getCategoryByParentId(categoryId);
        for (Iterator iter = list.iterator(); iter.hasNext(); ) {
            DataField df=(DataField)iter.next();
            sb.append("<li><a href=\"");
            int ischannel=Integer.parseInt(df.getFieldValue("IsChannel"));
            //sb.append(url+contextPath);
            sb.append(df.getFieldValue("LinkUrl"));
            if(ischannel!=1) sb.append("/index_1.htm");
            sb.append("\">");
            sb.append(df.getFieldValue("Title"));
            sb.append("</a></li>\n");
        }
        return sb.toString();
    }
    public String getBrothers(int categoryId){
        int parentId=getParentId(categoryId);
        String contextPath=Sysconfig.getContextPath();
        String url=Sysconfig.getSiteUrl();
        StringBuffer sb=new StringBuffer(512);
        ArrayList list=(ArrayList)getCategoryByParentId(parentId);
        for (Iterator iter = list.iterator(); iter.hasNext(); ) {
            DataField df=(DataField)iter.next();
            sb.append("<li><a href=\"");
            int ischannel=Integer.parseInt(df.getFieldValue("IsChannel"));
            //sb.append(url+contextPath);
            sb.append(df.getFieldValue("LinkUrl"));
            if(ischannel!=1) sb.append("/index_1.htm");
            sb.append("\">");
            sb.append(df.getFieldValue("Title"));
            sb.append("</a></li>\n");
        }
        return sb.toString();
    }
    //
    public String getCategory(int categoryId,String ulStyle,int getNum,int charMax,String titlePre){
        //int parentId=getParentId(categoryId);
        String contextPath=Sysconfig.getContextPath();
        String url=Sysconfig.getSiteUrl();
        StringBuffer sb=new StringBuffer(512);
        ArrayList list=(ArrayList)getCategoryByParentId(categoryId);
        sb.append("<ul class=\"");
        sb.append(ulStyle);
        sb.append("\">");
        int i=1;
        for (Iterator iter = list.iterator(); iter.hasNext(); ) {
            DataField df=(DataField)iter.next();
            sb.append("<li>");
            sb.append(titlePre);
            sb.append("<a href=\"");
            int ischannel=Integer.parseInt(df.getFieldValue("IsChannel"));
            //sb.append(url+contextPath);
            sb.append(df.getFieldValue("LinkUrl"));
            if(ischannel!=1) sb.append("/index_1.htm");
            sb.append("\">");
            sb.append(StringUtils.getTopic(df.getFieldValue("Title"),charMax));
            sb.append("</a></li>\n");
            if(getNum>0 && i>=getNum)
                break;
            i++;
        }
        sb.append("</ul>");
        return sb.toString();
    }
    public String getEduCategory(int categoryId,String ulStyle,int getNum,int charMax,String titlePre){
        //int parentId=getParentId(categoryId);
        String contextPath=Sysconfig.getContextPath();
        String url=Sysconfig.getSiteUrl();
        StringBuffer sb=new StringBuffer(512);
        ArrayList list=(ArrayList)getCategoryByParentId(categoryId);
        sb.append("<ul class=\"");
        sb.append(ulStyle);
        sb.append("\">");
        int i=1;
        for (Iterator iter = list.iterator(); iter.hasNext(); ) {
            DataField df=(DataField)iter.next();
            int ischannel=Integer.parseInt(df.getFieldValue("IsChannel"));
            sb.append("<li>");
            sb.append(titlePre);
            if(ischannel==1){
                sb.append("     <a href=\""+df.getFieldValue("LinkUrl")+"\">");
            }else{
                sb.append("     <a href=\"/edu/list.jsp?id="+df.getFieldValue("id")+"\">");
            }            
            sb.append(StringUtils.getTopic(df.getFieldValue("Title"),charMax));
            sb.append("</a></li>\n");
            if(getNum>0 && i>=getNum)
                break;
            i++;
        }
        sb.append("</ul>");
        return sb.toString();
    }
    public int getTotalCount(){
        StringBuffer sql=new StringBuffer(512);
        sql.append("select count(*) from t_category");
        return(this.getDataCount(sql.toString()));
    }
    public int getTotalCount(int parentid){
        StringBuffer sql=new StringBuffer(512);
        sql.append("select count(*) from t_category where ParentId="+parentid);
        return(this.getDataCount(sql.toString()));
    }
    /* get category select */
    public String getSelect(int parentid){
        return getSelect(parentid,0);
    }
    public String getSelect(int parentid,int cid){
        StringBuffer sb=new StringBuffer();
        Connection conn = null;
        Statement stmt=null;
        ResultSet rs = null;
        try{
            conn = DBUtils.getConnection();
            stmt = conn.createStatement();
            rs=stmt.executeQuery("select id,Title from t_category where ParentId="+parentid+" order by id asc");
            while(rs.next()) {
                sb.append("<option value=\"");
                sb.append(rs.getInt(1));
                sb.append("\"");
                if(cid==rs.getInt(1)){
                    sb.append(" selected=\"selected\"");
                }
                sb.append(">");
                sb.append(rs.getString(2));
                sb.append("</option>\n");
            }
        } catch(SQLException e){
            log.error("Sql Exception Error:",e);
        } finally{
            DBUtils.closeResultSet(rs);
            DBUtils.closeStatement(stmt);
            DBUtils.closeConnection(conn);
        }
        return sb.toString();
    }
    public String getCategoryArticlesDiv(int categoryId,int categorynum,int rowsNum,
            String sort,int charMax,String titlePrefix,int showTime,int getChilds,int showCatalog,String ArticleAttr){
        StringBuffer sb=new StringBuffer(512);
        ArrayList list=(ArrayList)getCategoryByParentId(categoryId);
        int i=1;
        for (Iterator iter = list.iterator(); iter.hasNext(); ) {
            DataField df=(DataField)iter.next();
            String news=DaoFactory.getArticleDAO().getArticlesDiv(Integer.parseInt(df.getFieldValue("id")),rowsNum,sort,charMax,titlePrefix,showTime,getChilds,showCatalog,ArticleAttr);
            sb.append("<div class=\"categorycontainer\">\n");
            sb.append(" <div class=\"categorytitle\" id=\"category"+df.getFieldValue("id")+"\">\n");
            sb.append("     <a href=\""+df.getFieldValue("SavePath")+"\">"+df.getFieldValue("Title")+"</a>");
            sb.append(" </div>\n");
            sb.append(" <div class=\"categorylist\"><ul>\n");
            sb.append(news);
            sb.append(" </ul></div>\n");
            sb.append("</div>\n");
            if(categorynum>0 && i>=categorynum)
                break;
            i++;
        }
        return sb.toString();
    }
    public String getCategoryEdusDiv(int categoryId,int categorynum,int rowsNum,int charMax,String titlePrefix){
        StringBuffer sb=new StringBuffer(512);
        ArrayList list=(ArrayList)getCategoryByParentId(categoryId);
        int i=1;
        for (Iterator iter = list.iterator(); iter.hasNext(); ) {
            DataField df=(DataField)iter.next();
            int ischannel=Integer.parseInt(df.getFieldValue("IsChannel"));
            String news=DaoFactory.getEduDownloadDAO().getLabelList(rowsNum,charMax,titlePrefix,Integer.parseInt(df.getFieldValue("id")),0,0,0,-1,-1,0,0,0,0);
            sb.append("<div class=\"categorycontainer\">\n");
            sb.append(" <div class=\"categorytitle\" id=\"category"+df.getFieldValue("id")+"\">\n");
            if(ischannel==1){
                sb.append("     <a href=\""+df.getFieldValue("LinkUrl")+"\">"+df.getFieldValue("Title")+"</a>");
            }else{
                sb.append("     <a href=\"/edu/list.jsp?id="+df.getFieldValue("id")+"\">"+df.getFieldValue("Title")+"</a>");
            }
            
            sb.append(" </div>\n");
            sb.append(" <div class=\"categorylist\"><ul>\n");
            sb.append(news);
            sb.append(" </ul></div>\n");
            sb.append("</div>\n");
            if(categorynum>0 && i>=categorynum)
                break;
            i++;
        }
        return sb.toString();
    }
}
