/*
 * CityDaoImplJDBC.java
 *
 * Created on 2007610, 11:52
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package tot.dao.jdbc;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.bean.*;
import tot.exception.ObjectNotFoundException;
import tot.exception.DatabaseException;
import java.sql.*;
import java.util.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 *
 * @author totcms
 */
public class CityDaoImplJDBC extends AbstractDao{
    private static Log log = LogFactory.getLog(CityDaoImplJDBC.class);
    /** Creates a new instance of CityDaoImplJDBC */
    public CityDaoImplJDBC() {
    }
    /** add floor level */
    public boolean addCity(String title){
        Connection conn = null;
        PreparedStatement ps = null;        
        boolean returnValue=true;        
        String sql="insert into t_city(Title) values(?)";
        try{           
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setString(1,title);            
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){            
            log.error("add city error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    /*
     * mod floor level
     */
    public boolean modCity(int id,String title){
        Connection conn = null;
        PreparedStatement ps = null;        
        boolean returnValue=true;        
        String sql="update t_city set Title=? where id=?";
        try{           
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql); 
            ps.setString(1,title);
            ps.setInt(2,id);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){            
            log.error("mod city error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    /* delete floor level by id */
    public boolean delCity(int id) throws ObjectNotFoundException,DatabaseException{
        return exe("delete from t_city where id="+id);
    }
    /* get city by id */
    public DataField getCity(int id){
        return getFirstData("select id,Title from t_city where id="+id,"id,Title");
    }
    /* get city count */
    public int getTotalCount(){
        return(this.getDataCount("select count(*) from t_city"));
    }
    /* get list */
    public Collection getCityList(int currentpage,int pagesize){
        StringBuffer sql=new StringBuffer(512);
        String fieldArr="id,Title";
        if (DBUtils.getDatabaseType() == DBUtils.DATABASE_SQLSERVER) {
            sql.append("select top ");
            sql.append(pagesize);
            sql.append(fieldArr);
            sql.append(" from t_city WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP "+((currentpage-1)*pagesize+1)+" id  FROM t_city");            
            sql.append(" ORDER BY id DESC) AS t))");            
            sql.append(" ORDER BY id DESC");  
            return this.getData(sql.toString(),fieldArr);
        } else if(DBUtils.getDatabaseType() == DBUtils.DATABASE_MYSQL){
            sql.append("select ");
            sql.append(fieldArr);
            sql.append(" from t_city");            
            sql.append(" order by id desc limit ");
            sql.append((currentpage-1)*pagesize);
            sql.append(",");
            sql.append(pagesize);
            return this.getData(sql.toString(),fieldArr);
        }else{
            sql.append("select ");
            sql.append(fieldArr);
            sql.append(" from t_city");            
            sql.append(" order by id desc");
            return getDataList_Limit_Normal(sql.toString(),fieldArr,pagesize,(currentpage-1)*pagesize);
        }
    }
    /* get floor level select */
    public String getSelect(int currentid){
        StringBuffer sb=new StringBuffer();
        Connection conn = null;
        Statement stmt=null;
        ResultSet rs = null;        
        try{
            conn = DBUtils.getConnection();
            stmt = conn.createStatement();
            rs=stmt.executeQuery("select id,Title from t_city order by id asc");            
            while(rs.next()) {
                sb.append("<option value=\"");
                sb.append(rs.getInt(1));
                sb.append("\"");
                if(currentid==rs.getInt(1))
                    sb.append(" selected=\"selected\"");
                sb.append(">");
                sb.append(rs.getString(2));
                sb.append("</option>\n");
            }            
        } catch(SQLException e){
            log.error("Sql Exception Error:",e);
        } finally{
            DBUtils.closeResultSet(rs);            
            DBUtils.closeStatement(stmt);
            DBUtils.closeConnection(conn);
        }
        return sb.toString();
    }
    public void batDel(String[] s){
        this.bat("delete from t_city where id=?",s);
    }
}
