/*
 * CommenDaoImplJDBC.java
 *
 * Created on 2007119, 10:51
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package tot.dao.jdbc;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.bean.*;
import tot.exception.ObjectNotFoundException;
import tot.exception.DatabaseException;
import java.sql.*;
import java.util.*;
import java.io.StringReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 *
 * @author totcms
 */
public class CommenDaoImplJDBC extends AbstractDao{
    private static Log log = LogFactory.getLog(CommenDaoImplJDBC.class);
    /** Creates a new instance of CommenDaoImplJDBC */
    public CommenDaoImplJDBC() {
    }
    /** add Commen */
    public boolean addCommen(int articleid,int categoryid,String author,String content,String ip,Timestamp moditime){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        String sql="insert into t_commen(ArticleId,CategoryId,Author,Content,Ip,ModiTime) values(?,?,?,?,?,?)";
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setInt(1,articleid);
            ps.setInt(2,categoryid);
            ps.setString(3,author);
            if(DBUtils.getDatabaseType()==DBUtils.DATABASE_ORACLE){
                ps.setCharacterStream(4, new StringReader(content), content.length());
            }else{
                ps.setString(4,content);
            }
            ps.setString(5,ip);           
            ps.setTimestamp(6,moditime);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            log.error("add Commen error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    /*
     * mod Commen
     */
    public boolean modCommen(int id,String author,String content){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        String sql="update t_commen set author=?,Content=? where id=?";
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setString(1,author);
            if(DBUtils.getDatabaseType()==DBUtils.DATABASE_ORACLE){
                ps.setCharacterStream(2, new StringReader(content), content.length());
            }else{
                ps.setString(2,content);
            }     
            ps.setInt(3,id);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            log.error("mod Commen error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }    
    public DataField getCommen(int id){
        return getFirstData("select id,ArticleId,CategoryId,Author,Content,Ip,ModiTime from t_commen where id="+id,"id,ArticleId,CategoryId,Author,Content,Ip,ModiTime");
    }
    public boolean delCommen(int id) throws ObjectNotFoundException,DatabaseException{
        return exe("delete from t_commen where id="+id);
    }
    public void batDel(String[] s){
        this.bat("delete from t_commen where id=?",s);
    }
    /* get commen list **/
    public Collection getCommenList_Limit(int currentpage,int pagesize){
        if(DBUtils.getDatabaseType() == DBUtils.DATABASE_MYSQL){
            StringBuffer sql=new StringBuffer(512);
            sql.append("select t.id AS t1,t.Author AS t2,t.Content AS t3,t.Ip,t.ModiTime AS t4,a.SavePath AS a1  from t_commen AS t,t_article AS a where t.ArticleId=a.id order by t.id desc");
            return getDataList_mysqlLimit(sql.toString(),"id,Author,Content,Ip,ModiTime,SavePath",pagesize,(currentpage-1)*pagesize);
        } else if (DBUtils.getDatabaseType() == DBUtils.DATABASE_SQLSERVER) {
            StringBuffer sql=new StringBuffer(512);
            sql.append("SELECT TOP ");
            sql.append(pagesize);
            sql.append(" t.id AS t1,t.Author AS t2,t.Content AS t3,t.Ip,t.ModiTime AS t4,a.SavePath AS a1  from t_commen AS t,t_article AS a WHERE (t.id <=(SELECT MIN(t.id) FROM (SELECT TOP ");
            sql.append((currentpage-1)*pagesize+1);
            sql.append(" t.id  FROM t_commen");            
            sql.append(" ORDER BY t.id DESC) AS t))");            
            sql.append(" and t.ArticleId=a.id ORDER BY t.id DESC");
            return getData(sql.toString(),"id,Author,Content,Ip,ModiTime,SavePath");
        } else{
            StringBuffer sql=new StringBuffer(512);
            sql.append("select t.id AS t1,t.Author AS t2,t.Content AS t3,t.Ip,t.ModiTime AS t4,a.SavePath AS a1  from t_commen AS t,t_article AS a where t.ArticleId=a.id order by t.id desc");            
            return getDataList_Limit_Normal(sql.toString(),"id,Author,Content,Ip,ModiTime,SavePath",pagesize,(currentpage-1)*pagesize);
        }
    }    
    public Collection getCommenListByArticle_Limit(int articleid,int currentpage,int pagesize){
        if(DBUtils.getDatabaseType() == DBUtils.DATABASE_MYSQL){
            StringBuffer sql=new StringBuffer(512);
            sql.append("select id,Author,Content,Ip,ModiTime from t_commen");
            if(articleid>0) sql.append(" where ArticleId="+articleid);
            return getDataList_mysqlLimit(sql.toString(),"id,Author,Content,Ip,ModiTime",pagesize,(currentpage-1)*pagesize);
        } else if (DBUtils.getDatabaseType() == DBUtils.DATABASE_SQLSERVER) {
            StringBuffer sql=new StringBuffer(512);
            sql.append("SELECT TOP ");
            sql.append(pagesize);
            sql.append(" id,Author,Content,Ip,ModiTime FROM t_commen WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP ");
            sql.append((currentpage-1)*pagesize+1);
            sql.append(" id  FROM t_commen");
            if(articleid>0) sql.append(" where ArticleId="+articleid);
            sql.append(" ORDER BY id DESC) AS t))");
            if(articleid>0) sql.append(" and ArticleId="+articleid);
            sql.append(" ORDER BY id DESC");
            return getData(sql.toString(),"id,Author,Content,Ip,ModiTime");
        } else{
            StringBuffer sql=new StringBuffer(512);
            sql.append("select id,Author,Content,Ip,ModiTime from t_commen");
            if(articleid>0) sql.append(" where ArticleId="+articleid);
            return getDataList_Limit_Normal(sql.toString(),"id,Author,Content,Ip,ModiTime",pagesize,(currentpage-1)*pagesize);
        }
    }    
    public int getTotalCount(int articleid){
        StringBuffer sql=new StringBuffer(512);
        sql.append("select count(*) from t_commen");
        if(articleid>0){
            sql.append(" where ArticleId=");
            sql.append(articleid);
        }
        return(this.getDataCount(sql.toString()));
    }
}
