/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package tot.dao.jdbc;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.util.StringUtils;
import tot.global.Sysconfig;
import tot.exception.ObjectNotFoundException;
import tot.exception.DatabaseException;
import java.sql.*;
import java.util.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.bean.DataField;
/**
 *
 * @author Administrator
 */
public class CongealMoneyDaoImplJDBC extends AbstractDao{
    private static Log log = LogFactory.getLog(TransactionDaoImplJDBC.class);
    /** Creates a new instance of CongealMoneyDaoImplJDBC */
    public CongealMoneyDaoImplJDBC() {
    }
    public boolean addTransaction(String userid,Float money,Timestamp moditime,String fdesc){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        String sql="insert into t_congeal_money(UserId,Money,ModiTime,Demons) values(?,?,?,?)";
        try{
            conn = DBUtils.getConnection();
            conn.setAutoCommit(false);
            ps=conn.prepareStatement(sql);
            ps.setString(1,userid);
            ps.setFloat(2,money);
            ps.setTimestamp(3,moditime);
            ps.setString(4,fdesc);
            if(ps.executeUpdate()!=1) returnValue=false;
            conn.commit();
        } catch(SQLException e){
            if(conn!=null){
                try {
                    conn.rollback();
                } catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
            log.error("add congeal money error",e);
        } finally{
            if(conn!=null){
                try {
                    conn.rollback();
                } catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    public boolean delTransaction(int id) throws ObjectNotFoundException,DatabaseException{
        return exe("delete from t_congeal_money where id="+id);
    }
    public void batDel(String[] s){
        this.bat("delete from t_congeal_money where id=?",s);
    }
    
    public Collection getTransactionList_Limit(String userid,int currentpage,int pagesize){
        String fields="id,UserId,Money,ModiTime,Demons";
        StringBuffer sql=new StringBuffer(512);
        if(DBUtils.getDatabaseType() == DBUtils.DATABASE_MYSQL){
            sql.append("select "+fields+" from t_congeal_money where 1=1");            
            if(userid!=null){
                sql.append(" and UserId='"+userid+"'");
            }            
            sql.append(" order by id desc");
            return getDataList_mysqlLimit(sql.toString(),fields,pagesize,(currentpage-1)*pagesize);
        } else{
            sql.append("select "+fields+" from t_congeal_money where 1=1");            
            if(userid!=null){
                sql.append(" and UserId='"+userid+"'");
            }            
            sql.append(" order by id desc");
            return getDataList_Limit_Normal(sql.toString(),fields,pagesize,(currentpage-1)*pagesize);
        }
    }
    public int getTotalCount(String userid){
        int totalNum=0;
        //ݿ
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        StringBuffer sql=new StringBuffer(512);
        sql.append("select count(*) from t_congeal_money where 1=1");
        if(userid!=null){
                sql.append(" and UserId='"+userid+"'");
        }
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql.toString());            
            rs=ps.executeQuery();
            if(rs.next()){
                totalNum=rs.getInt(1);
            }
        }catch(SQLException e){
        } finally{
            DBUtils.closeResultSet(rs);
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return totalNum;
    }
    public DataField getTransaction(int id){
        String fields="id,UserId,Money,ModiTime,Demons";
        return getFirstData("select "+fields+" from t_congeal_money where id="+id,fields);
    }
    public int get(String userid,float money){
        int ret=0;
        //ݿ
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        StringBuffer sql=new StringBuffer(512);
        sql.append("select id from t_congeal_money where UserId=? and Money=?");        
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql.toString());         
            ps.setString(1,userid);
            ps.setFloat(2,money);
            rs=ps.executeQuery();
            if(rs.next()){
                ret=rs.getInt(1);
            }
        }catch(SQLException e){
        } finally{
            DBUtils.closeResultSet(rs);
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return ret;
    }
}
