/*
 * CityDaoImplJDBC.java
 *
 * Created on 2007610, 11:52
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package tot.dao.jdbc;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.bean.*;
import tot.exception.ObjectNotFoundException;
import tot.exception.DatabaseException;
import java.sql.*;
import java.util.*;
import java.io.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 *
 * @author totcms
 */
public class DbImportDaoImplJDBC extends AbstractDao{
    private static Log log = LogFactory.getLog(DbImportDaoImplJDBC.class);
    /** Creates a new instance of CityDaoImplJDBC */
    public DbImportDaoImplJDBC() {
    }
    /** add dbimport level */
    public boolean addDbImport(int db_type,String db_driver,String db_host,String db_name,String db_username,String db_password,
            String db_table,String db_key,String db_order,String db_sql,int categoryid,int templateid,int default_status,String fields_map){
        Connection conn = null;
        PreparedStatement ps = null;        
        boolean returnValue=true;        
        String sql="insert into t_dbimport(db_type,db_driver,db_host,db_name,db_username,db_password,db_table,db_key,db_order,db_sql,categoryid,templateid,default_status,fields_map) " +
                "values(?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        try{           
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setInt(1,db_type);
            ps.setString(2,db_driver);
            ps.setString(3,db_host);
            ps.setString(4,db_name);
            ps.setString(5,db_username);
            ps.setString(6,db_password);
            ps.setString(7,db_table);
            ps.setString(8,db_key);
            ps.setString(9,db_order);
            ps.setString(10,db_sql);
            ps.setInt(11,categoryid);
            ps.setInt(12,templateid);
            ps.setInt(13,default_status);
            if(DBUtils.getDatabaseType()==DBUtils.DATABASE_ORACLE){
                ps.setCharacterStream(14, new StringReader(fields_map), fields_map.length());
            }else{
                ps.setString(14,fields_map);
            }   
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){            
            log.error("add dbimport error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    /*
     * mod floor level
     */
    public boolean modDbImport(int id,int db_type,String db_driver,String db_host,String db_name,String db_username,String db_password,
            String db_table,String db_key,String db_order,String db_sql,int categoryid,int templateid,int default_status,String fields_map){
        Connection conn = null;
        PreparedStatement ps = null;        
        boolean returnValue=true;        
        String sql="update t_dbimport set db_type=?,db_driver=?,db_host=?,db_name=?,db_username=?,db_password=?,db_table=?,db_key=?,db_order=?,db_sql=?,categoryid=?,templateid=?,default_status=?,fields_map=? where id=?";
        try{           
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql); 
            ps.setInt(1,db_type);
            ps.setString(2,db_driver);
            ps.setString(3,db_host);
            ps.setString(4,db_name);
            ps.setString(5,db_username);
            ps.setString(6,db_password);
            ps.setString(7,db_table);
            ps.setString(8,db_key);
            ps.setString(9,db_order);
            ps.setString(10,db_sql);
            ps.setInt(11,categoryid);
            ps.setInt(12,templateid);
            ps.setInt(13,default_status);
            if(DBUtils.getDatabaseType()==DBUtils.DATABASE_ORACLE){
                ps.setCharacterStream(14, new StringReader(fields_map), fields_map.length());
            }else{
                ps.setString(14,fields_map);
            }   
            ps.setInt(15,id);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){            
            log.error("mod dbimport error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    /* delete floor level by id */
    public boolean delDbImport(int id) throws ObjectNotFoundException,DatabaseException{
        return exe("delete from t_dbimport where id="+id);
    }
    /* get city by id */
    public DataField getDbImport(int id){
        return getFirstData("select db_type,db_driver,db_host,db_name,db_username,db_password,db_table,db_key,db_order,db_sql,categoryid,templateid,default_status,fields_map from t_dbimport where id="+id,"db_type,db_driver,db_host,db_name,db_username,db_password,db_table,db_key,db_order,db_sql,categoryid,templateid,default_status,fields_map");
    }
    /* get city count */
    public int getTotalCount(){
        return(this.getDataCount("select count(*) from t_dbimport"));
    }
    /* get list */
    public Collection getDbImportList(int currentpage,int pagesize){
        StringBuffer sql=new StringBuffer(512);
        String fieldArr="id,db_type,db_driver,db_host,db_name,db_username,db_password,db_table,db_key,db_order,db_sql,categoryid,templateid,default_status,fields_map";
        if (DBUtils.getDatabaseType() == DBUtils.DATABASE_SQLSERVER) {
            sql.append("select top ");
            sql.append(pagesize);
            sql.append(fieldArr);
            sql.append(" from t_dbimport WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP "+((currentpage-1)*pagesize+1)+" id  FROM t_dbimport");            
            sql.append(" ORDER BY id DESC) AS t))");            
            sql.append(" ORDER BY id DESC");  
            return this.getData(sql.toString(),fieldArr);
        } else if(DBUtils.getDatabaseType() == DBUtils.DATABASE_MYSQL){
            sql.append("select ");
            sql.append(fieldArr);
            sql.append(" from t_dbimport");            
            sql.append(" order by id desc limit ");
            sql.append((currentpage-1)*pagesize);
            sql.append(",");
            sql.append(pagesize);
            return this.getData(sql.toString(),fieldArr);
        }else{
            sql.append("select ");
            sql.append(fieldArr);
            sql.append(" from t_dbimport");            
            sql.append(" order by id desc");
            return getDataList_Limit_Normal(sql.toString(),fieldArr,pagesize,(currentpage-1)*pagesize);
        }
    }    
    public void batDel(String[] s){
        this.bat("delete from t_dbimport where id=?",s);
    }
}
