/*
 * EbookDaoImplJDBC.java
 *
 * Created on 200836, 8:45
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package tot.dao.jdbc;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.util.StringUtils;
import tot.bean.*;
import tot.exception.ObjectNotFoundException;
import tot.exception.DatabaseException;
import java.sql.*;
import java.util.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 *
 * @author Administrator
 */
public class EbookDaoImplJDBC extends AbstractDao{
    private static Log log = LogFactory.getLog(EbookDaoImplJDBC.class);
    /** Creates a new instance of EbookDaoImplJDBC */
    public EbookDaoImplJDBC() {
    }
    /*
     * get last id
     */
    public int getLastId(){
        DataField df=null;
        int returnValue=0;
        String sql=null;
        sql="select id from t_ebook order by id desc";
        Collection lists =this.getDataList_Limit_Normal(sql,"id",1,0);
        Iterator iter = lists.iterator();
        if (iter.hasNext()) {
            df= (DataField)iter.next();
        }
        if(df!=null){
            returnValue=Integer.parseInt(df.getFieldValue("id"))+1;
        }else{
            returnValue=1;
        }
        return returnValue;
    }
    public boolean add(int categoryid,String title,String viewimg,String publisher,String pubdate,String content,String filesize,
            String readurl,String downurl,String label,String fdesc){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        String sql="insert into t_ebook(CategoryId,Title,ViewImg,Publisher,PubDate,Content,FileSize,ReadUrl,DownUrl,Label,Fdesc) values(?,?,?,?,?,?,?,?,?,?,?)";
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setInt(1,categoryid);
            ps.setString(2,title);
            ps.setString(3,viewimg);
            ps.setString(4,publisher);
            ps.setString(5,pubdate);
            ps.setString(6,content);            
            ps.setString(7,filesize);
            ps.setString(8,readurl);
            ps.setString(9,downurl);
            ps.setString(10,label);
            ps.setString(11,fdesc);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            log.error("add ebook error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    public boolean mod(int id,int categoryid,String title,String viewimg,String publisher,String pubdate,String content,String filesize,
            String readurl,String downurl,String label,String fdesc){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        String sql="update t_ebook set CategoryId=?,Title=?,ViewImg=?,Publisher=?,PubDate=?,Content=?,FileSize=?,ReadUrl=?,DownUrl=?,Label=?,Fdesc=? where id=?";
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setInt(1,categoryid);
            ps.setString(2,title);
            ps.setString(3,viewimg);
            ps.setString(4,publisher);
            ps.setString(5,pubdate);
            ps.setString(6,content);            
            ps.setString(7,filesize);
            ps.setString(8,readurl);
            ps.setString(9,downurl);
            ps.setString(10,label);
            ps.setString(11,fdesc);
            ps.setInt(12,id);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            log.error("mod ebook error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    public boolean del(int id) throws ObjectNotFoundException,DatabaseException{
        return exe("delete from t_ebook where id="+id);
    }
    public void batDel(String[] s){
        this.bat("delete from t_ebook where id=?",s);
    }
    public void batRecommend(String[] s,int val){
        this.bat("update t_ebook set IsRecommend="+val+" where id=?",s);
    }
    public void upHits(int id) throws ObjectNotFoundException,DatabaseException{
        exe("update t_ebook set Hits=Hits+1 where id="+id);
    }
    public void upAgree(int id) throws ObjectNotFoundException,DatabaseException{
        exe("update t_ebook set Agree=Agree+1 where id="+id);
    }
    public void upDegree(int id) throws ObjectNotFoundException,DatabaseException{
        exe("update t_ebook set Degree=Degree+1 where id="+id);
    }
    public Collection getList_Limit(int categoryid,int isrecommend,String key,int orderby,int currentpage,int pagesize){
        String str="id";
        if(orderby==1){
            str="Hits";
        }else if(orderby==2){
            str="Agree";
        }else if(orderby==3){
            str="degree";
        }
        if(DBUtils.getDatabaseType() == DBUtils.DATABASE_MYSQL){
            StringBuffer sql=new StringBuffer(512);
            sql.append("SELECT t_ebook.id as eid,t_ebook.Title as etitle,t_ebook.ViewImg,Publisher,PubDate,FileSize,ReadUrl,DownUrl,IsRecommend,Fdesc,Hits,Agree,t_category.Title as ctitle from t_ebook,t_category where t_ebook.CategoryId=t_category.id");            
            if(categoryid>0) sql.append(" and t_ebook.CategoryId="+categoryid); 
            if(isrecommend>=0) sql.append(" and t_ebook.IsRecommend="+isrecommend);
            if(key!=null) sql.append(" and t_ebook.Label like '%"+key+"%'");
            sql.append(" order by t_ebook."+str+" desc");
            return getDataList_mysqlLimit(sql.toString(),"id,Title,ViewImg,Publisher,PubDate,FileSize,ReadUrl,DownUrl,IsRecommend,Fdesc,Hits,Agree,CategoryTitle",pagesize,(currentpage-1)*pagesize);
        } else if (DBUtils.getDatabaseType() == DBUtils.DATABASE_SQLSERVER) {
            StringBuffer sql=new StringBuffer(512);
            sql.append("SELECT TOP ");
            sql.append(pagesize);
            sql.append(" id,Title FROM t_ebook WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP ");
            sql.append((currentpage-1)*pagesize+1);
            sql.append(" id  FROM t_ebook");
            sql.append(" ORDER BY id DESC) AS t))");
            sql.append(" ORDER BY id DESC");
            return getData(sql.toString(),"id,Title");
        } else{
            StringBuffer sql=new StringBuffer(512);
            sql.append("select id,Title from t_ebook");
            return getDataList_Limit_Normal(sql.toString(),"id,Title",pagesize,(currentpage-1)*pagesize);
        }
    }
    public int getTotalCount(int categoryid,int isrecommend,String key){
        StringBuffer sql=new StringBuffer(512);
        sql.append("SELECT  count(*) FROM t_ebook,t_category where t_ebook.CategoryId=t_category.id ");
        if(categoryid>0) sql.append(" and t_ebook.CategoryId="+categoryid);        
        if(isrecommend>0) sql.append(" and t_ebook.IsRecommend="+isrecommend);
        if(key!=null) sql.append(" and t_ebook.Label like '%"+key+"%'");
        return(this.getDataCount(sql.toString()));
    }
    public DataField get(int id){
        String fields="CategoryId,Title,ViewImg,Publisher,PubDate,Content,FileSize,ReadUrl,DownUrl,Label,IsRecommend,Hits,Agree,Degree,Fdesc";
        return getFirstData("select "+fields+" from t_ebook where id="+id,fields);
    }
    public DataField getShow(int id){
        String fields="Title,ViewImg,Publisher,PubDate,Content,FileSize,ReadUrl,DownUrl,Label,IsRecommend,Hits,Agree,Degree,Fdesc,CategoryId";
        StringBuffer sql=new StringBuffer();
        sql.append("SELECT t_ebook.Title as etitle,t_ebook.ViewImg,Publisher,PubDate,Content,FileSize,ReadUrl,DownUrl,Label,IsRecommend,Hits,Agree,Degree,Fdesc,t_category.Title as ctitle FROM t_ebook,t_category where t_ebook.CategoryId=t_category.id  and t_ebook.id="+id);
        return getFirstData(sql.toString(),fields);
    }
}
