/*
 * EbookLabelDaoImplJDBC.java
 *
 * Created on 200836, 9:12
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package tot.dao.jdbc;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.util.StringUtils;
import tot.bean.*;
import tot.exception.ObjectNotFoundException;
import tot.exception.DatabaseException;
import java.sql.*;
import java.util.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 *
 * @author Administrator
 */
public class EbookLabelDaoImplJDBC extends AbstractDao{
    private static Log log = LogFactory.getLog(EbookLabelDaoImplJDBC.class);
    /** Creates a new instance of EbookLabelDaoImplJDBC */
    public EbookLabelDaoImplJDBC() {
    }
    public boolean isExits(String title){
        boolean returnValue=false;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement("select * from t_ebook_label where Title=?");
            ps.setString(1,title);
            rs=ps.executeQuery();
            if(rs.next()){
                returnValue=true;
            }else{
                returnValue=false;
            }
        } catch(SQLException e){
            e.printStackTrace();            
        } finally{
            DBUtils.closeResultSet(rs);
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
     public boolean add(String title){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        String sql="insert into t_ebook_label(Title) values(?)";
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setString(1,title);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            log.error("add ebook label error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    
    /* delete floor level by id */
    public boolean del(int id) throws ObjectNotFoundException,DatabaseException{
        return exe("delete from t_ebook_label where id="+id);
    }
    public void upHits(int id) throws ObjectNotFoundException,DatabaseException{
        exe("update t_eebook_label set Hits=Hits+1 where id="+id);
    }
    /* get area count */
    public int getTotalCount(){
        String sql="select count(*) from t_ebook_label";        
        return(this.getDataCount(sql));
    }    
    /* get list */
    public Collection getList(int orderby,int currentpage,int pagesize){
        String str="id";
        if(orderby==1){
            str="Hits";
        }
        StringBuffer sql=new StringBuffer(512);
        String fieldArr="id,Title";
        if (DBUtils.getDatabaseType() == DBUtils.DATABASE_SQLSERVER) {
            sql.append("select top ");
            sql.append(pagesize);
            sql.append(fieldArr);
            sql.append(" from t_ebook_label WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP "+((currentpage-1)*pagesize+1)+" id  FROM t_ebook_label");            
            sql.append(" ORDER BY id DESC) AS t))");            
            sql.append(" ORDER BY id DESC");
            return this.getData(sql.toString(),fieldArr);
        } else if(DBUtils.getDatabaseType() == DBUtils.DATABASE_MYSQL){
            sql.append("select ");
            sql.append(fieldArr);
            sql.append(" from t_ebook_label");            
            sql.append(" order by id desc limit ");
            sql.append((currentpage-1)*pagesize);
            sql.append(",");
            sql.append(pagesize);
            return this.getData(sql.toString(),fieldArr);
        }else{
            sql.append("select ");
            sql.append(fieldArr);
            sql.append(" from t_ebook_label");            
            sql.append(" order by id desc");
            return getDataList_Limit_Normal(sql.toString(),fieldArr,pagesize,(currentpage-1)*pagesize);
        }
    }    
    public void batDel(String[] s){
        this.bat("delete from t_ebook_label where id=?",s);
    }
}
