/*
 * EduCommenDaoImplJDBC.java
 *
 * Created on 200835, 7:56
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package tot.dao.jdbc;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.bean.*;
import tot.exception.ObjectNotFoundException;
import tot.exception.DatabaseException;
import java.sql.*;
import java.util.*;
import java.io.StringReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 *
 * @author Administrator
 */
public class EduCommenDaoImplJDBC extends AbstractDao{
    private static Log log = LogFactory.getLog(EduCommenDaoImplJDBC.class);
    /** Creates a new instance of EduCommenDaoImplJDBC */
    public EduCommenDaoImplJDBC() {
    }
    /** add GuestBook */
    public boolean add(int objid,String author,String content,String ip,Timestamp moditime){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        String sql="insert into t_edu_commen(ObjId,Author,Content,Ip,ModiTime) values(?,?,?,?,?)";
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setInt(1,objid);            
            ps.setString(2,author);
            if(DBUtils.getDatabaseType()==DBUtils.DATABASE_ORACLE){
                ps.setCharacterStream(3, new StringReader(content), content.length());
            }else{
                ps.setString(3,content);
            }
            ps.setString(4,ip);           
            ps.setTimestamp(5,moditime);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            log.error("add GuestBook error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    /*
     * mod GuestBook
     */
    public boolean mod(int id,String author,String content){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        String sql="update t_edu_commen set author=?,Content=? where id=?";
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setString(1,author);
            if(DBUtils.getDatabaseType()==DBUtils.DATABASE_ORACLE){
                ps.setCharacterStream(2, new StringReader(content), content.length());
            }else{
                ps.setString(2,content);
            }      
            ps.setInt(3,id);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            log.error("mod GuestBook error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }    
    public DataField get(int id){
        return getFirstData("select id,ObjId,Author,Content,Ip,ModiTime from t_edu_commen where id="+id,"id,ObjId,Author,Content,Ip,ModiTime");
    }
    public boolean del(int id) throws ObjectNotFoundException,DatabaseException{
        return exe("delete from t_edu_commen where id="+id);
    }
    public void batDel(String[] s){
        this.bat("delete from t_edu_commen where id=?",s);
    }    
    public void baRecommend(String[] s,int val){
        this.bat("update t_edu_commen set IsRecommend="+val+" where id=?",s);
    }
    public Collection getListByLimit(int objid,int isrecommend,int infotype,int currentpage,int pagesize){
        if(DBUtils.getDatabaseType() == DBUtils.DATABASE_MYSQL){
            StringBuffer sql=new StringBuffer(512);
            sql.append("select t_edu_commen.id as tid,t_edu_commen.ObjId,t_edu_commen.Author as tauthor,t_edu_commen.Content as tcontent,t_edu_commen.Ip as tip,t_edu_commen.ModiTime as tmod,t_edu_download.Title as dtilte from t_edu_commen,t_edu_download where t_edu_commen.ObjId=t_edu_download.id");
            if(objid>0) sql.append(" and t_edu_commen.ObjId="+objid);  
            if(isrecommend>=0) sql.append(" and t_edu_commen.IsRecommend="+isrecommend);
            if(infotype>=0) sql.append(" and t_edu_download.InfoType="+infotype);  
            sql.append(" order by t_edu_commen.id desc");  
            return getDataList_mysqlLimit(sql.toString(),"id,ObjId,Author,Content,Ip,ModiTime,DownTitle",pagesize,(currentpage-1)*pagesize);
        } else if (DBUtils.getDatabaseType() == DBUtils.DATABASE_SQLSERVER) {
            StringBuffer sql=new StringBuffer(512);
            sql.append("SELECT TOP ");
            sql.append(pagesize);
            sql.append(" id,Author,Content,Ip,ModiTime FROM t_edu_commen WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP ");
            sql.append((currentpage-1)*pagesize+1);
            sql.append(" id  FROM t_edu_commen where 1=1");
            if(objid>0) sql.append(" and ObjId="+objid);            
            sql.append(" ORDER BY id DESC) AS t))");
            if(objid>0) sql.append(" and ObjId="+objid);            
            sql.append(" ORDER BY id DESC");
            return getData(sql.toString(),"id,Author,Content,Ip,ModiTime");
        } else{
            StringBuffer sql=new StringBuffer(512);
            sql.append("select id,Author,Content,Ip,ModiTime from t_edu_commen where 1=1");
            if(objid>0) sql.append(" and ObjId="+objid);            
            return getDataList_Limit_Normal(sql.toString(),"id,Author,Content,Ip,ModiTime",pagesize,(currentpage-1)*pagesize);
        }
    }    
    public int getTotalCount(int objid,int isrecommend,int infotype){
        StringBuffer sql=new StringBuffer(512);
        sql.append("select count(*) from t_edu_commen,t_edu_download where t_edu_commen.ObjId=t_edu_download.id");
        if(objid>0){
            sql.append(" and t_edu_commen.ObjId=");
            sql.append(objid);
        }        
        if(infotype>=0) sql.append(" and t_edu_download.InfoType="+infotype); 
        if(isrecommend>=0) sql.append(" and t_edu_commen.IsRecommend="+isrecommend);
        return(this.getDataCount(sql.toString()));
    }
}
