/*
 * EduVersionDaoImplJDBC.java
 *
 * Created on 200835, 2:43
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package tot.dao.jdbc;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.bean.*;
import tot.exception.ObjectNotFoundException;
import tot.exception.DatabaseException;
import java.sql.*;
import java.util.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 *
 * @author Administrator
 */
public class EduSubjectDaoImplJDBC extends AbstractDao{
    private static Log log = LogFactory.getLog(EduSubjectDaoImplJDBC.class);
    /**
     * Creates a new instance of EduVersionDaoImplJDBC
     */
    public EduSubjectDaoImplJDBC() {
    }
    /*
     * get last id
     */
    public int getLastId(){
        DataField df=null;
        int returnValue=0;
        String sql=null;
        sql="select id from t_edu_subject order by id desc";
        Collection lists =this.getDataList_Limit_Normal(sql,"id",1,0);
            Iterator iter = lists.iterator();
            if (iter.hasNext()) {
                df= (DataField)iter.next();                
            }
        if(df!=null){
            returnValue=Integer.parseInt(df.getFieldValue("id"))+1;
        }else{
            returnValue=1;
        }
        return returnValue;        
    }
    public String getTitle(int id){
        DataField df=getFirstData("select Title from t_edu_subject where id="+id,"Title");
        String returnValue=null;
        if(df!=null){
            returnValue=df.getFieldValue("Title");
        }
        return returnValue;
    }
    /** add Keywords */
    public boolean add(String title){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        String sql="insert into t_edu_subject(Title) values(?)";
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);            
            ps.setString(1,title);            
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            log.error("add edu version error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    /*
     * mod Keywords
     */
    public boolean mod(int id,String title){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        String sql="update t_edu_subject set Title=? where id=?";
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);            
            ps.setString(1,title);      
            ps.setInt(2,id);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            log.error("mod edu version error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }    
    public boolean del(int id) throws ObjectNotFoundException,DatabaseException{
        return exe("delete from t_edu_subject where id="+id);
    }    
    
    public Collection getList_Limit(int currentpage,int pagesize){
        if(DBUtils.getDatabaseType() == DBUtils.DATABASE_MYSQL){
            StringBuffer sql=new StringBuffer(512);
            sql.append("select id,Title from t_edu_subject order by id asc");            
            return getDataList_mysqlLimit(sql.toString(),"id,Title",pagesize,(currentpage-1)*pagesize);
        } else if (DBUtils.getDatabaseType() == DBUtils.DATABASE_SQLSERVER) {
            StringBuffer sql=new StringBuffer(512);
            sql.append("SELECT TOP ");
            sql.append(pagesize);
            sql.append(" id,Title FROM t_edu_subject WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP ");
            sql.append((currentpage-1)*pagesize+1);
            sql.append(" id  FROM t_edu_subject");            
            sql.append(" ORDER BY id DESC) AS t))");            
            sql.append(" ORDER BY id DESC");
            return getData(sql.toString(),"id,Title");
        } else{
            StringBuffer sql=new StringBuffer(512);
            sql.append("select id,Title from t_edu_subject");            
            return getDataList_Limit_Normal(sql.toString(),"id,Title",pagesize,(currentpage-1)*pagesize);
        }
    }
    public DataField get(int id){
        return getFirstData("select id,Title from t_edu_subject where id="+id,"id,Title");
    }
    public int getTotalCount(){
        StringBuffer sql=new StringBuffer(512);
        sql.append("select count(*) from t_edu_subject");        
        return(this.getDataCount(sql.toString()));
    }
    public void batDel(String[] s){
        this.bat("delete from t_edu_subject where id=?",s);
    }
    public String getOptions(int cid) {        
        StringBuffer returnStr=new StringBuffer(512);
        String ifSele="";        
        ArrayList categoryList=(ArrayList)getData("select id,Title from t_edu_subject order by id asc","id,Title");
        for (Iterator iter = categoryList.iterator(); iter.hasNext(); ) {
            DataField df=(DataField)iter.next();
            if(cid==Integer.parseInt(df.getFieldValue("id"))){
                ifSele=" selected";
            }else{
                ifSele="";
            }
            returnStr.append("<option value=\""+ df.getFieldValue("id")+"\""+ifSele+">"+df.getFieldValue("Title")+"</option>"+"\n");                      
        }        
        return returnStr.toString();
    }
}
