/*
 * FetchDaoImplJDBC.java
 *
 * Created on 2008222, 10:14
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package tot.dao.jdbc;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.util.StringUtils;
import tot.global.Sysconfig;
import tot.exception.ObjectNotFoundException;
import tot.exception.DatabaseException;
import java.sql.*;
import java.util.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.bean.DataField;
/**
 *
 * @author Administrator
 */
public class FetchDaoImplJDBC extends AbstractDao{
    private static Log log = LogFactory.getLog(FetchDaoImplJDBC.class);
    /** Creates a new instance of FetchDaoImplJDBC */
    public FetchDaoImplJDBC() {
    }
    /** add fetch */
    public boolean addFetch(String userid,Float fmoney,int fstatus,Timestamp moditime){
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue=true;
        String sql="insert into t_fetch(UserId,Fmoney,Fstatus,Fdate) values(?,?,?,?)";
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setString(1,userid);
            ps.setFloat(2,fmoney);
            ps.setInt(3,fstatus);
            ps.setTimestamp(4,moditime);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){
            log.error("add fetch error",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    public boolean delFetch(int id) throws ObjectNotFoundException,DatabaseException{
        return exe("delete from t_fetch where id="+id);
    }
    public void batDel(String[] s){
        this.bat("delete from t_fetch where id=?",s);
    }
    public void batStatus(String[] s,int val){
        this.bat("update t_fetch set Fstatus="+val+" where id=?",s);
    }
    public boolean updateStatus(int id,int val) throws ObjectNotFoundException,DatabaseException{
        return exe("update t_fetch set Fstatus="+val+" where id="+id);
    }
    public Collection getFetchList_Limit(int status,String dateStart,String dateEnd,int currentpage,int pagesize){
        String fields="id,UserId,Fmoney,Fstatus,Fdate";
        StringBuffer sql=new StringBuffer(512);
        if(DBUtils.getDatabaseType() == DBUtils.DATABASE_MYSQL){
            sql.append("select "+fields+" from t_fetch where Fstatus="+status);
            if(dateStart!=null && dateEnd!=null){
                sql.append(" and to_days(Fdate)>=to_days('").append(dateStart).append("') and to_days(Fdate)<=to_days('").append(dateEnd).append("')");
            }
            return getDataList_mysqlLimit(sql.toString(),fields,pagesize,(currentpage-1)*pagesize);
        } else if (DBUtils.getDatabaseType() == DBUtils.DATABASE_SQLSERVER) {
            //String sql="SELECT TOP "+pagesize+" "+fields+" FROM t_fetch WHERE (id <=(SELECT MIN(id) FROM (SELECT TOP "+((currentpage-1)*pagesize+1)+" id  FROM t_fetch where Fstatus="+status+" ORDER BY id DESC) AS t)) and Fstatus="+status+" ORDER BY id DESC";
            return getData(sql.toString(),fields);
        } else{
            return getDataList_Limit_Normal("select "+fields+" from t_fetch",fields,pagesize,(currentpage-1)*pagesize);
        }
    }
    public int getTotalCount(int status,String dateStart,String dateEnd){
        StringBuffer sql=new StringBuffer(512);
        sql.append("select count(*) from t_fetch where Fstatus="+status);
        if(dateStart!=null && dateEnd!=null){
                sql.append(" and to_days(Fdate)>=to_days('").append(dateStart).append("') and to_days(Fdate)<=to_days('").append(dateEnd).append("')");
            }
        return(this.getDataCount(sql.toString()));
    }
}
